/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.export.Arch;
import jycessing.mode.export.ImportExtractor;
import jycessing.mode.export.LinuxExport;
import jycessing.mode.export.MacExport;
import jycessing.mode.export.WindowsExport;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;

public class Exporter {
    public static final Arch processingArch = Platform.getNativeBits() == Arch.X86.bits ? Arch.X86 : Arch.AMD64;
    private final Sketch sketch;
    private final PyEditor editor;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(Exporter.class.getSimpleName()) + ": " + msg);
        }
    }

    public Exporter(PyEditor editor, Sketch sketch) {
        this.sketch = sketch;
        this.editor = editor;
    }

    public void export() {
        Set<Library> libraries = new ImportExtractor(this.sketch).getLibraries();
        if (Preferences.getBoolean((String)"export.application.platform.linux")) {
            try {
                new LinuxExport(Arch.X86, this.sketch, this.editor, libraries).export();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.editor.statusError("Export to linux32 failed!");
            }
            try {
                new LinuxExport(Arch.AMD64, this.sketch, this.editor, libraries).export();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.editor.statusError("Export to linux64 failed!");
            }
        }
        if (Preferences.getBoolean((String)"export.application.platform.windows")) {
            try {
                new WindowsExport(Arch.X86, this.sketch, this.editor, libraries).export();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.editor.statusError("Export to windows32 failed!");
            }
            try {
                new WindowsExport(Arch.AMD64, this.sketch, this.editor, libraries).export();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.editor.statusError("Export to windows64 failed!");
            }
        }
        if (Preferences.getBoolean((String)"export.application.platform.macosx")) {
            try {
                new MacExport(this.sketch, this.editor, libraries).export();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.editor.statusError("Export to macosx failed!");
            }
        }
        Exporter.log("Opening result folder.");
        Platform.openFolder((File)this.sketch.getFolder());
    }
}

