/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jycessing.DisplayType;
import jycessing.RunnableSketch;
import jycessing.Runner;

public class ExportedSketch
implements RunnableSketch {
    public static final String ARGS_EXPORTED = "--exported";
    private final File sketchPath;
    private final File sketchHome;
    private final String code;
    private final DisplayType displayType;
    private final String backgroundColor;
    private final String stopColor;
    private final List<File> libraryDirs;

    public ExportedSketch(String[] args) throws Exception {
        File codeDir;
        this.sketchPath = new File(args[args.length - 1]).getAbsoluteFile();
        this.sketchHome = this.sketchPath.getParentFile().getParentFile();
        if (!this.sketchPath.exists()) {
            throw new FileNotFoundException("Something is terribly wrong - I can't find your sketch!");
        }
        List<String> codeLines = Files.readAllLines(this.sketchPath.toPath(), Charset.forName("UTF-8"));
        StringBuilder code2 = new StringBuilder();
        for (String line : codeLines) {
            code2.append(line);
            code2.append('\n');
        }
        this.code = code2.toString();
        this.displayType = Arrays.asList(args).contains("fullScreen") ? DisplayType.PRESENTATION : DisplayType.WINDOWED;
        String backgroundColor = null;
        String stopColor = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains("BGCOLOR")) {
                backgroundColor = arg.substring(arg.indexOf("=") + 1);
            } else if (arg.contains("--stop-color")) {
                stopColor = arg.substring(arg.indexOf("=") + 1);
            }
            ++n2;
        }
        this.backgroundColor = backgroundColor;
        this.stopColor = stopColor;
        ArrayList<File> libraryDirs = new ArrayList<File>();
        libraryDirs.add(this.sketchPath.getParentFile());
        File libDir = new File(this.getHomeDirectory(), "lib");
        if (libDir.exists()) {
            libraryDirs.add(libDir);
        }
        if ((codeDir = new File(this.getHomeDirectory(), "code")).exists()) {
            libraryDirs.add(codeDir);
        }
        this.libraryDirs = libraryDirs;
    }

    @Override
    public File getMainFile() {
        return this.sketchPath;
    }

    @Override
    public String getMainCode() {
        return this.code;
    }

    @Override
    public File getHomeDirectory() {
        return this.sketchHome;
    }

    @Override
    public String[] getPAppletArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.displayType == DisplayType.PRESENTATION) {
            args.add("fullScreen");
            args.add("BGCOLOR=" + this.backgroundColor);
            if (this.stopColor != null) {
                args.add("--stop-color=" + this.stopColor);
            } else {
                args.add("--hide-stop");
            }
        }
        args.add("--sketch-path=" + this.getHomeDirectory());
        args.add(this.sketchPath.getName());
        return args.toArray(new String[0]);
    }

    @Override
    public List<File> getLibraryDirectories() {
        return this.libraryDirs;
    }

    @Override
    public Runner.LibraryPolicy getLibraryPolicy() {
        return Runner.LibraryPolicy.PROMISCUOUS;
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public List<File> getPathEntries() {
        ArrayList<File> entries = new ArrayList<File>();
        entries.add(this.sketchHome);
        entries.add(new File(this.sketchHome, "source"));
        entries.add(new File(this.sketchHome, "lib"));
        return entries;
    }
}

