/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.export.Exporter;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.ui.ColorChooser;

public class ExportDialog
extends JDialog {
    private final Sketch sketch;
    private final PyEditor editor;
    private final JOptionPane optionPane;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(ExportDialog.class.getSimpleName()) + ": " + msg);
        }
    }

    public ExportDialog(PyEditor editor, Sketch sketch) {
        super((Frame)((Object)editor), "Export Application", true);
        this.editor = editor;
        this.sketch = sketch;
        ExportDialog.log("Setting up export dialog");
        JPanel center = this.createCenterPanel();
        JPanel platforms = this.createPlatformsPanel();
        center.add(platforms);
        JPanel present = this.createPresentPanel();
        center.add(present);
        JPanel embed = this.createEmbedJavaPanel(platforms.getPreferredSize().width);
        center.add(embed);
        if (Platform.isMacOS()) {
            JPanel signingProblems = this.createMacSigningWarning(platforms.getPreferredSize().width);
            center.add(signingProblems);
        }
        Object[] options = new String[]{"Export", "Cancel"};
        this.optionPane = new JOptionPane(center, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (ExportDialog.this.isVisible() && e.getSource() == ExportDialog.this.optionPane && prop.equals("value")) {
                    ExportDialog.this.setVisible(false);
                }
            }
        });
        this.pack();
        this.setResizable(false);
        Rectangle bounds = editor.getBounds();
        Dimension size = this.getSize();
        this.setLocation(bounds.x + (bounds.width - size.width) / 2, bounds.y + (bounds.height - size.height) / 2);
    }

    public void go() {
        ExportDialog.log("Launching export dialog");
        this.setVisible(true);
        Object value = this.optionPane.getValue();
        if (value.equals("Export")) {
            new Exporter(this.editor, this.sketch).export();
        } else {
            this.editor.statusNotice("Export to Application Cancelled");
        }
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        String line1 = "Export to Application creates double-clickable,";
        String line2 = "standalone applications for the selected plaforms.";
        JLabel label1 = new JLabel("Export to Application creates double-clickable,", 0);
        JLabel label2 = new JLabel("standalone applications for the selected plaforms.", 0);
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        panel.add(label1);
        panel.add(label2);
        panel.add(Box.createVerticalStrut(12));
        return panel;
    }

    private JPanel createPlatformsPanel() {
        final JCheckBox windowsButton = new JCheckBox("Windows");
        windowsButton.setSelected(Preferences.getBoolean((String)"export.application.platform.windows"));
        windowsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)"export.application.platform.windows", (boolean)windowsButton.isSelected());
            }
        });
        final JCheckBox macosxButton = new JCheckBox("Mac OS X");
        macosxButton.setSelected(Preferences.getBoolean((String)"export.application.platform.macosx"));
        macosxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)"export.application.platform.macosx", (boolean)macosxButton.isSelected());
            }
        });
        final JCheckBox linuxButton = new JCheckBox("Linux");
        linuxButton.setSelected(Preferences.getBoolean((String)"export.application.platform.linux"));
        linuxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)"export.application.platform.linux", (boolean)linuxButton.isSelected());
            }
        });
        JPanel platformPanel = new JPanel();
        platformPanel.add(windowsButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(macosxButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(linuxButton);
        platformPanel.setBorder(new TitledBorder("Platforms"));
        platformPanel.setAlignmentX(0.0f);
        return platformPanel;
    }

    private JPanel createPresentPanel() {
        JPanel presentPanel = new JPanel();
        presentPanel.setLayout(new BoxLayout(presentPanel, 1));
        final JCheckBox showStopButton = new JCheckBox("Show a Stop button");
        showStopButton.setSelected(Preferences.getBoolean((String)"export.application.stop"));
        showStopButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)"export.application.stop", (boolean)showStopButton.isSelected());
            }
        });
        showStopButton.setEnabled(Preferences.getBoolean((String)"export.application.fullscreen"));
        showStopButton.setBorder(new EmptyBorder(3, 13, 6, 13));
        final JCheckBox fullScreenButton = new JCheckBox("Full Screen (Present mode)");
        fullScreenButton.setSelected(Preferences.getBoolean((String)"export.application.fullscreen"));
        fullScreenButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = fullScreenButton.isSelected();
                Preferences.setBoolean((String)"export.application.fullscreen", (boolean)selected);
                showStopButton.setEnabled(selected);
            }
        });
        fullScreenButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        Box fullScreenBox = Box.createHorizontalBox();
        fullScreenBox.add(fullScreenButton);
        fullScreenBox.add(new ColorPreference("run.present.bgcolor", this.editor));
        fullScreenBox.add(Box.createHorizontalStrut(10));
        fullScreenBox.add(Box.createHorizontalGlue());
        presentPanel.add(fullScreenBox);
        Box showStopBox = Box.createHorizontalBox();
        showStopBox.add(showStopButton);
        showStopBox.add(new ColorPreference("run.present.stop.color", this.editor));
        showStopBox.add(Box.createHorizontalStrut(10));
        showStopBox.add(Box.createHorizontalGlue());
        presentPanel.add(showStopBox);
        presentPanel.setBorder(new TitledBorder("Full Screen"));
        presentPanel.setAlignmentX(0.0f);
        return presentPanel;
    }

    private JPanel createEmbedJavaPanel(int divWidth) {
        JPanel embedPanel = new JPanel();
        embedPanel.setLayout(new BoxLayout(embedPanel, 1));
        String platformName = null;
        if (Platform.isMacOS()) {
            platformName = "Mac OS X";
        } else if (Platform.isWindows()) {
            platformName = "Windows (" + Platform.getNativeBits() + "-bit)";
        } else if (Platform.isLinux()) {
            platformName = "Linux (" + Platform.getNativeBits() + "-bit)";
        }
        boolean embed = Preferences.getBoolean((String)"export.application.embed_java");
        final String embedWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">" + "Embedding Java will make the " + platformName + " application " + "larger, but it will be far more likely to work. " + "Users on other platforms will need to <a href=\"\">install Java 7</a>.";
        final String nopeWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">" + "Users on all platforms will have to install the latest " + "version of Java 7 from <a href=\"\">http://java.com/download</a>. " + "<br/>&nbsp;";
        final JLabel warningLabel = new JLabel(embed ? embedWarning : nopeWarning);
        warningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Platform.openURL((String)"http://java.com/download");
            }
        });
        warningLabel.setBorder(new EmptyBorder(3, 13, 3, 13));
        final JCheckBox embedJavaButton = new JCheckBox("Embed Java for " + platformName);
        embedJavaButton.setSelected(embed);
        embedJavaButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = embedJavaButton.isSelected();
                Preferences.setBoolean((String)"export.application.embed_java", (boolean)selected);
                if (selected) {
                    warningLabel.setText(embedWarning);
                } else {
                    warningLabel.setText(nopeWarning);
                }
            }
        });
        embedJavaButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        embedPanel.add(embedJavaButton);
        embedPanel.add(warningLabel);
        embedPanel.setBorder(new TitledBorder("Embed Java"));
        return embedPanel;
    }

    private JPanel createMacSigningWarning(int divWidth) {
        JPanel signPanel = new JPanel();
        signPanel.setLayout(new BoxLayout(signPanel, 1));
        signPanel.setBorder(new TitledBorder("Code Signing"));
        StringBuilder thePain = new StringBuilder("In recent versions of OS X, Apple has introduced the \u201cGatekeeper\u201d system, which makes it more difficult to run applications like those exported from Processing. ");
        if (new File("/usr/bin/codesign_allocate").exists()) {
            thePain.append("This application will be \u201cself-signed\u201d which means that Finder may report that the application is from an \u201cunidentified developer\u201d. If the application will not run, try right-clicking the app and selecting Open from the pop-up menu. Or you can visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. ");
        } else {
            thePain.append("Gatekeeper requires applications to be \u201csigned\u201d, or they will be reported as damaged. To prevent this message, install Xcode (and the Command Line Tools) from the App Store, or visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. ");
        }
        thePain.append("To avoid the messages entirely, manually code sign your app. For more information: <a href=\"\">https://developer.apple.com/developer-id/</a>");
        JLabel area = new JLabel("<html><div width=\"" + divWidth + "\"><font size=\"2\">" + thePain.toString() + "</div></html>");
        area.setBorder(new EmptyBorder(3, 13, 3, 13));
        signPanel.add(area);
        signPanel.setAlignmentX(0.0f);
        area.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Platform.openURL((String)"https://developer.apple.com/developer-id/");
            }
        });
        return signPanel;
    }

    static class ColorPreference
    extends JPanel
    implements ActionListener {
        ColorChooser chooser;
        String prefName;

        public ColorPreference(String pref, final PyEditor editor) {
            this.prefName = pref;
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(30, 20));
            this.setMaximumSize(new Dimension(30, 20));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Color color = Preferences.getColor((String)ColorPreference.this.prefName);
                    ColorPreference.this.chooser = new ColorChooser((Frame)((Object)editor), true, color, "Select", (ActionListener)ColorPreference.this);
                    ColorPreference.this.chooser.show();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Preferences.getColor((String)this.prefName));
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.chooser.getColor();
            Preferences.setColor((String)this.prefName, (Color)color);
            this.repaint();
            this.chooser.hide();
        }
    }
}

