/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import java.io.File;
import java.io.IOException;
import jycessing.mode.FormatServer;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonTokenMarker;
import jycessing.mode.run.SketchServiceManager;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.syntax.TokenMarker;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;

public class PythonMode
extends Mode {
    public static final boolean VERBOSE = Boolean.parseBoolean(System.getenv("VERBOSE_PYTHON_MODE"));
    public static final boolean SKETCH_RUNNER_FIRST = Boolean.parseBoolean(System.getenv("SKETCH_RUNNER_FIRST"));
    private final FormatServer formatServer;
    private final SketchServiceManager sketchServiceManager;

    public PythonMode(Base base2, File folder) {
        super(base2, folder);
        this.formatServer = new FormatServer(folder);
        this.sketchServiceManager = new SketchServiceManager(this);
        this.librariesFolder = Platform.getContentFile((String)"modes/java/libraries");
    }

    public String getTitle() {
        return "Python";
    }

    public Editor createEditor(Base base2, String path, EditorState state) {
        if (!this.formatServer.isStarted()) {
            this.formatServer.start();
        }
        if (!this.sketchServiceManager.isStarted()) {
            this.sketchServiceManager.start();
        }
        try {
            return new PyEditor(base2, path, state, this);
        }
        catch (EditorException e) {
            Messages.showError((String)"Editor Exception", (String)"Issue Creating Editor", (Throwable)e);
            return null;
        }
    }

    public String getDefaultExtension() {
        return "pyde";
    }

    public String getModuleExtension() {
        return "py";
    }

    public String[] getExtensions() {
        return new String[]{this.getDefaultExtension(), this.getModuleExtension()};
    }

    public String[] getIgnorable() {
        return new String[0];
    }

    Formatter getFormatter() {
        return this.formatServer;
    }

    protected void loadKeywords(File keywordFile) throws IOException {
        this.loadKeywords(keywordFile, "//");
    }

    public TokenMarker createTokenMarker() {
        return new PythonTokenMarker();
    }

    public SketchServiceManager getSketchServiceManager() {
        return this.sketchServiceManager;
    }
}

