/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jycessing.mode.PyEditor;
import processing.app.Sketch;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeInputHandler;
import processing.app.ui.Editor;

public class PyInputHandler
extends PdeInputHandler {
    final PyEditor pyEditor;
    private static int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String TAB = "    ";
    private static final int TAB_SIZE = "    ".length();
    private static final Pattern LINE = Pattern.compile("^(\\s*)(.*)$");
    private static final Pattern INITIAL_WHITESPACE = Pattern.compile("^(\\s*)");
    private static final Pattern TERMINAL_COLON = Pattern.compile(":\\s*(#.*)?$");
    private static final Pattern POP_CONTEXT = Pattern.compile("^\\s*(return|break|continue)\\b");

    public PyInputHandler(Editor editor) {
        this.pyEditor = (PyEditor)editor;
    }

    private static boolean isPrintableChar(char c) {
        if (c >= ' ' && c <= '\u007f') {
            return true;
        }
        if (c == '\uffff' || Character.isISOControl(c)) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    JEditTextArea getTextArea() {
        return this.pyEditor.getTextArea();
    }

    public boolean handlePressed(KeyEvent event) {
        char c = event.getKeyChar();
        int code2 = event.getKeyCode();
        int mods = event.getModifiers();
        JEditTextArea textArea = this.getTextArea();
        Sketch sketch = this.pyEditor.getSketch();
        if (!event.isMetaDown() && (code2 == 8 || code2 == 9 || code2 == 10 || PyInputHandler.isPrintableChar(c))) {
            sketch.setModified(true);
        }
        if (event.isMetaDown() && code2 == 38) {
            textArea.setCaretPosition(0);
            textArea.scrollToCaret();
            return true;
        }
        if (event.isMetaDown() && code2 == 40) {
            textArea.setCaretPosition(textArea.getDocumentLength());
            textArea.scrollToCaret();
            return true;
        }
        if ((mods & CTRL_ALT) == CTRL_ALT) {
            if (code2 == 37) {
                sketch.handlePrevCode();
                return true;
            }
            if (code2 == 39) {
                sketch.handleNextCode();
                return true;
            }
        }
        int thisLine = textArea.getCaretLine();
        int thisPos = textArea.getCaretPosition();
        switch (code2) {
            case 8: {
                if (thisPos == textArea.getLineStartOffset(thisLine)) break;
                LineInfo currentLine = new LineInfo(thisLine);
                if (currentLine.caretInText) break;
                this.indent(-1);
                return true;
            }
            case 27: {
                textArea.selectNone();
                this.pyEditor.handleStop();
                return true;
            }
            case 9: {
                this.indent(event.isShiftDown() ? -1 : 1);
                return true;
            }
            case 10: {
                String text2 = textArea.getText();
                textArea.setSelectedText(this.newline());
            }
        }
        return false;
    }

    public void indent(int sign) {
        int newIndent;
        JEditTextArea textArea = this.getTextArea();
        int startLine = textArea.getSelectionStartLine();
        int stopLine = textArea.getSelectionStopLine();
        int selectionStart = textArea.getSelectionStart();
        int selectionStop = textArea.getSelectionStop();
        LineInfo currentLine = new LineInfo(startLine);
        int currentCaret = textArea.getCaretPosition();
        int startLineEndRelativePos = textArea.getLineStopOffset(startLine) - selectionStart;
        int stopLineEndRelativePos = textArea.getLineStopOffset(stopLine) - selectionStop;
        if (sign > 0) {
            String trimmed;
            LineInfo candidate = null;
            int i = startLine - 1;
            while (i >= 0) {
                candidate = new LineInfo(i);
                if (candidate.text.length() > 0 && !candidate.text.startsWith("#")) break;
                --i;
            }
            newIndent = candidate == null ? 0 : ((trimmed = candidate.text.trim()).endsWith(":") || trimmed.endsWith("(") ? Math.min(candidate.indent + 1, currentLine.indent + 1) : Math.min(candidate.indent, currentLine.indent + 1));
        } else {
            newIndent = Math.max(0, currentLine.indent - 1);
        }
        int deltaIndent = newIndent - currentLine.indent;
        int i = startLine;
        while (i <= stopLine) {
            this.indentLineBy(i, deltaIndent);
            ++i;
        }
        textArea.setSelectionStart(this.getAbsoluteCaretPositionRelativeToLineEnd(startLine, startLineEndRelativePos));
        textArea.setSelectionEnd(this.getAbsoluteCaretPositionRelativeToLineEnd(stopLine, stopLineEndRelativePos));
    }

    private int getAbsoluteCaretPositionRelativeToLineEnd(int line, int lineEndRelativePosition) {
        JEditTextArea textArea = this.getTextArea();
        return Math.max(textArea.getLineStopOffset(line) - lineEndRelativePosition, textArea.getLineStartOffset(line));
    }

    private void indentLineBy(int line, int deltaIndent) {
        JEditTextArea textArea = this.getTextArea();
        LineInfo currentLine = new LineInfo(line);
        int newIndent = Math.max(0, currentLine.indent + deltaIndent);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < newIndent) {
            sb.append(TAB);
            ++i;
        }
        sb.append(currentLine.text);
        textArea.select(textArea.getLineStartOffset(line), textArea.getLineStopOffset(line) - 1);
        textArea.setSelectedText(sb.toString());
        textArea.selectNone();
    }

    private boolean isOpen(char c) {
        return c == '(' || c == '[' || c == '{';
    }

    private boolean isClose(char c) {
        return c == ')' || c == ']' || c == '}';
    }

    private int indexOfUnclosedParen() {
        JEditTextArea textArea = this.getTextArea();
        int cursor = textArea.getCaretPosition();
        String text2 = textArea.getText();
        Stack<Integer> stack = new Stack<Integer>();
        int column = 0;
        int i = 0;
        while (i < cursor) {
            char c = text2.charAt(i);
            if (this.isOpen(c)) {
                stack.push(column);
            } else if (this.isClose(c)) {
                if (stack.size() == 0) {
                    return -1;
                }
                stack.pop();
            }
            column = c == '\n' ? 0 : ++column;
            ++i;
        }
        return stack.size() > 0 ? (Integer)stack.pop() : -1;
    }

    private String indentOf(String line) {
        Matcher m = INITIAL_WHITESPACE.matcher(line);
        if (!m.find()) {
            throw new AssertionError((Object)"How can there be nothing?");
        }
        return m.group();
    }

    private String getInitialWhitespace() {
        JEditTextArea textArea = this.getTextArea();
        String text2 = textArea.getText();
        int cursor = textArea.getCaretPosition();
        int lineNumber = textArea.getLineOfOffset(cursor);
        int lineStart = textArea.getLineStartOffset(lineNumber);
        int lineEnd = textArea.getLineStopOffset(lineNumber);
        String line = textArea.getLineText(lineNumber);
        String defaultIndent = this.indentOf(line);
        int balance = 0;
        int i = cursor - 1;
        while (i >= lineStart) {
            if (this.isClose(text2.charAt(i))) {
                ++balance;
            } else if (this.isOpen(text2.charAt(i))) {
                --balance;
            }
            --i;
        }
        if (balance == 0) {
            return defaultIndent;
        }
        if (balance > 0) {
            int index = lineStart - 1;
            while (balance > 0 && index >= 0) {
                if (this.isClose(text2.charAt(index))) {
                    ++balance;
                } else if (this.isOpen(text2.charAt(index))) {
                    --balance;
                }
                --index;
            }
            if (balance != 0) {
                return defaultIndent;
            }
            return this.indentOf(textArea.getLineText(textArea.getLineOfOffset(index)));
        }
        int parenColumn = this.indexOfUnclosedParen();
        if (parenColumn > -1) {
            return PyInputHandler.nSpaces(parenColumn + 1);
        }
        return defaultIndent;
    }

    private String newline() {
        JEditTextArea textArea = this.getTextArea();
        int cursor = textArea.getCaretPosition();
        if (cursor <= 1) {
            return "\n";
        }
        int lineNumber = textArea.getLineOfOffset(cursor);
        int lineStart = textArea.getLineStartOffset(lineNumber);
        String line = textArea.getLineText(lineNumber);
        String initialWhitespace = this.getInitialWhitespace();
        String lineTextBeforeCursor = line.substring(0, cursor - lineStart);
        if (Pattern.matches("\\s*", lineTextBeforeCursor)) {
            return "\n" + initialWhitespace;
        }
        if (TERMINAL_COLON.matcher(line).find()) {
            return "\n" + initialWhitespace + TAB;
        }
        if (POP_CONTEXT.matcher(line).find()) {
            int currentIndentLength = initialWhitespace.length();
            int spaceCount = Math.max(0, currentIndentLength - 4);
            return "\n" + PyInputHandler.nSpaces(spaceCount);
        }
        return "\n" + initialWhitespace;
    }

    private static final String nSpaces(int n) {
        StringBuilder sb = new StringBuilder(n);
        int i = 0;
        while (i < n) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private class LineInfo {
        public final int lineNumber;
        public final int indent;
        public final String text;
        public final boolean caretInText;

        LineInfo(int lineNumber) {
            this.lineNumber = lineNumber;
            JEditTextArea textArea = PyInputHandler.this.getTextArea();
            Matcher m = LINE.matcher(textArea.getLineText(lineNumber));
            if (!m.matches()) {
                throw new AssertionError((Object)"How can a line have less than nothing in it?");
            }
            String space = m.group(1);
            this.text = m.group(2);
            int caretLinePos = textArea.getCaretPosition() - textArea.getLineStartOffset(lineNumber);
            this.caretInText = caretLinePos > space.length();
            int currentIndent = 0;
            int spaceCounter = 0;
            int i = 0;
            while (i < space.length()) {
                if (++spaceCounter % TAB_SIZE == 0 || space.charAt(i) == '\t') {
                    ++currentIndent;
                    spaceCounter = 0;
                }
                ++i;
            }
            this.indent = currentIndent;
        }

        public String toString() {
            return String.format("<Line %d, indent %d, {%s}>", this.lineNumber, this.indent, this.text);
        }
    }
}

