/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import jycessing.mode.PythonMode;
import processing.app.Formatter;
import processing.app.Platform;
import processing.app.exec.StreamPump;

public class FormatServer
implements Formatter {
    private final File modeHome;
    private Process server;
    private volatile boolean started = false;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(FormatServer.class.getSimpleName()) + ": " + msg);
        }
    }

    public FormatServer(File modeHome) {
        this.modeHome = modeHome;
    }

    private static boolean nativePythonAvailable() {
        try {
            return Runtime.getRuntime().exec("python --version").waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ProcessBuilder getPythonProcess(String formatServerPath) {
        if (FormatServer.nativePythonAvailable()) {
            FormatServer.log("Native python available for formatting.");
            return new ProcessBuilder("python", formatServerPath);
        }
        FormatServer.log("Native python not available for formatting.");
        String jython2 = new File(this.modeHome, "mode/jython.jar").getAbsolutePath();
        return new ProcessBuilder(Platform.getJavaPath(), "-jar", jython2, formatServerPath);
    }

    public void start() {
        this.started = true;
        String serverpy = new File(this.modeHome, "formatter/format_server.py").getAbsolutePath();
        final ProcessBuilder pb = this.getPythonProcess(serverpy);
        pb.redirectErrorStream(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FormatServer.log("Starting up the format server.");
                    FormatServer.this.server = pb.start();
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            FormatServer.this.started = false;
                            FormatServer.this.shutdown();
                        }
                    }));
                    new StreamPump(FormatServer.this.server.getInputStream(), "Format Server Output").addTarget((OutputStream)System.err).start();
                }
                catch (Exception e) {
                    throw new RuntimeException(pb.toString(), e);
                }
            }
        }, "FormatServerStarter").start();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void shutdown() {
        this.sendShutdown();
        this.server.destroy();
        this.server = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String format(String text) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                sock = new Socket("localhost", 10011);
                try {
                    block23: {
                        out = new DataOutputStream(sock.getOutputStream());
                        try {
                            block22: {
                                in = new DataInputStream(sock.getInputStream());
                                try {
                                    encoded = text.getBytes("utf-8");
                                    out.writeInt(encoded.length);
                                    out.write(encoded);
                                    out.flush();
                                    resultLength = in.readInt();
                                    buf = new byte[resultLength];
                                    in.readFully(buf);
                                    v0 = new String(buf, "utf-8");
                                    return v0;
                                }
                                finally {
                                    if (in == null) break block22;
                                    in.close();
                                }
                            }
                            if (out == null) break block23;
                        }
                        catch (Throwable var3_6) {
                            if (var2_2 == null) {
                                var2_2 = var3_6;
                            } else if (var2_2 != var3_6) {
                                var2_2.addSuppressed(var3_6);
                            }
                            if (out == null) throw var2_2;
                            out.close();
                            throw var2_2;
                        }
                        out.close();
                    }
                    if (sock != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var3_7) {
                    if (var2_2 == null) {
                        var2_2 = var3_7;
                    } else if (var2_2 != var3_7) {
                        var2_2.addSuppressed(var3_7);
                    }
                    if (sock == null) throw var2_2;
                    sock.close();
                    throw var2_2;
                }
                sock.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var3_8) {
                if (var2_2 == null) {
                    var2_2 = var3_8;
                    throw var2_2;
                }
                if (var2_2 == var3_8) throw var2_2;
                var2_2.addSuppressed(var3_8);
                throw var2_2;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            return text;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendShutdown() {
        FormatServer.log("Sending shutdown message to format server.");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Socket sock = new Socket("localhost", 10011);
                try {
                    try (DataOutputStream out = new DataOutputStream(sock.getOutputStream());){
                        out.writeInt(-1);
                        out.flush();
                    }
                    if (sock == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (sock == null) throw throwable;
                    sock.close();
                    throw throwable;
                }
                sock.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

