/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.lang.reflect.Field;

public class ReflectionUtil {
    public static Field accessibleField(Class<?> c, String fieldName) {
        try {
            Field field = c.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setObjectStatic(Class<T> klass, String fieldName, Object value) {
        try {
            ReflectionUtil.accessibleField(klass, fieldName).set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setBooleanStatic(Class<T> klass, String fieldName, boolean value) {
        try {
            ReflectionUtil.accessibleField(klass, fieldName).set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setObject(T instance, String fieldName, Object value) {
        try {
            ReflectionUtil.accessibleField(instance.getClass(), fieldName).set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setBoolean(T instance, String fieldName, boolean value) {
        try {
            ReflectionUtil.accessibleField(instance.getClass(), fieldName).set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

