/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jycessing.IOUtil;
import jycessing.MixedModeError;
import jycessing.Printer;
import jycessing.PythonSketchError;
import jycessing.Runner;
import jycessing.SketchPositionListener;
import jycessing.mode.run.WrappedPrintStream;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyBoolean;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyIndentationError;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.util.InteractiveConsole;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import processing.core.PSurface;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.javafx.PSurfaceFX;
import processing.opengl.PShader;
import processing.opengl.PSurfaceJOGL;

public class PAppletJythonDriver
extends PApplet {
    public static final String C_LIKE_LOGICAL_AND_ERROR_MESSAGE = "Did you maybe use \"&&\" instead of \"and\"?";
    public static final String C_LIKE_LOGICAL_OR_ERROR_MESSAGE = "Did you maybe use \"||\" instead of \"or\"?";
    private static final IOUtil.ResourceReader resourceReader = new IOUtil.ResourceReader(PAppletJythonDriver.class);
    private static final String GET_SETTINGS_SCRIPT = resourceReader.readText("get_settings.py");
    private static final String DETECT_MODE_SCRIPT = resourceReader.readText("detect_sketch_mode.py");
    private static final String PREPROCESS_SCRIPT = resourceReader.readText("pyde_preprocessor.py");
    private PythonSketchError terminalException = null;
    protected final PyStringMap builtins;
    protected final InteractiveConsole interp;
    private final Path pySketchPath;
    private final String programText;
    private final WrappedPrintStream wrappedStdout;
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private final Mode mode;
    private int detectedWidth;
    private int detectedHeight;
    private int detectedPixelDensity;
    private String detectedRenderer;
    private boolean detectedSmooth;
    private boolean detectedNoSmooth;
    private boolean detectedFullScreen;
    private PyObject processedStaticSketch;
    private PyObject setupMeth;
    private PyObject settingsMeth;
    private PyObject drawMeth;
    private PyObject pauseMeth;
    private PyObject resumeMeth;
    private PyObject stopMeth;
    private PyObject disposeMeth;
    private EventFunction<KeyEvent> keyPressedFunc;
    private EventFunction<KeyEvent> keyReleasedFunc;
    private EventFunction<KeyEvent> keyTypedFunc;
    private EventFunction<MouseEvent> mousePressedFunc;
    private EventFunction<MouseEvent> mouseClickedFunc;
    private EventFunction<MouseEvent> mouseMovedFunc;
    private EventFunction<MouseEvent> mouseReleasedFunc;
    private EventFunction<MouseEvent> mouseDraggedFunc;
    private PyObject mouseWheelMeth;
    private PyObject captureEventMeth;
    private PyObject movieEventMeth;
    private PyObject serialEventMeth;
    private PyObject clientEventMeth;
    private PyObject disconnectEventMeth;
    private PyObject serverEventMeth;
    private PyObject oscEventMeth;
    private SketchPositionListener sketchPositionListener;
    private static final Pattern NAKED_COLOR;
    private static final PyInteger[] CHEAP_INTS;
    private char lastKey = '\u0000';
    private volatile boolean disposeCalled = false;

    static {
        useNativeSelect = false;
        NAKED_COLOR = Pattern.compile("[(,]\\s*#([0-9a-fA-F]{6})\\b");
        CHEAP_INTS = new PyInteger[20000];
        int i = 0;
        while (i < CHEAP_INTS.length) {
            PAppletJythonDriver.CHEAP_INTS[i] = Py.newInteger(i);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSketch(String scriptSource) throws PythonSketchError {
        block13: {
            try {
                this.interp.set("__processing_source__", this.programText);
                code = Py.compile_flags(scriptSource, this.pySketchPath.toString(), CompileMode.exec, new CompilerFlags());
                var3_5 = null;
                var4_7 = null;
                try {
                    out = this.wrappedStdout.pushStdout();
                    try {
                        this.interp.exec(code);
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (Throwable var4_8) {
                    if (var3_5 == null) {
                        var3_5 = var4_8;
                    } else if (var3_5 != var4_8) {
                        var3_5.addSuppressed(var4_8);
                    }
                    throw var3_5;
                }
                Py.flushLine();
                break block13;
            }
            catch (Throwable t) {
                ** while (t.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                t = t.getCause();
                continue;
            }
lbl29:
            // 1 sources

            throw PAppletJythonDriver.toSketchException(t);
        }
    }

    private PyObject raiseTypeError(String msg) {
        this.interp.exec(String.format("raise TypeError('%s')", msg.replace("'", "\\'")));
        return Py.None;
    }

    private static PythonSketchError toSketchException(Throwable t) {
        if (t instanceof RuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof PythonSketchError) {
            return (PythonSketchError)t;
        }
        if (t instanceof PySyntaxError) {
            PySyntaxError e = (PySyntaxError)t;
            return PAppletJythonDriver.extractSketchErrorFromPyExceptionValue((PyTuple)e.value);
        }
        if (t instanceof PyIndentationError) {
            PyIndentationError e = (PyIndentationError)t;
            return PAppletJythonDriver.extractSketchErrorFromPyExceptionValue((PyTuple)e.value);
        }
        if (t instanceof PyException) {
            Pattern importStar;
            PyException e = (PyException)t;
            Pattern tbParse = Pattern.compile("^\\s*File \"([^\"]+)\", line (\\d+)", 8);
            Matcher m = tbParse.matcher(e.toString());
            String file = null;
            int line = -1;
            while (m.find()) {
                String fileName = m.group(1);
                if (fileName.equals("<string>")) continue;
                file = fileName;
                if (new File(file).exists()) {
                    file = new File(file).getName();
                }
                line = Integer.parseInt(m.group(2)) - 1;
            }
            if (((PyType)e.type).getName().equals("ImportError") && (importStar = Pattern.compile("import\\s+\\*")).matcher(e.toString()).find()) {
                return new PythonSketchError("import * does not work in this environment.", file, line);
            }
            return new PythonSketchError(Py.formatException(e.type, e.value), file, line);
        }
        StringWriter stackTrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTrace));
        return new PythonSketchError(stackTrace.toString());
    }

    private static PythonSketchError extractSketchErrorFromPyExceptionValue(PyTuple tup) {
        String pyMessage = (String)tup.get(0);
        String message2 = PAppletJythonDriver.maybeMakeFriendlyMessage(pyMessage);
        PyTuple context = (PyTuple)tup.get(1);
        File file = new File((String)context.get(0));
        String fileName = file.getName();
        int lineNumber = (Integer)context.get(1) - 1;
        int column = (Integer)context.get(2);
        if (pyMessage.startsWith("no viable alternative")) {
            return PAppletJythonDriver.noViableAlternative(file, lineNumber, column, pyMessage);
        }
        return new PythonSketchError(message2, fileName, lineNumber, column);
    }

    private static PythonSketchError noViableAlternative(File file, int lineNo, int column, String message2) {
        if (message2.equals("no viable alternative at input '&'")) {
            return new PythonSketchError(C_LIKE_LOGICAL_AND_ERROR_MESSAGE, file.getName(), lineNo, column);
        }
        if (message2.equals("no viable alternative at input '|'")) {
            return new PythonSketchError(C_LIKE_LOGICAL_OR_ERROR_MESSAGE, file.getName(), lineNo, column);
        }
        PythonSketchError defaultException = new PythonSketchError("Maybe there's an unclosed paren or quote mark somewhere before this line?", file.getName(), lineNo, column);
        try {
            int lineIndex = 0;
            for (String line : Files.readLines(file, Charsets.UTF_8)) {
                Matcher m = NAKED_COLOR.matcher(line);
                if (m.find()) {
                    String color = m.group(1);
                    return new PythonSketchError("Did you try to name a color here? Colors in Python mode are either strings, like '#" + color + "', or " + "large hex integers, like 0xFF" + color.toUpperCase() + ".", file.getName(), lineIndex, m.start(1));
                }
                ++lineIndex;
            }
        }
        catch (IOException e) {
            System.err.println("While trying to read " + file + ": " + e.getMessage());
            return defaultException;
        }
        return defaultException;
    }

    private static String maybeMakeFriendlyMessage(String message2) {
        if (message2.contains("expecting INDENT")) {
            return "This line probably needs to be indented.";
        }
        if (message2.contains("mismatched input '//'")) {
            return "Did you mean to make a comment? Comments in Python use the # character, not the double-slash.";
        }
        return message2;
    }

    @Override
    public void frameMoved(int x, int y) {
        if (this.sketchPositionListener != null) {
            this.sketchPositionListener.sketchMoved(new Point(x, y));
        }
    }

    public PAppletJythonDriver(InteractiveConsole interp, String pySketchPath, String programText, final Printer stdout) throws PythonSketchError {
        this.wrappedStdout = new WrappedPrintStream(System.out){

            @Override
            public void doPrint(String s) {
                stdout.print(s);
            }
        };
        this.programText = programText;
        this.pySketchPath = Paths.get(pySketchPath, new String[0]);
        this.interp = interp;
        this.builtins = (PyStringMap)interp.getSystemState().getBuiltins();
        interp.set("__file__", new File(pySketchPath).getName());
        this.processSketch(DETECT_MODE_SCRIPT);
        this.mode = Mode.valueOf(interp.get("__mode__").asString());
        Runner.log("Mode: ", this.mode.name());
        if (this.mode == Mode.MIXED) {
            throw interp.get("__error__", MixedModeError.class);
        }
        if (this.mode == Mode.STATIC) {
            this.processSketch(GET_SETTINGS_SCRIPT);
            this.detectedWidth = interp.get("__width__").asInt();
            this.detectedHeight = interp.get("__height__").asInt();
            this.detectedPixelDensity = interp.get("__pixelDensity__").asInt();
            this.detectedSmooth = interp.get("__smooth__").asInt() != 0;
            this.detectedNoSmooth = interp.get("__noSmooth__").asInt() != 0;
            String r = interp.get("__renderer__").asString();
            this.detectedRenderer = r.equals("JAVA2D") ? "processing.awt.PGraphicsJava2D" : (r.equals("P2D") ? "processing.opengl.PGraphics2D" : (r.equals("P3D") ? "processing.opengl.PGraphics3D" : (r.equals("OPENGL") ? "processing.opengl.PGraphics3D" : (r.equals("FX2D") ? "processing.javafx.PGraphicsFX2D" : (r.equals("PDF") ? "processing.pdf.PGraphicsPDF" : (r.equals("SVG") ? "processing.svg.PGraphicsSVG" : (r.equals("DXF") ? "processing.dxf.RawDXF" : r)))))));
            this.processedStaticSketch = interp.get("__cleaned_sketch__");
        }
        PAppletJythonDriver.initializeStatics(this.builtins);
        this.setFilter();
        this.setMap();
        this.setSet();
        this.setColorMethods();
        this.setText();
        this.builtins.__setitem__("g", Py.java2py(this.g));
        this.builtins.__setitem__("key", (PyObject)Py.newUnicode('\u0000'));
        this.builtins.__setitem__("keyCode", (PyObject)PAppletJythonDriver.pyint(0));
    }

    @Override
    protected PSurface initSurface() {
        PSurface s = super.initSurface();
        s.setTitle(this.pySketchPath.getFileName().toString().replaceAll("\\..*$", ""));
        if (s instanceof PSurfaceAWT) {
            PSurfaceAWT surf = (PSurfaceAWT)s;
            Component c = (Component)surf.getNative();
            c.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    PAppletJythonDriver.this.finishedLatch.countDown();
                }
            });
        } else if (s instanceof PSurfaceJOGL) {
            PSurfaceJOGL surf = (PSurfaceJOGL)s;
            GLWindow win = (GLWindow)surf.getNative();
            win.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDestroyed(WindowEvent arg0) {
                    PAppletJythonDriver.this.finishedLatch.countDown();
                }
            });
        } else if (s instanceof PSurfaceFX) {
            System.err.println("I don't know how to watch FX2D windows for close.");
        }
        return s;
    }

    @Override
    public void exitActual() {
        this.finishedLatch.countDown();
    }

    public void findSketchMethods() throws PythonSketchError {
        if (this.mode == Mode.ACTIVE) {
            this.processSketch(PREPROCESS_SCRIPT);
        }
        this.drawMeth = this.interp.get("draw");
        this.setupMeth = this.interp.get("setup");
        this.mousePressedFunc = new EventFunction<MouseEvent>(this, "mousePressed"){

            @Override
            protected void callSuper(MouseEvent event) {
                PAppletJythonDriver.super.mousePressed(event);
            }
        };
        this.mouseClickedFunc = new EventFunction<MouseEvent>(this, "mouseClicked"){

            @Override
            protected void callSuper(MouseEvent event) {
                PAppletJythonDriver.super.mouseClicked(event);
            }
        };
        this.mouseMovedFunc = new EventFunction<MouseEvent>(this, "mouseMoved"){

            @Override
            protected void callSuper(MouseEvent event) {
                PAppletJythonDriver.super.mouseMoved(event);
            }
        };
        this.mouseReleasedFunc = new EventFunction<MouseEvent>(this, "mouseReleased"){

            @Override
            protected void callSuper(MouseEvent event) {
                PAppletJythonDriver.super.mouseReleased(event);
            }
        };
        this.mouseDraggedFunc = new EventFunction<MouseEvent>(this, "mouseDragged"){

            @Override
            protected void callSuper(MouseEvent event) {
                PAppletJythonDriver.super.mouseDragged(event);
            }
        };
        this.keyPressedFunc = new EventFunction<KeyEvent>(this, "keyPressed"){

            @Override
            protected void callSuper(KeyEvent event) {
                PAppletJythonDriver.super.keyPressed(event);
            }
        };
        this.keyReleasedFunc = new EventFunction<KeyEvent>(this, "keyReleased"){

            @Override
            protected void callSuper(KeyEvent event) {
                PAppletJythonDriver.super.keyReleased(event);
            }
        };
        this.keyTypedFunc = new EventFunction<KeyEvent>(this, "keyTyped"){

            @Override
            protected void callSuper(KeyEvent event) {
                PAppletJythonDriver.super.keyTyped(event);
            }
        };
        this.settingsMeth = this.interp.get("settings");
        this.stopMeth = this.interp.get("stop");
        this.disposeMeth = this.interp.get("dispose");
        this.pauseMeth = this.interp.get("pause");
        this.resumeMeth = this.interp.get("resume");
        this.mouseWheelMeth = this.interp.get("mouseWheel");
        if (((EventFunction)this.mousePressedFunc).func != null) {
            this.interp.getLocals().__setitem__("mousePressed", (PyObject)new PyBoolean(false){

                @Override
                public boolean getBooleanValue() {
                    return PAppletJythonDriver.this.mousePressed;
                }

                @Override
                public PyObject __call__(PyObject[] args, String[] kws) {
                    return ((EventFunction)PAppletJythonDriver.this.mousePressedFunc).func.__call__(args, kws);
                }
            });
        }
        this.captureEventMeth = this.interp.get("captureEvent");
        this.movieEventMeth = this.interp.get("movieEvent");
        this.serialEventMeth = this.interp.get("serialEvent");
        this.clientEventMeth = this.interp.get("clientEvent");
        this.disconnectEventMeth = this.interp.get("disconnectEvent");
        this.serverEventMeth = this.interp.get("serverEvent");
        this.oscEventMeth = this.interp.get("oscEvent");
    }

    private static PyInteger pyint(int i) {
        return i >= 0 && i < CHEAP_INTS.length ? CHEAP_INTS[i] : Py.newInteger(i);
    }

    @Override
    public void focusGained() {
        super.focusGained();
        this.builtins.__setitem__("focused", (PyObject)Py.newBoolean(this.focused));
    }

    @Override
    public void focusLost() {
        super.focusLost();
        this.builtins.__setitem__("focused", (PyObject)Py.newBoolean(this.focused));
    }

    protected void wrapProcessingVariables() {
        this.wrapMouseVariables();
        this.wrapKeyVariables();
        this.builtins.__setitem__("width", (PyObject)PAppletJythonDriver.pyint(this.width));
        this.builtins.__setitem__("height", (PyObject)PAppletJythonDriver.pyint(this.height));
        this.builtins.__setitem__("displayWidth", (PyObject)PAppletJythonDriver.pyint(this.displayWidth));
        this.builtins.__setitem__("displayHeight", (PyObject)PAppletJythonDriver.pyint(this.displayHeight));
        this.builtins.__setitem__("focused", (PyObject)Py.newBoolean(this.focused));
        this.builtins.__setitem__("keyPressed", (PyObject)Py.newBoolean(this.keyPressed));
        this.builtins.__setitem__("frameCount", (PyObject)PAppletJythonDriver.pyint(this.frameCount));
        this.builtins.__setitem__("frameRate", (PyObject)new PyFloat(this.frameRate){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                switch (args.length) {
                    default: {
                        return PAppletJythonDriver.this.raiseTypeError("Can't call \"frameRate\" with " + args.length + " parameters.");
                    }
                    case 1: 
                }
                PAppletJythonDriver.this.frameRate((float)args[0].asDouble());
                return Py.None;
            }
        });
    }

    private void wrapKeyVariables() {
        if (this.lastKey != this.key) {
            this.lastKey = this.key;
            PyObject pyKey = this.key == '\uffff' ? PAppletJythonDriver.pyint(this.key) : Py.newUnicode(this.key);
            this.builtins.__setitem__("key", pyKey);
        }
        this.builtins.__setitem__("keyCode", (PyObject)PAppletJythonDriver.pyint(this.keyCode));
    }

    private void wrapMouseVariables() {
        this.builtins.__setitem__("mouseX", (PyObject)PAppletJythonDriver.pyint(this.mouseX));
        this.builtins.__setitem__("mouseY", (PyObject)PAppletJythonDriver.pyint(this.mouseY));
        this.builtins.__setitem__("pmouseX", (PyObject)PAppletJythonDriver.pyint(this.pmouseX));
        this.builtins.__setitem__("pmouseY", (PyObject)PAppletJythonDriver.pyint(this.pmouseY));
        this.builtins.__setitem__("mouseButton", (PyObject)PAppletJythonDriver.pyint(this.mouseButton));
        if (((EventFunction)this.mousePressedFunc).func == null) {
            this.builtins.__setitem__("mousePressed", (PyObject)Py.newBoolean(this.mousePressed));
        }
    }

    @Override
    public void start() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PAppletJythonDriver.this.terminalException = PAppletJythonDriver.toSketchException(e);
                try {
                    PAppletJythonDriver.this.handleMethods("dispose");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PAppletJythonDriver.this.finishedLatch.countDown();
            }
        });
        super.start();
    }

    public void runAndBlock(String[] args) throws PythonSketchError {
        block20: {
            Object nativeWindow;
            PApplet.runSketch(args, this);
            try {
                try {
                    this.finishedLatch.await();
                }
                catch (InterruptedException interrupted) {
                    Object nativeWindow2;
                    this.exit();
                    try {
                        this.finishedLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (PApplet.platform == 2 && Arrays.asList(args).contains("fullScreen")) {
                        Runner.log("Disabling fullscreen.");
                        PAppletJythonDriver.macosxFullScreenToggle(this.frame);
                    }
                    if (this.surface instanceof PSurfaceFX) {
                        Runner.log("JavaFX requires SketchRunner to terminate. Farewell!");
                        System.exit(0);
                    }
                    if ((nativeWindow2 = this.surface.getNative()) instanceof com.jogamp.newt.Window) {
                        ((com.jogamp.newt.Window)nativeWindow2).destroy();
                    } else {
                        this.surface.setVisible(false);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                Object nativeWindow3;
                if (PApplet.platform == 2 && Arrays.asList(args).contains("fullScreen")) {
                    Runner.log("Disabling fullscreen.");
                    PAppletJythonDriver.macosxFullScreenToggle(this.frame);
                }
                if (this.surface instanceof PSurfaceFX) {
                    Runner.log("JavaFX requires SketchRunner to terminate. Farewell!");
                    System.exit(0);
                }
                if ((nativeWindow3 = this.surface.getNative()) instanceof com.jogamp.newt.Window) {
                    ((com.jogamp.newt.Window)nativeWindow3).destroy();
                } else {
                    this.surface.setVisible(false);
                }
                throw throwable;
            }
            if (PApplet.platform == 2 && Arrays.asList(args).contains("fullScreen")) {
                Runner.log("Disabling fullscreen.");
                PAppletJythonDriver.macosxFullScreenToggle(this.frame);
            }
            if (this.surface instanceof PSurfaceFX) {
                Runner.log("JavaFX requires SketchRunner to terminate. Farewell!");
                System.exit(0);
            }
            if ((nativeWindow = this.surface.getNative()) instanceof com.jogamp.newt.Window) {
                ((com.jogamp.newt.Window)nativeWindow).destroy();
            } else {
                this.surface.setVisible(false);
            }
        }
        if (this.terminalException != null) {
            throw this.terminalException;
        }
    }

    private static void macosxFullScreenToggle(Window window) {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Method getAppMethod = appClass.getMethod("getApplication", new Class[0]);
            Object app = getAppMethod.invoke(null, new Object[0]);
            Method requestMethod = appClass.getMethod("requestToggleFullScreen", Window.class);
            requestMethod.invoke(app, window);
        }
        catch (ClassNotFoundException appClass) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSet() {
        final PyType originalSet = (PyType)this.builtins.__getitem__("set");
        this.builtins.__setitem__("set", (PyObject)new PyType(PyType.TYPE){
            {
                super($anonymous0);
                this.builtin = true;
                this.init(PySet.class, new HashSet<PyJavaType>());
                this.invalidateMethodCache();
            }

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                switch (args.length) {
                    default: {
                        return originalSet.__call__(args, kws);
                    }
                    case 3: 
                }
                int x = args[0].asInt();
                int y = args[1].asInt();
                PyObject c = args[2];
                PyType tc = c.getType();
                if (tc.getProxyType() != null && PImage.class.isAssignableFrom(tc.getProxyType())) {
                    PAppletJythonDriver.this.set(x, y, (PImage)c.__tojava__(PImage.class));
                    return Py.None;
                }
                PAppletJythonDriver.this.set(x, y, PAppletJythonDriver.this.interpretColorArg(c));
                return Py.None;
            }
        });
    }

    private void setMap() {
        final PyObject builtinMap = this.builtins.__getitem__("map");
        this.builtins.__setitem__("map", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                switch (args.length) {
                    default: {
                        return builtinMap.__call__(args, kws);
                    }
                    case 5: 
                }
                PyObject value = args[0];
                PyObject start1 = args[1];
                PyObject stop1 = args[2];
                PyObject start2 = args[3];
                PyObject stop2 = args[4];
                if (value.isNumberType() && start1.isNumberType() && stop1.isNumberType() && start2.isNumberType() && stop2.isNumberType()) {
                    return Py.newFloat(PAppletJythonDriver.map((float)value.asDouble(), (float)start1.asDouble(), (float)stop1.asDouble(), (float)start2.asDouble(), (float)stop2.asDouble()));
                }
                return builtinMap.__call__(args, kws);
            }
        });
    }

    private void setFilter() {
        final PyObject builtinFilter = this.builtins.__getitem__("filter");
        this.builtins.__setitem__("filter", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                switch (args.length) {
                    case 1: {
                        PyObject value = args[0];
                        if (value.isNumberType()) {
                            PAppletJythonDriver.this.filter(value.asInt());
                        } else {
                            PAppletJythonDriver.this.filter(Py.tojava(value, PShader.class));
                        }
                        return Py.None;
                    }
                    case 2: {
                        PyObject a = args[0];
                        PyObject b = args[1];
                        if (!a.isNumberType()) break;
                        PAppletJythonDriver.this.filter(a.asInt(), (float)b.asDouble());
                        return Py.None;
                    }
                }
                return builtinFilter.__call__(args, kws);
            }
        });
    }

    @Override
    public int lerpColor(int c1, int c2, float amt) {
        if (this.g != null) {
            return super.lerpColor(c1, c2, amt);
        }
        return PApplet.lerpColor(c1, c2, amt, 1);
    }

    public void fill(long argb) {
        this.fill((int)(argb & 0xFFFFFFFFFFFFFFFFL));
    }

    public void stroke(long argb) {
        this.stroke((int)(argb & 0xFFFFFFFFFFFFFFFFL));
    }

    public void background(long argb) {
        this.background((int)(argb & 0xFFFFFFFFFFFFFFFFL));
    }

    public void fill(String argbSpec) {
        this.fill(this.parseColorSpec(argbSpec));
    }

    public void stroke(String argbSpec) {
        this.stroke(this.parseColorSpec(argbSpec));
    }

    public void background(String argbSpec) {
        this.background(this.parseColorSpec(argbSpec));
    }

    private int parseColorSpec(String argbSpec) {
        try {
            return 0xFF000000 | Integer.decode(argbSpec);
        }
        catch (NumberFormatException e) {
            return this.raiseTypeError("I can't understand \"" + argbSpec + "\" as a color.").asInt();
        }
    }

    private boolean isString(PyObject o) {
        return o.getType() == PyString.TYPE || o.getType() == PyUnicode.TYPE;
    }

    private int interpretColorArg(PyObject arg) {
        return this.isString(arg) ? this.parseColorSpec(arg.asString()) : arg.asInt();
    }

    private void setColorMethods() {
        this.builtins.__setitem__("lerpColor", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                int c1 = PAppletJythonDriver.this.interpretColorArg(args[0]);
                int c2 = PAppletJythonDriver.this.interpretColorArg(args[1]);
                float amt = (float)args[2].asDouble();
                switch (args.length) {
                    case 3: {
                        return PAppletJythonDriver.pyint(PAppletJythonDriver.this.lerpColor(c1, c2, amt));
                    }
                    case 4: {
                        int colorMode = (int)(args[3].asLong() & 0xFFFFFFFFFFFFFFFFL);
                        return PAppletJythonDriver.pyint(PAppletJythonDriver.lerpColor(c1, c2, amt, colorMode));
                    }
                }
                return PAppletJythonDriver.this.raiseTypeError("lerpColor takes either 3 or 4 arguments, but I got " + args.length + ".");
            }
        });
        this.builtins.__setitem__("alpha", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.alpha(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("red", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.red(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("green", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.green(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("blue", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.blue(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("hue", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.hue(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("saturation", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.saturation(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
        this.builtins.__setitem__("brightness", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                return Py.newFloat(PAppletJythonDriver.this.brightness(PAppletJythonDriver.this.interpretColorArg(args[0])));
            }
        });
    }

    private void setText() {
        this.builtins.__setitem__("text", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] args, String[] kws) {
                if (args.length < 3 || args.length > 5) {
                    PAppletJythonDriver.this.raiseTypeError("text() takes 3-5 arguments, but I got " + args.length + ".");
                }
                PyObject a = args[0];
                float x1 = (float)args[1].asDouble();
                float y1 = (float)args[2].asDouble();
                if (args.length == 3) {
                    if (PAppletJythonDriver.this.isString(a)) {
                        PAppletJythonDriver.this.text(a.asString(), x1, y1);
                    } else if (a.getType() == PyInteger.TYPE) {
                        PAppletJythonDriver.this.text(a.asInt(), x1, y1);
                    } else {
                        PAppletJythonDriver.this.text((float)a.asDouble(), x1, y1);
                    }
                } else if (args.length == 4) {
                    float z1 = (float)args[3].asDouble();
                    if (PAppletJythonDriver.this.isString(a)) {
                        PAppletJythonDriver.this.text(a.asString(), x1, y1, z1);
                    } else if (a.getType() == PyInteger.TYPE) {
                        PAppletJythonDriver.this.text(a.asInt(), x1, y1, z1);
                    } else {
                        PAppletJythonDriver.this.text((float)a.asDouble(), x1, y1, z1);
                    }
                } else {
                    PAppletJythonDriver.this.text(a.asString(), x1, y1, (float)args[3].asDouble(), (float)args[4].asDouble());
                }
                return Py.None;
            }
        });
    }

    public static void initializeStatics(PyStringMap builtins) {
        Field[] fieldArray = PConstants.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            int mods = f.getModifiers();
            if (Modifier.isPublic(mods) || Modifier.isStatic(mods)) {
                try {
                    builtins.__setitem__(f.getName(), Py.java2py(f.get(null)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    @Override
    public void size(int iwidth, int iheight, String irenderer, String ipath) {
        super.size(iwidth, iheight, irenderer, ipath);
        this.builtins.__setitem__("g", Py.java2py(this.g));
        this.builtins.__setitem__("frame", Py.java2py(this.frame));
        this.builtins.__setitem__("width", (PyObject)PAppletJythonDriver.pyint(this.width));
        this.builtins.__setitem__("height", (PyObject)PAppletJythonDriver.pyint(this.height));
    }

    @Override
    public void settings() {
        try {
            if (this.settingsMeth != null) {
                this.settingsMeth.__call__();
            } else if (this.mode == Mode.STATIC) {
                if (this.detectedFullScreen) {
                    this.fullScreen();
                } else if (this.detectedRenderer != null) {
                    this.size(this.detectedWidth, this.detectedHeight, this.detectedRenderer);
                } else {
                    this.size(this.detectedWidth, this.detectedHeight);
                }
                this.pixelDensity(this.detectedPixelDensity);
                if (this.detectedSmooth) {
                    this.smooth();
                } else if (this.detectedNoSmooth) {
                    this.noSmooth();
                }
            }
        }
        catch (Exception e) {
            this.terminalException = PAppletJythonDriver.toSketchException(e);
            this.exitActual();
        }
    }

    @Override
    public void setup() {
        this.builtins.__setitem__("frame", Py.java2py(this.frame));
        this.wrapProcessingVariables();
        if (this.mode == Mode.STATIC) {
            Runner.log("Interpreting static-mode sketch.");
            try {
                Throwable throwable = null;
                Object var2_6 = null;
                try (WrappedPrintStream.PushedOut out = this.wrappedStdout.pushStdout();){
                    this.interp.exec(this.processedStaticSketch);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.terminalException = PAppletJythonDriver.toSketchException(e);
                this.exitActual();
            }
        } else if (this.setupMeth != null) {
            Throwable throwable = null;
            Object var2_8 = null;
            try (WrappedPrintStream.PushedOut out = this.wrappedStdout.pushStdout();){
                this.setupMeth.__call__();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void draw() {
        this.wrapProcessingVariables();
        if (this.drawMeth == null) {
            super.draw();
        } else if (!this.finished) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (WrappedPrintStream.PushedOut out = this.wrappedStdout.pushStdout();){
                this.drawMeth.__call__();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (this.exitCalled()) {
            this.exitActual();
        }
    }

    @Override
    public void loadPixels() {
        super.loadPixels();
        this.builtins.__setitem__("pixels", Py.java2py(this.pixels));
    }

    @Override
    public void mouseClicked() {
        this.wrapMouseVariables();
        this.mouseClickedFunc.invoke();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.wrapMouseVariables();
        this.mouseClickedFunc.invoke(e);
    }

    @Override
    public void mouseMoved() {
        this.wrapMouseVariables();
        this.mouseMovedFunc.invoke();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.wrapMouseVariables();
        this.mouseMovedFunc.invoke(e);
    }

    @Override
    public void mousePressed() {
        this.wrapMouseVariables();
        this.mousePressedFunc.invoke();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.wrapMouseVariables();
        this.mousePressedFunc.invoke(e);
    }

    @Override
    public void mouseReleased() {
        this.wrapMouseVariables();
        this.mouseReleasedFunc.invoke();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.wrapMouseVariables();
        this.mouseReleasedFunc.invoke(e);
    }

    @Override
    public void mouseDragged() {
        this.wrapMouseVariables();
        this.mouseDraggedFunc.invoke();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.wrapMouseVariables();
        this.mouseDraggedFunc.invoke(e);
    }

    @Override
    public void mouseWheel(MouseEvent e) {
        if (this.mouseWheelMeth != null) {
            this.wrapMouseVariables();
            this.mouseWheelMeth.__call__(Py.java2py(e));
        }
    }

    @Override
    public void keyPressed() {
        this.wrapKeyVariables();
        this.keyPressedFunc.invoke();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.wrapKeyVariables();
        this.keyPressedFunc.invoke(e);
    }

    @Override
    public void keyReleased() {
        this.wrapKeyVariables();
        this.keyReleasedFunc.invoke();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.wrapKeyVariables();
        this.keyReleasedFunc.invoke(e);
    }

    @Override
    public void keyTyped() {
        this.wrapKeyVariables();
        this.keyTypedFunc.invoke();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.wrapKeyVariables();
        this.keyTypedFunc.invoke(e);
    }

    @Override
    public void dispose() {
        if (this.disposeCalled) {
            return;
        }
        this.disposeCalled = true;
        super.dispose();
        if (this.stopMeth != null) {
            this.stopMeth.__call__();
        }
        if (this.disposeMeth != null) {
            this.disposeMeth.__call__();
        }
    }

    @Override
    public void pause() {
        try {
            if (this.pauseMeth != null) {
                this.pauseMeth.__call__();
            }
        }
        finally {
            super.pause();
        }
    }

    @Override
    public void resume() {
        try {
            if (this.resumeMeth != null) {
                this.resumeMeth.__call__();
            }
        }
        finally {
            super.resume();
        }
    }

    @Override
    public void selectFolder(String prompt, String callback, File file) {
        super.selectFolder(prompt, "handleCallback", file, new FileSelectCallbackProxy(callback));
    }

    @Override
    public void selectInput(String prompt, String callback, File file) {
        super.selectInput(prompt, "handleCallback", file, new FileSelectCallbackProxy(callback));
    }

    @Override
    public void selectOutput(String prompt, String callback, File file) {
        super.selectOutput(prompt, "handleCallback", file, new FileSelectCallbackProxy(callback));
    }

    @Override
    public void printMatrix() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (WrappedPrintStream.PushedOut w = this.wrappedStdout.pushStdout();){
            super.printMatrix();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void printCamera() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (WrappedPrintStream.PushedOut w = this.wrappedStdout.pushStdout();){
            super.printCamera();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void printProjection() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (WrappedPrintStream.PushedOut w = this.wrappedStdout.pushStdout();){
            super.printProjection();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void captureEvent(Object capture) {
        if (this.captureEventMeth != null) {
            this.captureEventMeth.__call__(Py.java2py(capture));
        }
    }

    public void movieEvent(Object movie) {
        if (this.movieEventMeth != null) {
            this.movieEventMeth.__call__(Py.java2py(movie));
        }
    }

    public void serialEvent(Object whichPort) {
        if (this.serialEventMeth != null) {
            this.serialEventMeth.__call__(Py.java2py(whichPort));
        }
    }

    public void clientEvent(Object someClient) {
        if (this.clientEventMeth != null) {
            this.clientEventMeth.__call__(Py.java2py(someClient));
        }
    }

    public void disconnectEvent(Object someClient) {
        if (this.disconnectEventMeth != null) {
            this.disconnectEventMeth.__call__(Py.java2py(someClient));
        }
    }

    public void serverEvent(Object someServer, Object someClient) {
        if (this.serverEventMeth != null) {
            this.serverEventMeth.__call__(Py.java2py(someServer), Py.java2py(someClient));
        }
    }

    public void oscEvent(Object oscMessage) {
        if (this.oscEventMeth != null) {
            this.oscEventMeth.__call__(Py.java2py(oscMessage));
        }
    }

    public void setSketchPositionListener(SketchPositionListener sketchPositionListener) {
        this.sketchPositionListener = sketchPositionListener;
    }

    private abstract class EventFunction<T> {
        private final PyFunction func;
        private final int argCount;

        protected abstract void callSuper(T var1);

        public EventFunction(String funcName) {
            this.func = (PyFunction)PAppletJythonDriver.this.interp.get(funcName);
            this.argCount = this.func == null ? -1 : ((PyBaseCode)this.func.__code__).co_argcount;
        }

        public void invoke() {
            if (this.func != null && this.argCount == 0) {
                this.func.__call__();
            }
        }

        public void invoke(T event) {
            if (this.func != null && this.argCount == 1) {
                this.func.__call__(Py.java2py(event));
            } else {
                this.callSuper(event);
            }
        }
    }

    public class FileSelectCallbackProxy {
        private final PyObject callback;

        public FileSelectCallbackProxy(String name) {
            this.callback = PAppletJythonDriver.this.interp.get(name);
            if (this.callback == null) {
                throw new RuntimeException("I can't find a callback function named \"" + name + "\"");
            }
        }

        public void handleCallback(File selection) {
            this.callback.__call__(Py.java2py(selection));
        }
    }

    private static enum Mode {
        STATIC,
        ACTIVE,
        MIXED;

    }
}

