/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.PngjOutputException;

public class PngHelperInternal {
    public static final Charset charsetLatin1 = Charset.forName("ISO-8859-1");
    public static final Charset charsetUTF8 = Charset.forName("UTF-8");
    static final boolean DEBUG = false;
    private static final ThreadLocal<CRC32> crcProvider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public static byte[] getPngIdSignature() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    public static int doubleToInt100000(double d) {
        return (int)(d * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int n) {
        return (double)n / 100000.0;
    }

    public static int readByte(InputStream inputStream) {
        try {
            return inputStream.read();
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading byte", iOException);
        }
    }

    public static int readInt2(InputStream inputStream) {
        try {
            int n = inputStream.read();
            int n2 = inputStream.read();
            if (n == -1 || n2 == -1) {
                return -1;
            }
            return (n << 8) + n2;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt2", iOException);
        }
    }

    public static int readInt4(InputStream inputStream) {
        try {
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                return -1;
            }
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt4", iOException);
        }
    }

    public static int readInt1fromByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 16 | byArray[n + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static void writeByte(OutputStream outputStream, byte by) {
        try {
            outputStream.write(by);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeInt2(OutputStream outputStream, int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        PngHelperInternal.writeBytes(outputStream, byArray);
    }

    public static void writeInt4(OutputStream outputStream, int n) {
        byte[] byArray = new byte[4];
        PngHelperInternal.writeInt4tobytes(n, byArray, 0);
        PngHelperInternal.writeBytes(outputStream, byArray);
    }

    public static void writeInt2tobytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n & 0xFF);
    }

    public static void writeInt4tobytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static void readBytes(InputStream inputStream, byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        try {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = inputStream.read(byArray, n + i, n2 - i);
                if (n3 >= 1) continue;
                throw new PngjInputException("error reading bytes, " + n3 + " !=" + n2);
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading", iOException);
        }
    }

    public static void skipBytes(InputStream inputStream, long l) {
        try {
            while (l > 0L) {
                long l2 = inputStream.skip(l);
                if (l2 > 0L) {
                    l -= l2;
                    continue;
                }
                if (l2 == 0L) {
                    if (inputStream.read() == -1) break;
                    --l;
                    continue;
                }
                throw new IOException("skip() returned a negative value ???");
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException(iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray, int n, int n2) {
        try {
            outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void logdebug(String string2) {
    }

    public static CRC32 getCRC() {
        return crcProvider.get();
    }

    public static int filterRowNone(int n) {
        return n & 0xFF;
    }

    public static int filterRowSub(int n, int n2) {
        return n - n2 & 0xFF;
    }

    public static int filterRowUp(int n, int n2) {
        return n - n2 & 0xFF;
    }

    public static int filterRowAverage(int n, int n2, int n3) {
        return n - (n2 + n3) / 2 & 0xFF;
    }

    public static int filterRowPaeth(int n, int n2, int n3, int n4) {
        return n - PngHelperInternal.filterPaethPredictor(n2, n3, n4) & 0xFF;
    }

    public static int unfilterRowNone(int n) {
        return n & 0xFF;
    }

    public static int unfilterRowSub(int n, int n2) {
        return n + n2 & 0xFF;
    }

    public static int unfilterRowUp(int n, int n2) {
        return n + n2 & 0xFF;
    }

    public static int unfilterRowAverage(int n, int n2, int n3) {
        return n + (n2 + n3) / 2 & 0xFF;
    }

    public static int unfilterRowPaeth(int n, int n2, int n3, int n4) {
        return n + PngHelperInternal.filterPaethPredictor(n2, n3, n4) & 0xFF;
    }

    static final int filterPaethPredictor(int n, int n2, int n3) {
        int n4;
        int n5 = n + n2 - n3;
        int n6 = n5 >= n ? n5 - n : n - n5;
        int n7 = n5 >= n2 ? n5 - n2 : n2 - n5;
        int n8 = n4 = n5 >= n3 ? n5 - n3 : n3 - n5;
        if (n6 <= n7 && n6 <= n4) {
            return n;
        }
        if (n7 <= n4) {
            return n2;
        }
        return n3;
    }

    public static final void initCrcForTests(PngReader pngReader) {
        pngReader.initCrctest();
    }

    public static final long getCrctestVal(PngReader pngReader) {
        return pngReader.getCrctestVal();
    }
}

