/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import java.util.Arrays;
import jogamp.common.util.locks.RecursiveLockImpl01Unfairish;

public class RecursiveThreadGroupLockImpl01Unfairish
extends RecursiveLockImpl01Unfairish
implements RecursiveThreadGroupLock {
    public RecursiveThreadGroupLockImpl01Unfairish() {
        super(new ThreadGroupSync());
    }

    @Override
    public final boolean isOriginalOwner() {
        return this.isOriginalOwner(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOriginalOwner(Thread thread2) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            return ((ThreadGroupSync)this.sync).isOriginalOwner(thread2);
        }
    }

    @Override
    public final void addOwner(Thread thread2) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        Thread thread3 = Thread.currentThread();
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        if (!threadGroupSync.isOriginalOwner(thread3)) {
            throw new IllegalArgumentException("Current thread is not the original owner: orig-owner: " + threadGroupSync.getOwner() + ", current " + thread3 + ": " + this.toString());
        }
        if (threadGroupSync.isOriginalOwner(thread2)) {
            throw new IllegalArgumentException("Passed thread is original owner: " + thread2 + ", " + this.toString());
        }
        threadGroupSync.addOwner(thread2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            Thread thread2 = Thread.currentThread();
            ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
            if (threadGroupSync.getAddOwnerCount() > 0) {
                Thread thread3;
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR (tg) " + this.toString() + ", cur " + this.threadName(thread2) + " -> owner...");
                }
                if (threadGroupSync.isOriginalOwner(thread2)) {
                    if (threadGroupSync.getHoldCount() - threadGroupSync.getAdditionalOwnerHoldCount() == 1) {
                        threadGroupSync.setWaitingOrigOwner(thread2);
                        try {
                            while (threadGroupSync.getAdditionalOwnerHoldCount() > 0) {
                                try {
                                    this.sync.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        finally {
                            threadGroupSync.setWaitingOrigOwner(null);
                            Thread.interrupted();
                        }
                        threadGroupSync.removeAllOwners();
                    }
                } else if (threadGroupSync.getAdditionalOwnerHoldCount() == 1 && null != (thread3 = threadGroupSync.getWaitingOrigOwner())) {
                    thread3.interrupt();
                }
            }
            if (TRACE_LOCK) {
                System.err.println("++ unlock(X): currentThread " + thread2.getName() + ", lock: " + this.toString());
                System.err.println("--- LOCK X0 (tg) " + this.toString() + ", cur " + this.threadName(thread2) + " -> unlock!");
            }
            super.unlock(runnable);
        }
    }

    @Override
    public final void removeOwner(Thread thread2) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        ((ThreadGroupSync)this.sync).removeOwner(thread2);
    }

    @Override
    public String toString() {
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        int n = this.sync.getHoldCount();
        int n2 = threadGroupSync.getAdditionalOwnerHoldCount();
        return this.syncName() + "[count " + n + " [ add. " + n2 + ", orig " + (n - n2) + "], qsz " + this.sync.getQSz() + ", owner " + this.threadName(this.sync.getOwner()) + ", add.owner " + threadGroupSync.addOwnerToString() + "]";
    }

    static class ThreadGroupSync
    extends RecursiveLockImpl01Unfairish.SingleThreadSync {
        private int holdCountAdditionOwner = 0;
        private Thread[] threads = null;
        private int threadNum = 0;
        private Thread waitingOrigOwner = null;

        ThreadGroupSync() {
        }

        @Override
        public final void incrHoldCount(Thread thread2) {
            super.incrHoldCount(thread2);
            if (!this.isOriginalOwner(thread2)) {
                ++this.holdCountAdditionOwner;
            }
        }

        @Override
        public final void decrHoldCount(Thread thread2) {
            super.decrHoldCount(thread2);
            if (!this.isOriginalOwner(thread2)) {
                --this.holdCountAdditionOwner;
            }
        }

        public final int getAdditionalOwnerHoldCount() {
            return this.holdCountAdditionOwner;
        }

        public final boolean isOriginalOwner(Thread thread2) {
            return super.isOwner(thread2);
        }

        public final void setWaitingOrigOwner(Thread thread2) {
            this.waitingOrigOwner = thread2;
        }

        public final Thread getWaitingOrigOwner() {
            return this.waitingOrigOwner;
        }

        @Override
        public final boolean isOwner(Thread thread2) {
            if (this.getExclusiveOwnerThread() == thread2) {
                return true;
            }
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                if (this.threads[i] != thread2) continue;
                return true;
            }
            return false;
        }

        public final int getAddOwnerCount() {
            return this.threadNum;
        }

        public final void addOwner(Thread thread2) throws IllegalArgumentException {
            if (null == this.threads) {
                if (this.threadNum > 0) {
                    throw new InternalError("XXX");
                }
                this.threads = new Thread[4];
            }
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                if (this.threads[i] != thread2) continue;
                throw new IllegalArgumentException("Thread already added: " + thread2);
            }
            if (this.threadNum == this.threads.length) {
                this.threads = Arrays.copyOf(this.threads, this.threadNum * 2);
            }
            this.threads[this.threadNum] = thread2;
            ++this.threadNum;
        }

        public final void removeAllOwners() {
            for (int i = this.threadNum - 1; 0 <= i; --i) {
                this.threads[i] = null;
            }
            this.threadNum = 0;
        }

        public final void removeOwner(Thread thread2) throws IllegalArgumentException {
            for (int i = 0; i < this.threadNum; ++i) {
                if (this.threads[i] != thread2) continue;
                --this.threadNum;
                System.arraycopy(this.threads, i + 1, this.threads, i, this.threadNum - i);
                this.threads[this.threadNum] = null;
                return;
            }
            throw new IllegalArgumentException("Not an owner: " + thread2);
        }

        String addOwnerToString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.threadNum; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.threads[i].getName());
            }
            return stringBuilder.toString();
        }
    }
}

