/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl.sdk;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public abstract class CompileShader {
    public abstract int getBinaryFormat();

    public abstract File getSDKCompilerDir();

    public abstract String getVertexShaderCompiler();

    public abstract String getFragmentShaderCompiler();

    public void processOneShader(String string2) throws IOException, UnsupportedEncodingException, InterruptedException {
        int n = -1;
        String string3 = null;
        int n2 = -1;
        if (string2.endsWith(ShaderCode.getFileSuffix(false, 35632))) {
            n2 = 2;
            n = 35632;
        } else if (string2.endsWith(".frag")) {
            n2 = 4;
            n = 35632;
        } else if (string2.endsWith(ShaderCode.getFileSuffix(false, 35633))) {
            n2 = 2;
            n = 35633;
        } else if (string2.endsWith(".vert")) {
            n2 = 4;
            n = 35633;
        }
        String string4 = CompileShader.basename(string2);
        string3 = string4.substring(0, string4.length() - n2) + ShaderCode.getFileSuffix(true, n);
        URL uRL = IOUtil.getResource(string2, this.getClass().getClassLoader(), null).getURL();
        String string5 = CompileShader.dirname(uRL.getPath());
        string3 = string5 + File.separator + "bin" + File.separator + ShaderCode.getBinarySubPath(this.getBinaryFormat()) + File.separator + string3;
        this.processOneShader(string2, string3, n);
    }

    public void processOneShader(String string2, String string3, int n) throws IOException, UnsupportedEncodingException, InterruptedException {
        String string4;
        URL uRL = IOUtil.getResource(string2, this.getClass().getClassLoader(), null).getURL();
        String string5 = CompileShader.dirname(uRL.getPath());
        CharSequence charSequence = ShaderCode.readShaderSource(null, string2, false);
        if (null == charSequence) {
            System.err.println("Can't find shader source " + string2 + " - ignored");
            return;
        }
        System.err.println("Preprocessing: " + string2 + ", in dir: " + string5);
        String string6 = CompileShader.basename(string2);
        switch (n) {
            case 35633: {
                string4 = this.getVertexShaderCompiler();
                break;
            }
            case 35632: {
                string4 = this.getFragmentShaderCompiler();
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        File file = new File(string3);
        File file2 = new File(string5 + File.separator + "tmp");
        file2.mkdirs();
        File file3 = new File(file2, string6);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
        ((Writer)bufferedWriter).write(charSequence.toString(), 0, charSequence.length());
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        System.err.println("Preprocessed: " + file3.getAbsolutePath());
        File file4 = this.getSDKCompilerDir();
        System.err.println("SDK: " + file4.getAbsolutePath() + ", compiler: " + string4);
        System.err.println("Output: " + file.getAbsolutePath());
        Process process = Runtime.getRuntime().exec(new String[]{file4.getAbsolutePath() + File.separator + string4, file3.getAbsolutePath(), file.getAbsolutePath()});
        new IOUtil.StreamMonitor(new InputStream[]{process.getInputStream(), process.getErrorStream()}, System.out, null);
        process.waitFor();
    }

    protected static String basename(String string2) {
        int n = string2.lastIndexOf("/");
        if (n < 0) {
            n = string2.lastIndexOf("\\");
        }
        String string3 = n < 0 ? string2 : string2.substring(n + 1);
        return string3;
    }

    protected static String dirname(String string2) {
        int n = string2.lastIndexOf("/");
        if (n < 0) {
            n = string2.lastIndexOf("\\");
        }
        String string3 = n < 0 ? "" : string2.substring(0, n + 1);
        return string3;
    }

    public void run(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.processOneShader(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

