/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.AnimatorBase;
import java.util.Timer;
import java.util.TimerTask;

public class FPSAnimator
extends AnimatorBase {
    private Timer timer = null;
    private MainTask task = null;
    private int fps;
    private final boolean scheduleAtFixedRate;
    private boolean isAnimating;
    private volatile boolean pauseIssued;
    private volatile boolean stopIssued;
    static int timerNo = 0;
    private final AnimatorBase.Condition waitForStartedAddedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !FPSAnimator.this.isStarted() || !FPSAnimator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForStartedEmptyCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !FPSAnimator.this.isStarted() || FPSAnimator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForStoppedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return FPSAnimator.this.isStarted();
        }
    };
    private final AnimatorBase.Condition waitForPausedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return FPSAnimator.this.isStarted() && FPSAnimator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForResumeCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !FPSAnimator.this.drawablesEmpty && !FPSAnimator.this.isAnimating && FPSAnimator.this.isStarted();
        }
    };

    @Override
    protected String getBaseName(String string2) {
        return "FPS" + string2 + "Animator";
    }

    public FPSAnimator(int n) {
        this(null, n);
    }

    public FPSAnimator(int n, boolean bl) {
        this(null, n, bl);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n) {
        this(gLAutoDrawable, n, false);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n, boolean bl) {
        this.fps = n;
        if (gLAutoDrawable != null) {
            this.add(gLAutoDrawable);
        }
        this.scheduleAtFixedRate = bl;
    }

    public final void setFPS(int n) throws GLException {
        if (this.isStarted()) {
            throw new GLException("Animator already started.");
        }
        this.fps = n;
    }

    public final int getFPS() {
        return this.fps;
    }

    private final boolean isAnimatingImpl() {
        return this.animThread != null && this.isAnimating;
    }

    @Override
    public final synchronized boolean isAnimating() {
        return this.animThread != null && this.isAnimating;
    }

    @Override
    public final synchronized boolean isPaused() {
        return this.animThread != null && this.pauseIssued;
    }

    @Override
    public final synchronized boolean start() {
        if (null != this.timer || null != this.task || this.isStarted()) {
            return false;
        }
        this.timer = new Timer(FPSAnimator.getThreadName() + "-" + this.baseName + "-Timer" + timerNo++);
        this.task = new MainTask();
        if (DEBUG) {
            System.err.println("FPSAnimator.start() START: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        this.task.start(this.timer);
        boolean bl = this.finishLifecycleAction(this.drawablesEmpty ? this.waitForStartedEmptyCondition : this.waitForStartedAddedCondition, 32L);
        if (DEBUG) {
            System.err.println("FPSAnimator.start() END: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        if (this.drawablesEmpty) {
            this.task.cancel();
            this.task = null;
        }
        return bl;
    }

    @Override
    public final synchronized boolean stop() {
        boolean bl;
        if (null == this.timer || !this.isStarted()) {
            return false;
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.stop() START: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        if (null == this.task) {
            bl = true;
        } else {
            this.stopIssued = true;
            bl = this.finishLifecycleAction(this.waitForStoppedCondition, 32L);
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.stop() END: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        if (null != this.task) {
            this.task.cancel();
            this.task = null;
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        this.animThread = null;
        return bl;
    }

    @Override
    public final synchronized boolean pause() {
        boolean bl;
        if (!this.isStarted() || this.pauseIssued) {
            return false;
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.pause() START: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        if (null == this.task) {
            bl = true;
        } else {
            this.pauseIssued = true;
            bl = this.finishLifecycleAction(this.waitForPausedCondition, 32L);
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.pause() END: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        if (null != this.task) {
            this.task.cancel();
            this.task = null;
        }
        return bl;
    }

    @Override
    public final synchronized boolean resume() {
        boolean bl;
        if (!this.isStarted() || !this.pauseIssued) {
            return false;
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.resume() START: " + Thread.currentThread() + ": " + this.toString());
        }
        if (this.drawablesEmpty) {
            bl = true;
        } else {
            if (null != this.task) {
                if (DEBUG) {
                    System.err.println("FPSAnimator.resume() Ops: !pauseIssued, but task != null: " + this.toString());
                    ExceptionUtils.dumpStack(System.err);
                }
                this.task.cancel();
                this.task = null;
            }
            this.task = new MainTask();
            this.task.start(this.timer);
            bl = this.finishLifecycleAction(this.waitForResumeCondition, 32L);
        }
        if (DEBUG) {
            System.err.println("FPSAnimator.resume() END: " + this.task + ", " + Thread.currentThread() + ": " + this.toString());
        }
        return bl;
    }

    class MainTask
    extends TimerTask {
        private boolean justStarted;
        private boolean alreadyStopped;
        private boolean alreadyPaused;

        public void start(Timer timer) {
            long l;
            FPSAnimator.this.fpsCounter.resetFPSCounter();
            FPSAnimator.this.pauseIssued = false;
            FPSAnimator.this.stopIssued = false;
            FPSAnimator.this.isAnimating = false;
            this.justStarted = true;
            this.alreadyStopped = false;
            this.alreadyPaused = false;
            long l2 = l = 0 < FPSAnimator.this.fps ? (long)(1000.0f / (float)FPSAnimator.this.fps) : 1L;
            if (FPSAnimator.this.scheduleAtFixedRate) {
                timer.scheduleAtFixedRate((TimerTask)this, 0L, l);
            } else {
                timer.schedule((TimerTask)this, 0L, l);
            }
        }

        public boolean isActive() {
            return !this.alreadyStopped && !this.alreadyPaused;
        }

        public final String toString() {
            return "Task[thread " + FPSAnimator.this.animThread + ", stopped " + this.alreadyStopped + ", paused " + this.alreadyPaused + " pauseIssued " + FPSAnimator.this.pauseIssued + ", stopIssued " + FPSAnimator.this.stopIssued + " -- started " + FPSAnimator.this.isStarted() + ", animating " + FPSAnimator.this.isAnimatingImpl() + ", paused " + FPSAnimator.this.isPaused() + ", drawable " + FPSAnimator.this.drawables.size() + ", drawablesEmpty " + FPSAnimator.this.drawablesEmpty + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FPSAnimator fPSAnimator;
            AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException = null;
            if (this.justStarted) {
                this.justStarted = false;
                fPSAnimator = FPSAnimator.this;
                synchronized (fPSAnimator) {
                    FPSAnimator.this.animThread = Thread.currentThread();
                    if (AnimatorBase.DEBUG) {
                        System.err.println("FPSAnimator start/resume:" + Thread.currentThread() + ": " + this.toString());
                    }
                    FPSAnimator.this.isAnimating = true;
                    if (FPSAnimator.this.drawablesEmpty) {
                        FPSAnimator.this.pauseIssued = true;
                    } else {
                        FPSAnimator.this.pauseIssued = false;
                        FPSAnimator.this.setDrawablesExclCtxState(FPSAnimator.this.exclusiveContext);
                    }
                    FPSAnimator.this.notifyAll();
                    if (AnimatorBase.DEBUG) {
                        System.err.println("FPSAnimator P1:" + Thread.currentThread() + ": " + this.toString());
                    }
                }
            }
            if (!FPSAnimator.this.pauseIssued && !FPSAnimator.this.stopIssued) {
                try {
                    FPSAnimator.this.display();
                }
                catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException2) {
                    uncaughtAnimatorException = uncaughtAnimatorException2;
                    FPSAnimator.this.stopIssued = true;
                }
            } else if (FPSAnimator.this.pauseIssued && !FPSAnimator.this.stopIssued) {
                if (AnimatorBase.DEBUG) {
                    System.err.println("FPSAnimator pausing: " + this.alreadyPaused + ", " + Thread.currentThread() + ": " + this.toString());
                }
                this.cancel();
                if (!this.alreadyPaused) {
                    this.alreadyPaused = true;
                    if (FPSAnimator.this.exclusiveContext && !FPSAnimator.this.drawablesEmpty) {
                        FPSAnimator.this.setDrawablesExclCtxState(false);
                        try {
                            FPSAnimator.this.display();
                        }
                        catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException3) {
                            uncaughtAnimatorException = uncaughtAnimatorException3;
                            FPSAnimator.this.stopIssued = true;
                        }
                    }
                    if (null == uncaughtAnimatorException) {
                        fPSAnimator = FPSAnimator.this;
                        synchronized (fPSAnimator) {
                            if (AnimatorBase.DEBUG) {
                                System.err.println("FPSAnimator pause " + Thread.currentThread() + ": " + this.toString());
                            }
                            FPSAnimator.this.isAnimating = false;
                            FPSAnimator.this.notifyAll();
                        }
                    }
                }
            }
            if (FPSAnimator.this.stopIssued) {
                if (AnimatorBase.DEBUG) {
                    System.err.println("FPSAnimator stopping: " + this.alreadyStopped + ", " + Thread.currentThread() + ": " + this.toString());
                }
                this.cancel();
                if (!this.alreadyStopped) {
                    this.alreadyStopped = true;
                    if (FPSAnimator.this.exclusiveContext && !FPSAnimator.this.drawablesEmpty) {
                        FPSAnimator.this.setDrawablesExclCtxState(false);
                        try {
                            FPSAnimator.this.display();
                        }
                        catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException4) {
                            if (null == uncaughtAnimatorException) {
                                uncaughtAnimatorException = uncaughtAnimatorException4;
                            }
                            System.err.println("FPSAnimator.setExclusiveContextThread: caught: " + uncaughtAnimatorException4.getMessage());
                            uncaughtAnimatorException4.printStackTrace();
                        }
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    FPSAnimator fPSAnimator2 = FPSAnimator.this;
                    synchronized (fPSAnimator2) {
                        if (AnimatorBase.DEBUG) {
                            System.err.println("FPSAnimator stop " + Thread.currentThread() + ": " + this.toString());
                            if (null != uncaughtAnimatorException) {
                                System.err.println("Animator caught: " + uncaughtAnimatorException.getMessage());
                                uncaughtAnimatorException.printStackTrace();
                            }
                        }
                        FPSAnimator.this.isAnimating = false;
                        if (null != uncaughtAnimatorException) {
                            bl = true;
                            bl2 = !FPSAnimator.this.handleUncaughtException(uncaughtAnimatorException);
                        }
                        FPSAnimator.this.animThread = null;
                        FPSAnimator.this.notifyAll();
                    }
                    if (bl) {
                        FPSAnimator.this.flushGLRunnables();
                    }
                    if (bl2) {
                        throw uncaughtAnimatorException;
                    }
                }
            }
        }
    }
}

