/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.VectorUtil;
import java.nio.FloatBuffer;
import jogamp.opengl.Debug;

public final class FloatUtil {
    public static final boolean DEBUG = Debug.debug("Math");
    private static volatile boolean machEpsilonAvail = false;
    private static float machEpsilon = 0.0f;
    private static final boolean DEBUG_EPSILON = false;
    public static final float E = (float)Math.E;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float SQUARED_PI = 9.869605f;
    public static final float EPSILON = 1.1920929E-7f;
    public static final float INV_DEVIANCE = 1.0E-5f;

    public static float[] makeIdentity(float[] fArray, int n) {
        fArray[n + 0 + 0] = 1.0f;
        fArray[n + 1 + 0] = 0.0f;
        fArray[n + 2 + 0] = 0.0f;
        fArray[n + 3 + 0] = 0.0f;
        fArray[n + 0 + 4] = 0.0f;
        fArray[n + 1 + 4] = 1.0f;
        fArray[n + 2 + 4] = 0.0f;
        fArray[n + 3 + 4] = 0.0f;
        fArray[n + 0 + 8] = 0.0f;
        fArray[n + 1 + 8] = 0.0f;
        fArray[n + 2 + 8] = 1.0f;
        fArray[n + 3 + 8] = 0.0f;
        fArray[n + 0 + 12] = 0.0f;
        fArray[n + 1 + 12] = 0.0f;
        fArray[n + 2 + 12] = 0.0f;
        fArray[n + 3 + 12] = 1.0f;
        return fArray;
    }

    public static float[] makeIdentity(float[] fArray) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        return fArray;
    }

    public static float[] makeTranslation(float[] fArray, int n, boolean bl, float f, float f2, float f3) {
        if (bl) {
            FloatUtil.makeIdentity(fArray, n);
        } else {
            fArray[n + 0 + 0] = 1.0f;
            fArray[n + 1 + 4] = 1.0f;
            fArray[n + 2 + 8] = 1.0f;
            fArray[n + 3 + 12] = 1.0f;
        }
        fArray[n + 0 + 12] = f;
        fArray[n + 1 + 12] = f2;
        fArray[n + 2 + 12] = f3;
        return fArray;
    }

    public static float[] makeTranslation(float[] fArray, boolean bl, float f, float f2, float f3) {
        if (bl) {
            FloatUtil.makeIdentity(fArray);
        } else {
            fArray[0] = 1.0f;
            fArray[5] = 1.0f;
            fArray[10] = 1.0f;
            fArray[15] = 1.0f;
        }
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        return fArray;
    }

    public static float[] makeScale(float[] fArray, int n, boolean bl, float f, float f2, float f3) {
        if (bl) {
            FloatUtil.makeIdentity(fArray, n);
        } else {
            fArray[n + 0 + 12] = 0.0f;
            fArray[n + 1 + 12] = 0.0f;
            fArray[n + 2 + 12] = 0.0f;
            fArray[n + 3 + 12] = 1.0f;
        }
        fArray[n + 0 + 0] = f;
        fArray[n + 1 + 4] = f2;
        fArray[n + 2 + 8] = f3;
        return fArray;
    }

    public static float[] makeScale(float[] fArray, boolean bl, float f, float f2, float f3) {
        if (bl) {
            FloatUtil.makeIdentity(fArray);
        } else {
            fArray[12] = 0.0f;
            fArray[13] = 0.0f;
            fArray[14] = 0.0f;
            fArray[15] = 1.0f;
        }
        fArray[0] = f;
        fArray[5] = f2;
        fArray[10] = f3;
        return fArray;
    }

    public static float[] makeRotationAxis(float[] fArray, int n, float f, float f2, float f3, float f4, float[] fArray2) {
        float f5 = FloatUtil.cos(f);
        float f6 = 1.0f - f5;
        float f7 = FloatUtil.sin(f);
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray2[2] = f4;
        VectorUtil.normalizeVec3(fArray2);
        f2 = fArray2[0];
        f3 = fArray2[1];
        f4 = fArray2[2];
        float f8 = f2 * f3;
        float f9 = f2 * f4;
        float f10 = f2 * f7;
        float f11 = f3 * f7;
        float f12 = f3 * f4;
        float f13 = f4 * f7;
        fArray[0 + n] = f2 * f2 * f6 + f5;
        fArray[1 + n] = f8 * f6 + f13;
        fArray[2 + n] = f9 * f6 - f11;
        fArray[3 + n] = 0.0f;
        fArray[4 + n] = f8 * f6 - f13;
        fArray[5 + n] = f3 * f3 * f6 + f5;
        fArray[6 + n] = f12 * f6 + f10;
        fArray[7 + n] = 0.0f;
        fArray[8 + n] = f9 * f6 + f11;
        fArray[9 + n] = f12 * f6 - f10;
        fArray[10 + n] = f4 * f4 * f6 + f5;
        fArray[11 + n] = 0.0f;
        fArray[12 + n] = 0.0f;
        fArray[13 + n] = 0.0f;
        fArray[14 + n] = 0.0f;
        fArray[15 + n] = 1.0f;
        return fArray;
    }

    public static float[] makeRotationEuler(float[] fArray, int n, float f, float f2, float f3) {
        float f4 = FloatUtil.cos(f2);
        float f5 = FloatUtil.sin(f2);
        float f6 = FloatUtil.cos(f3);
        float f7 = FloatUtil.sin(f3);
        float f8 = FloatUtil.cos(f);
        float f9 = FloatUtil.sin(f);
        fArray[0 + n] = f4 * f6;
        fArray[1 + n] = f7;
        fArray[2 + n] = -f5 * f6;
        fArray[3 + n] = 0.0f;
        fArray[4 + n] = f5 * f9 - f4 * f7 * f8;
        fArray[5 + n] = f6 * f8;
        fArray[6 + n] = f5 * f7 * f8 + f4 * f9;
        fArray[7 + n] = 0.0f;
        fArray[8 + n] = f4 * f7 * f9 + f5 * f8;
        fArray[9 + n] = -f6 * f9;
        fArray[10 + n] = -f5 * f7 * f9 + f4 * f8;
        fArray[11 + n] = 0.0f;
        fArray[12 + n] = 0.0f;
        fArray[13 + n] = 0.0f;
        fArray[14 + n] = 0.0f;
        fArray[15 + n] = 1.0f;
        return fArray;
    }

    public static float[] makeOrtho(float[] fArray, int n, boolean bl, float f, float f2, float f3, float f4, float f5, float f6) {
        if (bl) {
            fArray[n + 1 + 0] = 0.0f;
            fArray[n + 2 + 0] = 0.0f;
            fArray[n + 3 + 0] = 0.0f;
            fArray[n + 0 + 4] = 0.0f;
            fArray[n + 2 + 4] = 0.0f;
            fArray[n + 3 + 4] = 0.0f;
            fArray[n + 0 + 8] = 0.0f;
            fArray[n + 1 + 8] = 0.0f;
            fArray[n + 3 + 8] = 0.0f;
        }
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        float f10 = -1.0f * (f2 + f) / f7;
        float f11 = -1.0f * (f4 + f3) / f8;
        float f12 = -1.0f * (f6 + f5) / f9;
        fArray[n + 0 + 0] = 2.0f / f7;
        fArray[n + 1 + 4] = 2.0f / f8;
        fArray[n + 2 + 8] = -2.0f / f9;
        fArray[n + 0 + 12] = f10;
        fArray[n + 1 + 12] = f11;
        fArray[n + 2 + 12] = f12;
        fArray[n + 3 + 12] = 1.0f;
        return fArray;
    }

    public static float[] makeFrustum(float[] fArray, int n, boolean bl, float f, float f2, float f3, float f4, float f5, float f6) throws GLException {
        if (f5 <= 0.0f || f6 <= f5) {
            throw new GLException("Requirements zNear > 0 and zFar > zNear, but zNear " + f5 + ", zFar " + f6);
        }
        if (f == f2 || f4 == f3) {
            throw new GLException("GL_INVALID_VALUE: top,bottom and left,right must not be equal");
        }
        if (bl) {
            fArray[n + 1 + 0] = 0.0f;
            fArray[n + 2 + 0] = 0.0f;
            fArray[n + 3 + 0] = 0.0f;
            fArray[n + 0 + 4] = 0.0f;
            fArray[n + 2 + 4] = 0.0f;
            fArray[n + 3 + 4] = 0.0f;
            fArray[n + 0 + 12] = 0.0f;
            fArray[n + 1 + 12] = 0.0f;
        }
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        float f11 = (f2 + f) / f8;
        float f12 = (f4 + f3) / f9;
        float f13 = -1.0f * (f6 + f5) / f10;
        float f14 = -2.0f * (f6 * f5) / f10;
        fArray[n + 0 + 0] = f7 / f8;
        fArray[n + 1 + 4] = f7 / f9;
        fArray[n + 0 + 8] = f11;
        fArray[n + 1 + 8] = f12;
        fArray[n + 2 + 8] = f13;
        fArray[n + 3 + 8] = -1.0f;
        fArray[n + 2 + 12] = f14;
        fArray[n + 3 + 12] = 0.0f;
        return fArray;
    }

    public static float[] makePerspective(float[] fArray, int n, boolean bl, float f, float f2, float f3, float f4) throws GLException {
        float f5 = FloatUtil.tan(f / 2.0f) * f3;
        float f6 = -1.0f * f5;
        float f7 = f2 * f6;
        float f8 = f2 * f5;
        return FloatUtil.makeFrustum(fArray, n, bl, f7, f8, f6, f5, f3, f4);
    }

    public static float[] makePerspective(float[] fArray, int n, boolean bl, FovHVHalves fovHVHalves, float f, float f2) throws GLException {
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        float f3 = fovHVHalves2.top * f;
        float f4 = -1.0f * fovHVHalves2.bottom * f;
        float f5 = -1.0f * fovHVHalves2.left * f;
        float f6 = fovHVHalves2.right * f;
        return FloatUtil.makeFrustum(fArray, n, bl, f5, f6, f4, f3, f, f2);
    }

    public static float[] makeLookAt(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, float[] fArray4, int n4, float[] fArray5) {
        fArray5[0] = fArray3[0 + n3] - fArray2[0 + n2];
        fArray5[1] = fArray3[1 + n3] - fArray2[1 + n2];
        fArray5[2] = fArray3[2 + n3] - fArray2[2 + n2];
        VectorUtil.normalizeVec3(fArray5);
        VectorUtil.crossVec3(fArray5, 3, fArray5, 0, fArray4, n4);
        VectorUtil.normalizeVec3(fArray5, 3);
        VectorUtil.crossVec3(fArray5, 6, fArray5, 3, fArray5, 0);
        fArray[n + 0 + 0] = fArray5[3];
        fArray[n + 0 + 1] = fArray5[6];
        fArray[n + 0 + 2] = -fArray5[0];
        fArray[n + 0 + 3] = 0.0f;
        fArray[n + 4 + 0] = fArray5[4];
        fArray[n + 4 + 1] = fArray5[7];
        fArray[n + 4 + 2] = -fArray5[1];
        fArray[n + 4 + 3] = 0.0f;
        fArray[n + 8 + 0] = fArray5[5];
        fArray[n + 8 + 1] = fArray5[8];
        fArray[n + 8 + 2] = -fArray5[2];
        fArray[n + 8 + 3] = 0.0f;
        fArray[n + 12 + 0] = 0.0f;
        fArray[n + 12 + 1] = 0.0f;
        fArray[n + 12 + 2] = 0.0f;
        fArray[n + 12 + 3] = 1.0f;
        FloatUtil.makeTranslation(fArray5, true, -fArray2[0 + n2], -fArray2[1 + n2], -fArray2[2 + n2]);
        FloatUtil.multMatrix(fArray, n, fArray5, 0);
        return fArray;
    }

    public static float[] makePick(float[] fArray, int n, float f, float f2, float f3, float f4, int[] nArray, int n2, float[] fArray2) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return null;
        }
        FloatUtil.makeTranslation(fArray, n, true, ((float)nArray[2 + n2] - 2.0f * (f - (float)nArray[0 + n2])) / f3, ((float)nArray[3 + n2] - 2.0f * (f2 - (float)nArray[1 + n2])) / f4, 0.0f);
        FloatUtil.makeScale(fArray2, true, (float)nArray[2 + n2] / f3, (float)nArray[3 + n2] / f4, 1.0f);
        FloatUtil.multMatrix(fArray, n, fArray2, 0);
        return fArray;
    }

    public static float[] transposeMatrix(float[] fArray, int n, float[] fArray2, int n2) {
        fArray2[n2 + 0] = fArray[n + 0];
        fArray2[n2 + 1] = fArray[n + 4];
        fArray2[n2 + 2] = fArray[n + 8];
        fArray2[n2 + 3] = fArray[n + 12];
        fArray2[n2 + 0 + 4] = fArray[n + 1 + 0];
        fArray2[n2 + 1 + 4] = fArray[n + 1 + 4];
        fArray2[n2 + 2 + 4] = fArray[n + 1 + 8];
        fArray2[n2 + 3 + 4] = fArray[n + 1 + 12];
        fArray2[n2 + 0 + 8] = fArray[n + 2 + 0];
        fArray2[n2 + 1 + 8] = fArray[n + 2 + 4];
        fArray2[n2 + 2 + 8] = fArray[n + 2 + 8];
        fArray2[n2 + 3 + 8] = fArray[n + 2 + 12];
        fArray2[n2 + 0 + 12] = fArray[n + 3 + 0];
        fArray2[n2 + 1 + 12] = fArray[n + 3 + 4];
        fArray2[n2 + 2 + 12] = fArray[n + 3 + 8];
        fArray2[n2 + 3 + 12] = fArray[n + 3 + 12];
        return fArray2;
    }

    public static float[] transposeMatrix(float[] fArray, float[] fArray2) {
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[4];
        fArray2[2] = fArray[8];
        fArray2[3] = fArray[12];
        fArray2[4] = fArray[1];
        fArray2[5] = fArray[5];
        fArray2[6] = fArray[9];
        fArray2[7] = fArray[13];
        fArray2[8] = fArray[2];
        fArray2[9] = fArray[6];
        fArray2[10] = fArray[10];
        fArray2[11] = fArray[14];
        fArray2[12] = fArray[3];
        fArray2[13] = fArray[7];
        fArray2[14] = fArray[11];
        fArray2[15] = fArray[15];
        return fArray2;
    }

    public static float matrixDeterminant(float[] fArray, int n) {
        float f = fArray[5 + n];
        float f2 = fArray[6 + n];
        float f3 = fArray[7 + n];
        float f4 = fArray[9 + n];
        float f5 = fArray[10 + n];
        float f6 = fArray[11 + n];
        float f7 = fArray[13 + n];
        float f8 = fArray[14 + n];
        float f9 = fArray[15 + n];
        float f10 = 0.0f;
        f10 += fArray[0 + n] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f = fArray[1 + n];
        f2 = fArray[2 + n];
        f3 = fArray[3 + n];
        f10 -= fArray[4 + n] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f4 = fArray[5 + n];
        f5 = fArray[6 + n];
        f6 = fArray[7 + n];
        f10 += fArray[8 + n] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f7 = fArray[9 + n];
        f8 = fArray[10 + n];
        f9 = fArray[11 + n];
        return f10 -= fArray[12 + n] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
    }

    public static float matrixDeterminant(float[] fArray) {
        float f = fArray[5];
        float f2 = fArray[6];
        float f3 = fArray[7];
        float f4 = fArray[9];
        float f5 = fArray[10];
        float f6 = fArray[11];
        float f7 = fArray[13];
        float f8 = fArray[14];
        float f9 = fArray[15];
        float f10 = 0.0f;
        f10 += fArray[0] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f = fArray[1];
        f2 = fArray[2];
        f3 = fArray[3];
        f10 -= fArray[4] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f4 = fArray[5];
        f5 = fArray[6];
        f6 = fArray[7];
        f10 += fArray[8] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
        f7 = fArray[9];
        f8 = fArray[10];
        f9 = fArray[11];
        return f10 -= fArray[12] * (f * (f5 * f9 - f8 * f6) - f4 * (f2 * f9 - f8 * f3) + f7 * (f2 * f6 - f5 * f3));
    }

    public static float[] invertMatrix(float[] fArray, int n, float[] fArray2, int n2) {
        float f;
        float f2 = Math.abs(fArray[0]);
        for (int i = 1; i < 16; ++i) {
            f = Math.abs(fArray[i]);
            if (!(f > f2)) continue;
            f2 = f;
        }
        if (0.0f == f2) {
            return null;
        }
        float f3 = 1.0f / f2;
        f2 = fArray[0 + n] * f3;
        float f4 = fArray[1 + n] * f3;
        f = fArray[2 + n] * f3;
        float f5 = fArray[3 + n] * f3;
        float f6 = fArray[4 + n] * f3;
        float f7 = fArray[5 + n] * f3;
        float f8 = fArray[6 + n] * f3;
        float f9 = fArray[7 + n] * f3;
        float f10 = fArray[8 + n] * f3;
        float f11 = fArray[9 + n] * f3;
        float f12 = fArray[10 + n] * f3;
        float f13 = fArray[11 + n] * f3;
        float f14 = fArray[12 + n] * f3;
        float f15 = fArray[13 + n] * f3;
        float f16 = fArray[14 + n] * f3;
        float f17 = fArray[15 + n] * f3;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f4 * (f12 * f17 - f16 * f13) - f11 * (f * f17 - f16 * f5) + f15 * (f * f13 - f12 * f5));
        float f20 = f4 * (f8 * f17 - f16 * f9) - f7 * (f * f17 - f16 * f5) + f15 * (f * f9 - f8 * f5);
        float f21 = -(f4 * (f8 * f13 - f12 * f9) - f7 * (f * f13 - f12 * f5) + f11 * (f * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f * f17 - f16 * f5) + f14 * (f * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f * f17 - f16 * f5) + f14 * (f * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f * f13 - f12 * f5) + f10 * (f * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f4 * f17 - f15 * f5) + f14 * (f4 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f4 * f17 - f15 * f5) + f14 * (f4 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f4 * f13 - f11 * f5) + f10 * (f4 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f4 * f16 - f15 * f) + f14 * (f4 * f12 - f11 * f);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f4 * f16 - f15 * f) + f14 * (f4 * f8 - f7 * f));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f4 * f12 - f11 * f) + f10 * (f4 * f8 - f7 * f);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f3;
        if (0.0f == f34) {
            return null;
        }
        fArray2[0 + n2] = f18 / f34;
        fArray2[1 + n2] = f19 / f34;
        fArray2[2 + n2] = f20 / f34;
        fArray2[3 + n2] = f21 / f34;
        fArray2[4 + n2] = f22 / f34;
        fArray2[5 + n2] = f23 / f34;
        fArray2[6 + n2] = f24 / f34;
        fArray2[7 + n2] = f25 / f34;
        fArray2[8 + n2] = f26 / f34;
        fArray2[9 + n2] = f27 / f34;
        fArray2[10 + n2] = f28 / f34;
        fArray2[11 + n2] = f29 / f34;
        fArray2[12 + n2] = f30 / f34;
        fArray2[13 + n2] = f31 / f34;
        fArray2[14 + n2] = f32 / f34;
        fArray2[15 + n2] = f33 / f34;
        return fArray2;
    }

    public static float[] invertMatrix(float[] fArray, float[] fArray2) {
        float f;
        float f2 = Math.abs(fArray[0]);
        for (int i = 1; i < 16; ++i) {
            f = Math.abs(fArray[i]);
            if (!(f > f2)) continue;
            f2 = f;
        }
        if (0.0f == f2) {
            return null;
        }
        float f3 = 1.0f / f2;
        f2 = fArray[0] * f3;
        float f4 = fArray[1] * f3;
        f = fArray[2] * f3;
        float f5 = fArray[3] * f3;
        float f6 = fArray[4] * f3;
        float f7 = fArray[5] * f3;
        float f8 = fArray[6] * f3;
        float f9 = fArray[7] * f3;
        float f10 = fArray[8] * f3;
        float f11 = fArray[9] * f3;
        float f12 = fArray[10] * f3;
        float f13 = fArray[11] * f3;
        float f14 = fArray[12] * f3;
        float f15 = fArray[13] * f3;
        float f16 = fArray[14] * f3;
        float f17 = fArray[15] * f3;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f4 * (f12 * f17 - f16 * f13) - f11 * (f * f17 - f16 * f5) + f15 * (f * f13 - f12 * f5));
        float f20 = f4 * (f8 * f17 - f16 * f9) - f7 * (f * f17 - f16 * f5) + f15 * (f * f9 - f8 * f5);
        float f21 = -(f4 * (f8 * f13 - f12 * f9) - f7 * (f * f13 - f12 * f5) + f11 * (f * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f * f17 - f16 * f5) + f14 * (f * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f * f17 - f16 * f5) + f14 * (f * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f * f13 - f12 * f5) + f10 * (f * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f4 * f17 - f15 * f5) + f14 * (f4 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f4 * f17 - f15 * f5) + f14 * (f4 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f4 * f13 - f11 * f5) + f10 * (f4 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f4 * f16 - f15 * f) + f14 * (f4 * f12 - f11 * f);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f4 * f16 - f15 * f) + f14 * (f4 * f8 - f7 * f));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f4 * f12 - f11 * f) + f10 * (f4 * f8 - f7 * f);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f3;
        if (0.0f == f34) {
            return null;
        }
        fArray2[0] = f18 / f34;
        fArray2[1] = f19 / f34;
        fArray2[2] = f20 / f34;
        fArray2[3] = f21 / f34;
        fArray2[4] = f22 / f34;
        fArray2[5] = f23 / f34;
        fArray2[6] = f24 / f34;
        fArray2[7] = f25 / f34;
        fArray2[8] = f26 / f34;
        fArray2[9] = f27 / f34;
        fArray2[10] = f28 / f34;
        fArray2[11] = f29 / f34;
        fArray2[12] = f30 / f34;
        fArray2[13] = f31 / f34;
        fArray2[14] = f32 / f34;
        fArray2[15] = f33 / f34;
        return fArray2;
    }

    public static boolean mapObjToWinCoords(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4, float[] fArray4, float[] fArray5) {
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVec(fArray, n, fArray4, 0, fArray5, 0);
        FloatUtil.multMatrixVec(fArray2, n2, fArray5, 0, fArray4, 0);
        if (fArray4[3] == 0.0f) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3] * 0.5f;
        fArray4[0] = fArray4[0] * fArray4[3] + 0.5f;
        fArray4[1] = fArray4[1] * fArray4[3] + 0.5f;
        fArray4[2] = fArray4[2] * fArray4[3] + 0.5f;
        fArray3[0 + n4] = fArray4[0] * (float)nArray[2 + n3] + (float)nArray[0 + n3];
        fArray3[1 + n4] = fArray4[1] * (float)nArray[3 + n3] + (float)nArray[1 + n3];
        fArray3[2 + n4] = fArray4[2];
        return true;
    }

    public static boolean mapObjToWinCoords(float f, float f2, float f3, float[] fArray, int[] nArray, int n, float[] fArray2, int n2, float[] fArray3, float[] fArray4) {
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray3);
        if (fArray3[3] == 0.0f) {
            return false;
        }
        fArray3[3] = 1.0f / fArray3[3] * 0.5f;
        fArray3[0] = fArray3[0] * fArray3[3] + 0.5f;
        fArray3[1] = fArray3[1] * fArray3[3] + 0.5f;
        fArray3[2] = fArray3[2] * fArray3[3] + 0.5f;
        fArray2[0 + n2] = fArray3[0] * (float)nArray[2 + n] + (float)nArray[0 + n];
        fArray2[1 + n2] = fArray3[1] * (float)nArray[3 + n] + (float)nArray[1 + n];
        fArray2[2 + n2] = fArray3[2];
        return true;
    }

    public static boolean mapWinToObjCoords(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n2, fArray, n, fArray4, 0);
        if (null == FloatUtil.invertMatrix(fArray4, fArray4)) {
            return false;
        }
        fArray5[0] = f;
        fArray5[1] = f2;
        fArray5[2] = f3;
        fArray5[3] = 1.0f;
        fArray5[0] = (fArray5[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray5[1] = (fArray5[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray5[0] = fArray5[0] * 2.0f - 1.0f;
        fArray5[1] = fArray5[1] * 2.0f - 1.0f;
        fArray5[2] = fArray5[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray4, 0, fArray5, 0, fArray5, 4);
        if ((double)fArray5[7] == 0.0) {
            return false;
        }
        fArray5[7] = 1.0f / fArray5[7];
        fArray3[0 + n4] = fArray5[4] * fArray5[7];
        fArray3[1 + n4] = fArray5[5] * fArray5[7];
        fArray3[2 + n4] = fArray5[6] * fArray5[7];
        return true;
    }

    public static boolean mapWinToObjCoords(float f, float f2, float f3, float[] fArray, int[] nArray, int n, float[] fArray2, int n2, float[] fArray3, float[] fArray4) {
        fArray3[0] = f;
        fArray3[1] = f2;
        fArray3[2] = f3;
        fArray3[3] = 1.0f;
        fArray3[0] = (fArray3[0] - (float)nArray[0 + n]) / (float)nArray[2 + n];
        fArray3[1] = (fArray3[1] - (float)nArray[1 + n]) / (float)nArray[3 + n];
        fArray3[0] = fArray3[0] * 2.0f - 1.0f;
        fArray3[1] = fArray3[1] * 2.0f - 1.0f;
        fArray3[2] = fArray3[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray3, fArray4);
        if ((double)fArray4[3] == 0.0) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3];
        fArray2[0 + n2] = fArray4[0] * fArray4[3];
        fArray2[1 + n2] = fArray4[1] * fArray4[3];
        fArray2[2 + n2] = fArray4[2] * fArray4[3];
        return true;
    }

    public static boolean mapWinToObjCoords(float f, float f2, float f3, float f4, float[] fArray, int[] nArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, float[] fArray4, float[] fArray5) {
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[3] = 1.0f;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n]) / (float)nArray[2 + n];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n]) / (float)nArray[3 + n];
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = f3;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray2[0 + n2] = fArray5[0] * fArray5[3];
        fArray2[1 + n2] = fArray5[1] * fArray5[3];
        fArray2[2 + n2] = fArray5[2] * fArray5[3];
        fArray4[2] = f4;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray3[0 + n3] = fArray5[0] * fArray5[3];
        fArray3[1 + n3] = fArray5[1] * fArray5[3];
        fArray3[2 + n3] = fArray5[2] * fArray5[3];
        return true;
    }

    public static boolean mapWinToObjCoords(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float f5, float f6, float[] fArray3, int n4, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n2, fArray, n, fArray4, 0);
        if (null == FloatUtil.invertMatrix(fArray4, fArray4)) {
            return false;
        }
        fArray5[0] = f;
        fArray5[1] = f2;
        fArray5[2] = f3;
        fArray5[3] = 1.0f;
        fArray5[0] = (fArray5[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray5[1] = (fArray5[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray5[2] = (fArray5[2] - f5) / (f6 - f5);
        fArray5[0] = fArray5[0] * 2.0f - 1.0f;
        fArray5[1] = fArray5[1] * 2.0f - 1.0f;
        fArray5[2] = fArray5[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray4, 0, fArray5, 0, fArray5, 4);
        if ((double)fArray5[7] == 0.0) {
            return false;
        }
        fArray5[7] = 1.0f / fArray5[7];
        fArray3[0 + n4] = fArray5[4];
        fArray3[1 + n4] = fArray5[5];
        fArray3[2 + n4] = fArray5[6];
        fArray3[3 + n4] = fArray5[7];
        return true;
    }

    public static boolean mapWinToRay(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, Ray ray, float[] fArray3, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n2, fArray, n, fArray3, 0);
        if (null == FloatUtil.invertMatrix(fArray3, fArray3)) {
            return false;
        }
        if (FloatUtil.mapWinToObjCoords(f, f2, f3, f4, fArray3, nArray, n3, ray.orig, 0, ray.dir, 0, fArray4, fArray5)) {
            VectorUtil.normalizeVec3(VectorUtil.subVec3(ray.dir, ray.dir, ray.orig));
            return true;
        }
        return false;
    }

    public static float[] multMatrix(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f = fArray2[n2 + 0 + 0];
        float f2 = fArray2[n2 + 1 + 0];
        float f3 = fArray2[n2 + 2 + 0];
        float f4 = fArray2[n2 + 3 + 0];
        float f5 = fArray2[n2 + 0 + 4];
        float f6 = fArray2[n2 + 1 + 4];
        float f7 = fArray2[n2 + 2 + 4];
        float f8 = fArray2[n2 + 3 + 4];
        float f9 = fArray2[n2 + 0 + 8];
        float f10 = fArray2[n2 + 1 + 8];
        float f11 = fArray2[n2 + 2 + 8];
        float f12 = fArray2[n2 + 3 + 8];
        float f13 = fArray2[n2 + 0 + 12];
        float f14 = fArray2[n2 + 1 + 12];
        float f15 = fArray2[n2 + 2 + 12];
        float f16 = fArray2[n2 + 3 + 12];
        float f17 = fArray[n + 0];
        float f18 = fArray[n + 4];
        float f19 = fArray[n + 8];
        float f20 = fArray[n + 12];
        fArray3[n3 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[n3 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[n3 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[n3 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 1 + 0];
        f18 = fArray[n + 1 + 4];
        f19 = fArray[n + 1 + 8];
        f20 = fArray[n + 1 + 12];
        fArray3[n3 + 1 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[n3 + 1 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[n3 + 1 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[n3 + 1 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 2 + 0];
        f18 = fArray[n + 2 + 4];
        f19 = fArray[n + 2 + 8];
        f20 = fArray[n + 2 + 12];
        fArray3[n3 + 2 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[n3 + 2 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[n3 + 2 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[n3 + 2 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 3 + 0];
        f18 = fArray[n + 3 + 4];
        f19 = fArray[n + 3 + 8];
        f20 = fArray[n + 3 + 12];
        fArray3[n3 + 3 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[n3 + 3 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[n3 + 3 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[n3 + 3 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return fArray3;
    }

    public static float[] multMatrix(float[] fArray, float[] fArray2, float[] fArray3) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        float f4 = fArray2[3];
        float f5 = fArray2[4];
        float f6 = fArray2[5];
        float f7 = fArray2[6];
        float f8 = fArray2[7];
        float f9 = fArray2[8];
        float f10 = fArray2[9];
        float f11 = fArray2[10];
        float f12 = fArray2[11];
        float f13 = fArray2[12];
        float f14 = fArray2[13];
        float f15 = fArray2[14];
        float f16 = fArray2[15];
        float f17 = fArray[0];
        float f18 = fArray[4];
        float f19 = fArray[8];
        float f20 = fArray[12];
        fArray3[0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[1];
        f18 = fArray[5];
        f19 = fArray[9];
        f20 = fArray[13];
        fArray3[1] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[5] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[9] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[13] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[2];
        f18 = fArray[6];
        f19 = fArray[10];
        f20 = fArray[14];
        fArray3[2] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[6] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[10] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[14] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[3];
        f18 = fArray[7];
        f19 = fArray[11];
        f20 = fArray[15];
        fArray3[3] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray3[7] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray3[11] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray3[15] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return fArray3;
    }

    public static float[] multMatrix(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 0 + 0];
        float f2 = fArray2[n2 + 1 + 0];
        float f3 = fArray2[n2 + 2 + 0];
        float f4 = fArray2[n2 + 3 + 0];
        float f5 = fArray2[n2 + 0 + 4];
        float f6 = fArray2[n2 + 1 + 4];
        float f7 = fArray2[n2 + 2 + 4];
        float f8 = fArray2[n2 + 3 + 4];
        float f9 = fArray2[n2 + 0 + 8];
        float f10 = fArray2[n2 + 1 + 8];
        float f11 = fArray2[n2 + 2 + 8];
        float f12 = fArray2[n2 + 3 + 8];
        float f13 = fArray2[n2 + 0 + 12];
        float f14 = fArray2[n2 + 1 + 12];
        float f15 = fArray2[n2 + 2 + 12];
        float f16 = fArray2[n2 + 3 + 12];
        float f17 = fArray[n + 0];
        float f18 = fArray[n + 4];
        float f19 = fArray[n + 8];
        float f20 = fArray[n + 12];
        fArray[n + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[n + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[n + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[n + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 1 + 0];
        f18 = fArray[n + 1 + 4];
        f19 = fArray[n + 1 + 8];
        f20 = fArray[n + 1 + 12];
        fArray[n + 1 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[n + 1 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[n + 1 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[n + 1 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 2 + 0];
        f18 = fArray[n + 2 + 4];
        f19 = fArray[n + 2 + 8];
        f20 = fArray[n + 2 + 12];
        fArray[n + 2 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[n + 2 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[n + 2 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[n + 2 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[n + 3 + 0];
        f18 = fArray[n + 3 + 4];
        f19 = fArray[n + 3 + 8];
        f20 = fArray[n + 3 + 12];
        fArray[n + 3 + 0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[n + 3 + 4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[n + 3 + 8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[n + 3 + 12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return fArray;
    }

    public static float[] multMatrix(float[] fArray, float[] fArray2) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        float f4 = fArray2[3];
        float f5 = fArray2[4];
        float f6 = fArray2[5];
        float f7 = fArray2[6];
        float f8 = fArray2[7];
        float f9 = fArray2[8];
        float f10 = fArray2[9];
        float f11 = fArray2[10];
        float f12 = fArray2[11];
        float f13 = fArray2[12];
        float f14 = fArray2[13];
        float f15 = fArray2[14];
        float f16 = fArray2[15];
        float f17 = fArray[0];
        float f18 = fArray[4];
        float f19 = fArray[8];
        float f20 = fArray[12];
        fArray[0] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[4] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[8] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[12] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[1];
        f18 = fArray[5];
        f19 = fArray[9];
        f20 = fArray[13];
        fArray[1] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[5] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[9] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[13] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[2];
        f18 = fArray[6];
        f19 = fArray[10];
        f20 = fArray[14];
        fArray[2] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[6] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[10] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[14] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        f17 = fArray[3];
        f18 = fArray[7];
        f19 = fArray[11];
        f20 = fArray[15];
        fArray[3] = f17 * f + f18 * f2 + f19 * f3 + f20 * f4;
        fArray[7] = f17 * f5 + f18 * f6 + f19 * f7 + f20 * f8;
        fArray[11] = f17 * f9 + f18 * f10 + f19 * f11 + f20 * f12;
        fArray[15] = f17 * f13 + f18 * f14 + f19 * f15 + f20 * f16;
        return fArray;
    }

    public static void multMatrix(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, float[] fArray) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        for (int i = 0; i < 4; ++i) {
            int n3 = n + i;
            float f = floatBuffer.get(n3 + 0);
            float f2 = floatBuffer.get(n3 + 4);
            float f3 = floatBuffer.get(n3 + 8);
            float f4 = floatBuffer.get(n3 + 12);
            fArray[i + 0] = f * floatBuffer2.get(n2 + 0 + 0) + f2 * floatBuffer2.get(n2 + 1 + 0) + f3 * floatBuffer2.get(n2 + 2 + 0) + f4 * floatBuffer2.get(n2 + 3 + 0);
            fArray[i + 4] = f * floatBuffer2.get(n2 + 0 + 4) + f2 * floatBuffer2.get(n2 + 1 + 4) + f3 * floatBuffer2.get(n2 + 2 + 4) + f4 * floatBuffer2.get(n2 + 3 + 4);
            fArray[i + 8] = f * floatBuffer2.get(n2 + 0 + 8) + f2 * floatBuffer2.get(n2 + 1 + 8) + f3 * floatBuffer2.get(n2 + 2 + 8) + f4 * floatBuffer2.get(n2 + 3 + 8);
            fArray[i + 12] = f * floatBuffer2.get(n2 + 0 + 12) + f2 * floatBuffer2.get(n2 + 1 + 12) + f3 * floatBuffer2.get(n2 + 2 + 12) + f4 * floatBuffer2.get(n2 + 3 + 12);
        }
    }

    public static void multMatrix(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        for (int i = 0; i < 4; ++i) {
            int n3 = n + i;
            float f = floatBuffer.get(n3 + 0);
            float f2 = floatBuffer.get(n3 + 4);
            float f3 = floatBuffer.get(n3 + 8);
            float f4 = floatBuffer.get(n3 + 12);
            floatBuffer.put(n3 + 0, f * floatBuffer2.get(n2 + 0 + 0) + f2 * floatBuffer2.get(n2 + 1 + 0) + f3 * floatBuffer2.get(n2 + 2 + 0) + f4 * floatBuffer2.get(n2 + 3 + 0));
            floatBuffer.put(n3 + 4, f * floatBuffer2.get(n2 + 0 + 4) + f2 * floatBuffer2.get(n2 + 1 + 4) + f3 * floatBuffer2.get(n2 + 2 + 4) + f4 * floatBuffer2.get(n2 + 3 + 4));
            floatBuffer.put(n3 + 8, f * floatBuffer2.get(n2 + 0 + 8) + f2 * floatBuffer2.get(n2 + 1 + 8) + f3 * floatBuffer2.get(n2 + 2 + 8) + f4 * floatBuffer2.get(n2 + 3 + 8));
            floatBuffer.put(n3 + 12, f * floatBuffer2.get(n2 + 0 + 12) + f2 * floatBuffer2.get(n2 + 1 + 12) + f3 * floatBuffer2.get(n2 + 2 + 12) + f4 * floatBuffer2.get(n2 + 3 + 12));
        }
    }

    public static float[] multMatrixVec(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray3[0 + n3] = fArray2[0 + n2] * fArray[0 + n] + fArray2[1 + n2] * fArray[4 + n] + fArray2[2 + n2] * fArray[8 + n] + fArray2[3 + n2] * fArray[12 + n];
        int n4 = 1 + n;
        fArray3[1 + n3] = fArray2[0 + n2] * fArray[0 + n4] + fArray2[1 + n2] * fArray[4 + n4] + fArray2[2 + n2] * fArray[8 + n4] + fArray2[3 + n2] * fArray[12 + n4];
        int n5 = 2 + n;
        fArray3[2 + n3] = fArray2[0 + n2] * fArray[0 + n5] + fArray2[1 + n2] * fArray[4 + n5] + fArray2[2 + n2] * fArray[8 + n5] + fArray2[3 + n2] * fArray[12 + n5];
        int n6 = 3 + n;
        fArray3[3 + n3] = fArray2[0 + n2] * fArray[0 + n6] + fArray2[1 + n2] * fArray[4 + n6] + fArray2[2 + n2] * fArray[8 + n6] + fArray2[3 + n2] * fArray[12 + n6];
        return fArray3;
    }

    public static float[] multMatrixVec(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray2[0] * fArray[0] + fArray2[1] * fArray[4] + fArray2[2] * fArray[8] + fArray2[3] * fArray[12];
        fArray3[1] = fArray2[0] * fArray[1] + fArray2[1] * fArray[5] + fArray2[2] * fArray[9] + fArray2[3] * fArray[13];
        fArray3[2] = fArray2[0] * fArray[2] + fArray2[1] * fArray[6] + fArray2[2] * fArray[10] + fArray2[3] * fArray[14];
        fArray3[3] = fArray2[0] * fArray[3] + fArray2[1] * fArray[7] + fArray2[2] * fArray[11] + fArray2[3] * fArray[15];
        return fArray3;
    }

    public static void multMatrixVec(FloatBuffer floatBuffer, float[] fArray, float[] fArray2) {
        int n = floatBuffer.position();
        for (int i = 0; i < 4; ++i) {
            int n2 = i + n;
            fArray2[i] = fArray[0] * floatBuffer.get(0 + n2) + fArray[1] * floatBuffer.get(4 + n2) + fArray[2] * floatBuffer.get(8 + n2) + fArray[3] * floatBuffer.get(12 + n2);
        }
    }

    public static float[] copyMatrixColumn(float[] fArray, int n, int n2, float[] fArray2, int n3) {
        fArray2[0 + n3] = fArray[0 + n2 * 4 + n];
        fArray2[1 + n3] = fArray[1 + n2 * 4 + n];
        fArray2[2 + n3] = fArray[2 + n2 * 4 + n];
        if (fArray2.length > 3 + n3) {
            fArray2[3 + n3] = fArray[3 + n2 * 4 + n];
        }
        return fArray2;
    }

    public static float[] copyMatrixRow(float[] fArray, int n, int n2, float[] fArray2, int n3) {
        fArray2[0 + n3] = fArray[n2 + 0 + n];
        fArray2[1 + n3] = fArray[n2 + 4 + n];
        fArray2[2 + n3] = fArray[n2 + 8 + n];
        if (fArray2.length > 3 + n3) {
            fArray2[3 + n3] = fArray[n2 + 12 + n];
        }
        return fArray2;
    }

    public static StringBuilder matrixRowToString(StringBuilder stringBuilder, String string2, FloatBuffer floatBuffer, int n, int n2, int n3, boolean bl, int n4) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        int n5 = n + floatBuffer.position();
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string2 + " ", Float.valueOf(floatBuffer.get(n5 + n4 * n3 + i))));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string2 + " ", Float.valueOf(floatBuffer.get(n5 + n4 + i * n2))));
            }
        }
        return stringBuilder;
    }

    public static StringBuilder matrixRowToString(StringBuilder stringBuilder, String string2, float[] fArray, int n, int n2, int n3, boolean bl, int n4) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string2 + " ", Float.valueOf(fArray[n + n4 * n3 + i])));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(String.format(string2 + " ", Float.valueOf(fArray[n + n4 + i * n2])));
            }
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, String string3, FloatBuffer floatBuffer, int n, int n2, int n3, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string4 = null == string2 ? "" : string2;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(string4).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string3, floatBuffer, n, n2, n3, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, String string3, float[] fArray, int n, int n2, int n3, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string4 = null == string2 ? "" : string2;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(string4).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string3, fArray, n, n2, n3, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, String string3, FloatBuffer floatBuffer, int n, FloatBuffer floatBuffer2, int n2, int n3, int n4, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string4 = null == string2 ? "" : string2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(string4).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string3, floatBuffer, n, n3, n4, bl, i);
            stringBuilder.append("=?= ");
            FloatUtil.matrixRowToString(stringBuilder, string3, floatBuffer2, n2, n3, n4, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string2, String string3, float[] fArray, int n, float[] fArray2, int n2, int n3, int n4, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string4 = null == string2 ? "" : string2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(string4).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string3, fArray, n, n3, n4, bl, i);
            stringBuilder.append("=?= ");
            FloatUtil.matrixRowToString(stringBuilder, string3, fArray2, n2, n3, n4, bl, i);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    private static void calculateMachineEpsilonFloat() {
        float f = 1.0f;
        int n = 0;
        do {
            ++n;
        } while (1.0f + (f /= 2.0f) / 2.0f != 1.0f);
        machEpsilon = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getMachineEpsilon() {
        if (machEpsilonAvail) return machEpsilon;
        Class<FloatUtil> clazz = FloatUtil.class;
        synchronized (FloatUtil.class) {
            if (machEpsilonAvail) return machEpsilon;
            machEpsilonAvail = true;
            FloatUtil.calculateMachineEpsilonFloat();
            // ** MonitorExit[var0] (shouldn't be in output)
            return machEpsilon;
        }
    }

    public static boolean isEqual(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean isEqual(float f, float f2, float f3) {
        if (Math.abs(f - f2) < f3) {
            return true;
        }
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static int compare(float f, float f2) {
        int n;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f);
        if (n2 == (n = Float.floatToIntBits(f2))) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f, float f2, float f3) {
        if (Math.abs(f - f2) < f3) {
            return 0;
        }
        return FloatUtil.compare(f, f2);
    }

    public static boolean isZero(float f, float f2) {
        return Math.abs(f) < f2;
    }

    public static float abs(float f) {
        return Math.abs(f);
    }

    public static float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static float sin(float f) {
        return (float)Math.sin(f);
    }

    public static float asin(float f) {
        return (float)Math.asin(f);
    }

    public static float cos(float f) {
        return (float)Math.cos(f);
    }

    public static float acos(float f) {
        return (float)Math.acos(f);
    }

    public static float tan(float f) {
        return (float)Math.tan(f);
    }

    public static float atan(float f) {
        return (float)Math.atan(f);
    }

    public static float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float getZBufferEpsilon(int n, float f, float f2) {
        return f * f / (f2 * (float)(1 << n) - f);
    }

    public static int getZBufferValue(int n, float f, float f2, float f3) {
        float f4 = f3 / (f3 - f2);
        float f5 = f3 * f2 / (f2 - f3);
        return (int)((float)(1 << n) * (f4 + f5 / f));
    }

    public static float getOrthoWinZ(float f, float f2, float f3) {
        return (1.0f / f2 - 1.0f / f) / (1.0f / f2 - 1.0f / f3);
    }
}

