/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.egl;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;

public class EGLGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    private final long[] nativeDisplayID = new long[1];
    private EGLDisplayLifecycleCallback eglLifecycleCallback;
    private VersionNumber eglVersion = VersionNumber.zeroVersion;

    public EGLGraphicsDevice() {
        super(NativeWindowFactory.TYPE_EGL, DefaultGraphicsDevice.getDefaultDisplayConnection(), 0);
        this.nativeDisplayID[0] = 0L;
        this.eglLifecycleCallback = null;
    }

    public EGLGraphicsDevice(AbstractGraphicsDevice abstractGraphicsDevice, long l, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        super(NativeWindowFactory.TYPE_EGL, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), l);
        long l2 = abstractGraphicsDevice instanceof EGLGraphicsDevice ? ((EGLGraphicsDevice)abstractGraphicsDevice).getNativeDisplayID() : abstractGraphicsDevice.getHandle();
        this.nativeDisplayID[0] = l2;
        this.eglLifecycleCallback = eGLDisplayLifecycleCallback;
    }

    public EGLGraphicsDevice(long l, long l2, String string2, int n, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        super(NativeWindowFactory.TYPE_EGL, string2, n, l2);
        this.nativeDisplayID[0] = l;
        this.eglLifecycleCallback = eGLDisplayLifecycleCallback;
    }

    public VersionNumber getEGLVersion() {
        return this.eglVersion;
    }

    public long getNativeDisplayID() {
        return this.nativeDisplayID[0];
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (null != this.eglLifecycleCallback && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.open(): " + this);
            }
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            this.handle = this.eglLifecycleCallback.eglGetAndInitDisplay(this.nativeDisplayID, nArray, nArray2);
            if (0L == this.handle) {
                this.eglVersion = VersionNumber.zeroVersion;
                throw new NativeWindowException("EGLGraphicsDevice.open() failed: " + this);
            }
            this.eglVersion = new VersionNumber(nArray[0], nArray2[0], 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (null != this.eglLifecycleCallback && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.close(): " + this);
            }
            this.eglLifecycleCallback.eglTerminate(this.handle);
        }
        return super.close();
    }

    @Override
    public boolean isHandleOwner() {
        return null != this.eglLifecycleCallback;
    }

    @Override
    public void clearHandleOwner() {
        this.eglLifecycleCallback = null;
    }

    @Override
    protected Object getHandleOwnership() {
        return this.eglLifecycleCallback;
    }

    @Override
    protected Object setHandleOwnership(Object object) {
        EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback = this.eglLifecycleCallback;
        this.eglLifecycleCallback = (EGLDisplayLifecycleCallback)object;
        return eGLDisplayLifecycleCallback;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[type " + this.getType() + ", v" + this.eglVersion + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", owner " + this.isHandleOwner() + ", " + this.toolkitLock + "]";
    }

    public static interface EGLDisplayLifecycleCallback {
        public long eglGetAndInitDisplay(long[] var1, int[] var2, int[] var3);

        public void eglTerminate(long var1);
    }
}

