/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import java.util.ArrayList;
import java.util.HashMap;
import jogamp.graph.geom.plane.AffineTransform;

public class TextRegionUtil {
    public final int renderModes;
    public static final int DEFAULT_CACHE_LIMIT = 256;
    public final AffineTransform tempT1 = new AffineTransform();
    public final AffineTransform tempT2 = new AffineTransform();
    private final HashMap<String, GLRegion> stringCacheMap = new HashMap(256);
    private final ArrayList<String> stringCacheArray = new ArrayList(256);
    private int stringCacheLimit = 256;

    public TextRegionUtil(int n) {
        this.renderModes = n;
    }

    public static int getCharCount(String string2, char c) {
        int n = string2.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string2.charAt(i) != c) continue;
            ++n2;
        }
        return n2;
    }

    public static void processString(ShapeVisitor shapeVisitor, AffineTransform affineTransform, Font font, float f, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        int n = charSequence.length();
        Font.Metrics metrics = font.getMetrics();
        float f2 = font.getLineHeight(f);
        float f3 = metrics.getScale(f);
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                f4 -= f2;
                f5 = 0.0f;
                continue;
            }
            if (c == ' ') {
                f5 += font.getAdvanceWidth(3, f);
                continue;
            }
            if (Region.DEBUG_INSTANCE) {
                System.err.println("XXXXXXXXXXXXXXx char: " + c + ", scale: " + f3 + "; translate: " + f5 + ", " + f4);
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            affineTransform2.translate(f5, f4, affineTransform3);
            affineTransform2.scale(f3, f3, affineTransform3);
            Font.Glyph glyph = font.getGlyph(c);
            OutlineShape outlineShape = glyph.getShape();
            if (null == outlineShape) continue;
            shapeVisitor.visit(outlineShape, affineTransform2);
            f5 += glyph.getAdvance(f, true);
        }
    }

    public static void addStringToRegion(final GLRegion gLRegion, Vertex.Factory<? extends Vertex> factory, Font font, float f, CharSequence charSequence, final float[] fArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(){

            @Override
            public final void visit(OutlineShape outlineShape, AffineTransform affineTransform) {
                gLRegion.addOutlineShape(outlineShape, affineTransform, gLRegion.hasColorChannel() ? fArray : null);
            }
        };
        TextRegionUtil.processString(shapeVisitor, null, font, f, charSequence, affineTransform, affineTransform2);
    }

    public void drawString3D(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Font font, float f, CharSequence charSequence, float[] fArray, int[] nArray) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = this.getCachedRegion(font, charSequence, f, 0);
        if (null == gLRegion) {
            gLRegion = GLRegion.create(this.renderModes, null);
            TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f, charSequence, fArray, this.tempT1, this.tempT2);
            this.addCachedRegion(gL2ES2, font, charSequence, f, 0, gLRegion);
        }
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
    }

    public static void drawString3D(GL2ES2 gL2ES2, int n, RegionRenderer regionRenderer, Font font, float f, CharSequence charSequence, float[] fArray, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = GLRegion.create(n, null);
        TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f, charSequence, fArray, affineTransform, affineTransform2);
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
        gLRegion.destroy(gL2ES2);
    }

    public static void drawString3D(GL2ES2 gL2ES2, GLRegion gLRegion, RegionRenderer regionRenderer, Font font, float f, CharSequence charSequence, float[] fArray, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        gLRegion.clear(gL2ES2);
        TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f, charSequence, fArray, affineTransform, affineTransform2);
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
    }

    public void clear(GL2ES2 gL2ES2) {
        for (GLRegion gLRegion : this.stringCacheMap.values()) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheMap.clear();
        this.stringCacheArray.clear();
    }

    public final void setCacheLimit(int n) {
        this.stringCacheLimit = n;
    }

    public final void setCacheLimit(GL2ES2 gL2ES2, int n) {
        this.stringCacheLimit = n;
        this.validateCache(gL2ES2, 0);
    }

    public final int getCacheLimit() {
        return this.stringCacheLimit;
    }

    public final int getCacheSize() {
        return this.stringCacheArray.size();
    }

    protected final void validateCache(GL2ES2 gL2ES2, int n) {
        if (this.getCacheLimit() > 0) {
            while (this.getCacheSize() + n > this.getCacheLimit()) {
                this.removeCachedRegion(gL2ES2, 0);
            }
        }
    }

    protected final GLRegion getCachedRegion(Font font, CharSequence charSequence, float f, int n) {
        return this.stringCacheMap.get(this.getKey(font, charSequence, f, n));
    }

    protected final void addCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence, float f, int n, GLRegion gLRegion) {
        String string2;
        GLRegion gLRegion2;
        if (0 != this.getCacheLimit() && null == (gLRegion2 = this.stringCacheMap.put(string2 = this.getKey(font, charSequence, f, n), gLRegion))) {
            this.validateCache(gL2ES2, 1);
            this.stringCacheArray.add(this.stringCacheArray.size(), string2);
        }
    }

    protected final void removeCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence, int n, int n2) {
        String string2 = this.getKey(font, charSequence, n, n2);
        GLRegion gLRegion = this.stringCacheMap.remove(string2);
        if (null != gLRegion) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheArray.remove(string2);
    }

    protected final void removeCachedRegion(GL2ES2 gL2ES2, int n) {
        GLRegion gLRegion;
        String string2 = this.stringCacheArray.remove(n);
        if (null != string2 && null != (gLRegion = this.stringCacheMap.remove(string2))) {
            gLRegion.destroy(gL2ES2);
        }
    }

    protected final String getKey(Font font, CharSequence charSequence, float f, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        return font.getName(stringBuilder, 3).append(".").append(charSequence.hashCode()).append(".").append(Float.floatToIntBits(f)).append(n).toString();
    }

    public static interface ShapeVisitor {
        public void visit(OutlineShape var1, AffineTransform var2);
    }
}

