/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.math.geom.Frustum;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.opengl.Debug;

public abstract class Region {
    public static final boolean DEBUG = Debug.debug("graph.curve");
    public static final boolean DEBUG_INSTANCE = Debug.debug("graph.curve.Instance");
    public static final int MSAA_RENDERING_BIT = 1;
    public static final int VBAA_RENDERING_BIT = 2;
    public static final int VARWEIGHT_RENDERING_BIT = 256;
    public static final int COLORCHANNEL_RENDERING_BIT = 512;
    public static final int COLORTEXTURE_RENDERING_BIT = 1024;
    public static final int MAX_QUALITY = 1;
    public static final int DEFAULT_TWO_PASS_TEXTURE_UNIT = 0;
    protected static final int DIRTY_SHAPE = 1;
    protected static final int DIRTY_STATE = 2;
    private final int renderModes;
    private int quality;
    private int dirty = 3;
    private int numVertices = 0;
    protected final AABBox box = new AABBox();
    protected Frustum frustum = null;
    final float[] coordsEx = new float[3];
    private final AABBox tmpBox = new AABBox();

    public static boolean isVBAA(int n) {
        return 0 != (n & 2);
    }

    public static boolean isMSAA(int n) {
        return 0 != (n & 1);
    }

    public static boolean isTwoPass(int n) {
        return 0 != (n & 3);
    }

    public static boolean hasVariableWeight(int n) {
        return 0 != (n & 0x100);
    }

    public static boolean hasColorChannel(int n) {
        return 0 != (n & 0x200);
    }

    public static boolean hasColorTexture(int n) {
        return 0 != (n & 0x400);
    }

    public static String getRenderModeString(int n) {
        String string2;
        String string3 = Region.hasVariableWeight(n) ? "-curve" : "";
        String string4 = Region.hasColorChannel(n) ? "-cols" : "";
        String string5 = string2 = Region.hasColorTexture(n) ? "-ctex" : "";
        if (Region.isVBAA(n)) {
            return "vbaa" + string3 + string4 + string2;
        }
        if (Region.isMSAA(n)) {
            return "msaa" + string3 + string4 + string2;
        }
        return "norm" + string3 + string4 + string2;
    }

    protected Region(int n) {
        this.renderModes = n;
        this.quality = 1;
    }

    protected abstract void pushVertex(float[] var1, float[] var2, float[] var3);

    protected abstract void pushIndex(int var1);

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final int getQuality() {
        return this.quality;
    }

    public final void setQuality(int n) {
        this.quality = n;
    }

    protected void clearImpl() {
        this.dirty = 3;
        this.numVertices = 0;
        this.box.reset();
    }

    public final boolean isVBAA() {
        return Region.isVBAA(this.renderModes);
    }

    public final boolean isMSAA() {
        return Region.isMSAA(this.renderModes);
    }

    public final boolean hasVariableWeight() {
        return Region.hasVariableWeight(this.renderModes);
    }

    public boolean hasColorChannel() {
        return Region.hasColorChannel(this.renderModes);
    }

    public boolean hasColorTexture() {
        return Region.hasColorTexture(this.renderModes);
    }

    public final Frustum getFrustum() {
        return this.frustum;
    }

    public final void setFrustum(Frustum frustum) {
        this.frustum = frustum;
    }

    private void pushNewVertexImpl(Vertex vertex, AffineTransform affineTransform, float[] fArray) {
        if (null != affineTransform) {
            float[] fArray2 = vertex.getCoord();
            affineTransform.transform(fArray2, this.coordsEx);
            this.coordsEx[2] = fArray2[2];
            this.box.resize(this.coordsEx[0], this.coordsEx[1], this.coordsEx[2]);
            this.pushVertex(this.coordsEx, vertex.getTexCoord(), fArray);
        } else {
            this.box.resize(vertex.getX(), vertex.getY(), vertex.getZ());
            this.pushVertex(vertex.getCoord(), vertex.getTexCoord(), fArray);
        }
        ++this.numVertices;
    }

    private void pushNewVertexIdxImpl(Vertex vertex, AffineTransform affineTransform, float[] fArray) {
        this.pushIndex(this.numVertices);
        this.pushNewVertexImpl(vertex, affineTransform, fArray);
    }

    public final void addOutlineShape(OutlineShape outlineShape, AffineTransform affineTransform, float[] fArray) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        if (null != this.frustum) {
            object2 = outlineShape.getBounds();
            if (null != affineTransform) {
                affineTransform.transform((AABBox)object2, this.tmpBox);
                object = this.tmpBox;
            } else {
                object = object2;
            }
            if (this.frustum.isAABBoxOutside((AABBox)object)) {
                if (DEBUG_INSTANCE) {
                    System.err.println("Region.addOutlineShape(): Dropping outside shapeBoxT: " + object);
                }
                return;
            }
        }
        object2 = outlineShape.getTriangles(OutlineShape.VerticesState.QUADRATIC_NURBS);
        object = outlineShape.getVertices();
        if (DEBUG_INSTANCE) {
            n3 = outlineShape.getAddedVerticeCount();
            n2 = ((ArrayList)object).size() + n3;
            n = object2.size() * 3;
            System.err.println("Region.addOutlineShape().0: tris: " + object2.size() + ", verts " + ((ArrayList)object).size() + ", transform " + affineTransform);
            System.err.println("Region.addOutlineShape().0: VerticeCount " + ((ArrayList)object).size() + " + " + n3 + " = " + n2);
            System.err.println("Region.addOutlineShape().0: IndexCount " + n);
        }
        n3 = this.numVertices;
        n2 = 0;
        n = 0;
        int n4 = 0;
        int n5 = 0;
        if (((ArrayList)object).size() >= 3) {
            int n6;
            if (DEBUG_INSTANCE) {
                System.err.println("Region.addOutlineShape(): Processing Vertices");
            }
            for (n6 = 0; n6 < ((ArrayList)object).size(); ++n6) {
                this.pushNewVertexImpl((Vertex)((ArrayList)object).get(n6), affineTransform, fArray);
                ++n2;
            }
            if (DEBUG_INSTANCE) {
                System.err.println("Region.addOutlineShape(): Processing Triangles");
            }
            for (n6 = 0; n6 < object2.size(); ++n6) {
                Vertex[] vertexArray;
                int n7;
                Triangle triangle = (Triangle)object2.get(n6);
                if (DEBUG_INSTANCE) {
                    System.err.println("T[" + n6 + "]: " + triangle);
                }
                if (Integer.MAX_VALUE - n3 > (n7 = (vertexArray = triangle.getVertices())[0].getId())) {
                    if (DEBUG_INSTANCE) {
                        System.err.println("T[" + n6 + "]: Moved " + n7 + " + " + n3 + " -> " + (n7 + n3));
                    }
                    this.pushIndex(n7 + n3);
                    this.pushIndex(vertexArray[1].getId() + n3);
                    this.pushIndex(vertexArray[2].getId() + n3);
                    n += 3;
                } else {
                    if (DEBUG_INSTANCE) {
                        System.err.println("T[" + n6 + "]: New Idx " + this.numVertices);
                    }
                    this.pushNewVertexIdxImpl(vertexArray[0], affineTransform, fArray);
                    this.pushNewVertexIdxImpl(vertexArray[1], affineTransform, fArray);
                    this.pushNewVertexIdxImpl(vertexArray[2], affineTransform, fArray);
                    n4 += 3;
                }
                ++n5;
            }
        }
        if (DEBUG_INSTANCE) {
            System.err.println("Region.addOutlineShape().X: idxOffset " + n3 + ", tris: " + n5 + ", verts [idx " + n4 + ", add " + n4 + " = " + (n2 + n4) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx[v-new " + n2 + ", t-new " + n4 + " = " + (n2 + n4) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx t-moved " + n + ", numVertices " + this.numVertices);
            System.err.println("Region.addOutlineShape().X: verts: v-dups 0, t-dups 0, t-known 0");
            System.err.println("Region.addOutlineShape().X: box " + this.box);
        }
        this.markShapeDirty();
    }

    public final void addOutlineShapes(List<OutlineShape> list, AffineTransform affineTransform, float[] fArray) {
        for (int i = 0; i < list.size(); ++i) {
            this.addOutlineShape(list.get(i), affineTransform, fArray);
        }
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final void markShapeDirty() {
        this.dirty |= 1;
    }

    public final boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    public final void markStateDirty() {
        this.dirty |= 2;
    }

    public final boolean isStateDirty() {
        return 0 != (this.dirty & 2);
    }

    protected final void clearDirtyBits(int n) {
        this.dirty &= ~n;
    }

    protected final int getDirtyBits() {
        return this.dirty;
    }

    public String toString() {
        return "Region[" + Region.getRenderModeString(this.renderModes) + ", q " + this.quality + ", dirty " + this.dirty + ", vertices " + this.numVertices + ", box " + this.box + "]";
    }
}

