/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<Object> {
    public static final VersionNumber zeroVersion = new VersionNumber(0, 0, 0, -1, 0);
    private static volatile Pattern defPattern = null;
    protected final int major;
    protected final int minor;
    protected final int sub;
    protected final int strEnd;
    protected final short state;
    protected static final short HAS_MAJOR = 1;
    protected static final short HAS_MINOR = 2;
    protected static final short HAS_SUB = 4;

    public static Pattern getVersionNumberPattern(String string2) {
        return Pattern.compile("\\D*(\\d+)[^\\" + string2 + "\\s]*(?:\\" + string2 + "\\D*(\\d+)[^\\" + string2 + "\\s]*(?:\\" + string2 + "\\D*(\\d+))?)?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern getDefaultVersionNumberPattern() {
        if (null != defPattern) return defPattern;
        Class<VersionNumber> clazz = VersionNumber.class;
        synchronized (VersionNumber.class) {
            if (null != defPattern) return defPattern;
            defPattern = VersionNumber.getVersionNumberPattern(".");
            // ** MonitorExit[var0] (shouldn't be in output)
            return defPattern;
        }
    }

    protected VersionNumber(int n, int n2, int n3, int n4, short s) {
        this.major = n;
        this.minor = n2;
        this.sub = n3;
        this.strEnd = n4;
        this.state = s;
    }

    public VersionNumber(int n, int n2, int n3) {
        this(n, n2, n3, -1, 7);
    }

    public VersionNumber(String string2) {
        this(string2, VersionNumber.getDefaultVersionNumberPattern());
    }

    public VersionNumber(String string2, String string3) {
        this(string2, VersionNumber.getVersionNumberPattern(string3));
    }

    public VersionNumber(String string2, Pattern pattern) {
        int[] nArray = new int[3];
        int n = 0;
        short s = 0;
        try {
            Matcher matcher = pattern.matcher(string2);
            if (matcher.lookingAt()) {
                n = matcher.end();
                int n2 = matcher.groupCount();
                if (1 <= n2) {
                    nArray[0] = Integer.parseInt(matcher.group(1));
                    s = 1;
                    if (2 <= n2) {
                        nArray[1] = Integer.parseInt(matcher.group(2));
                        s = (short)(s | 2);
                        if (3 <= n2) {
                            nArray[2] = Integer.parseInt(matcher.group(3));
                            s = (short)(s | 4);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.major = nArray[0];
        this.minor = nArray[1];
        this.sub = nArray[2];
        this.strEnd = n;
        this.state = s;
    }

    public final boolean isZero() {
        return this.major == 0 && this.minor == 0 && this.sub == 0;
    }

    public final boolean hasMajor() {
        return 0 != (1 & this.state);
    }

    public final boolean hasMinor() {
        return 0 != (2 & this.state);
    }

    public final boolean hasSub() {
        return 0 != (4 & this.state);
    }

    public final int endOfStringMatch() {
        return this.strEnd;
    }

    public final int hashCode() {
        int n = 31 + this.major;
        n = (n << 5) - n + this.minor;
        return (n << 5) - n + this.sub;
    }

    public final boolean equals(Object object) {
        if (object instanceof VersionNumber) {
            return 0 == this.compareTo((VersionNumber)object);
        }
        return false;
    }

    @Override
    public final int compareTo(Object object) {
        if (!(object instanceof VersionNumber)) {
            Class<?> clazz = null != object ? object.getClass() : null;
            throw new ClassCastException("Not a VersionNumber object: " + clazz);
        }
        return this.compareTo((VersionNumber)object);
    }

    @Override
    public final int compareTo(VersionNumber versionNumber) {
        if (this.major > versionNumber.major) {
            return 1;
        }
        if (this.major < versionNumber.major) {
            return -1;
        }
        if (this.minor > versionNumber.minor) {
            return 1;
        }
        if (this.minor < versionNumber.minor) {
            return -1;
        }
        if (this.sub > versionNumber.sub) {
            return 1;
        }
        if (this.sub < versionNumber.sub) {
            return -1;
        }
        return 0;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getSub() {
        return this.sub;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.sub;
    }
}

