### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
from minknow_api.manager_pb2_grpc import *
import minknow_api.manager_pb2 as manager_pb2
from minknow_api.manager_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "ManagerService",
    "DescribeHostRequest",
    "DescribeHostResponse",
    "FlowCellPosition",
    "FlowCellPositionsRequest",
    "FlowCellPositionsResponse",
    "WatchFlowCellPositionsRequest",
    "WatchFlowCellPositionsResponse",
    "ResetPositionRequest",
    "ResetPositionResponse",
    "BasecallerApiRequest",
    "BasecallerApiResponse",
    "GetGuppyInfoRequest",
    "GetGuppyInfoResponse",
    "GetVersionInfoRequest",
    "GetVersionInfoResponse",
    "ListProtocolOutputDirFilesRequest",
    "ListProtocolOutputDirFilesResponse",
    "CreateDirectoryRequest",
    "CreateDirectoryResponse",
    "FilesystemDiskSpaceInfo",
    "GetDiskSpaceInfoRequest",
    "StreamDiskSpaceInfoRequest",
    "GetDiskSpaceInfoResponse",
    "GetBarcodeKitInfoRequest",
    "GetBarcodeKitInfoResponse",
    "GetLampKitInfoRequest",
    "GetLampKitInfoResponse",
    "GetBarcodeKeysRequest",
    "GetBarcodeKeysResponse",
    "GetFlowCellTypesRequest",
    "GetFlowCellTypesResponse",
    "GetSequencingKitsRequest",
    "GetSequencingKitsResponse",
    "AddSimulatedDeviceRequest",
    "AddSimulatedDeviceResponse",
    "RemoveSimulatedDeviceRequest",
    "RemoveSimulatedDeviceResponse",
    "LocalAuthenticationTokenPathRequest",
    "LocalAuthenticationTokenPathResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class ManagerService(object):
    def __init__(self, channel):
        self._stub = ManagerServiceStub(channel)
        self._pb = manager_pb2
    def describe_host(self, _message=None, _timeout=None, **kwargs):
        """Get information about the machine running MinKNOW.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.DescribeHostRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.DescribeHostResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.describe_host,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = DescribeHostRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to describe_host: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.describe_host,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def flow_cell_positions(self, _message=None, _timeout=None, **kwargs):
        """List all known positions where flow cells can be inserted.

        Provides a snapshot of places where users can insert flow cells. It has a streamed response
        in case there are too many positions to fit into a single response, but normally there should
        only be a single response.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.FlowCellPositionsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.manager_pb2.FlowCellPositionsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.flow_cell_positions,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = FlowCellPositionsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to flow_cell_positions: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.flow_cell_positions,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def watch_flow_cell_positions(self, _message=None, _timeout=None, **kwargs):
        """Watch for changes in flow cell position availability and state.

        This is like flow_cell_positions, but updates are streamed as positions come and go (eg:
        MinIONs being plugged or unplugged), or their status otherwise changes.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.WatchFlowCellPositionsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.manager_pb2.WatchFlowCellPositionsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.watch_flow_cell_positions,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = WatchFlowCellPositionsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to watch_flow_cell_positions: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.watch_flow_cell_positions,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def reset_position(self, _message=None, _timeout=None, **kwargs):
        """Reset a flow cell position.

        If the hardware is in an error state or has been removed and the software is running, it will
        stop the software (causing the position to be forgotten if the hardware was removed).

        If the hardware is not in an error state

        

        Args:
            _message (minknow_api.manager_pb2.ResetPositionRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            positions (str, optional): The names of positions to restart.
            force (bool, optional): Force the software to be restarted even when it appears to be in a healthy state (ie:
                STATE_RUNNING).

        Returns:
            minknow_api.manager_pb2.ResetPositionResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.reset_position,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ResetPositionRequest()

        if "positions" in kwargs:
            unused_args.remove("positions")
            _message.positions.extend(kwargs['positions'])

        if "force" in kwargs:
            unused_args.remove("force")
            _message.force = kwargs['force']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to reset_position: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.reset_position,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def basecaller_api(self, _message=None, _timeout=None, **kwargs):
        """Get the connection information for the basecaller API.

        This is the service that implements the minknow_api.basecaller interface for basecalling
        reads files.

        Since 3.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.BasecallerApiRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.BasecallerApiResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.basecaller_api,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = BasecallerApiRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to basecaller_api: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.basecaller_api,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_guppy_info(self, _message=None, _timeout=None, **kwargs):
        """Get information about Guppy, including the port to connect to it on.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetGuppyInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetGuppyInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_guppy_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetGuppyInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_guppy_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_guppy_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_version_info(self, _message=None, _timeout=None, **kwargs):
        """Current version information includes:
        - Minknow version
        - Protocols version (i.e. Bream-4 version)
        - Configuration version (i.e. Wanda version)
        - Distribution version
        - Guppy version

        See also: instance.get_version_info which provides some similar information on a per instance basis.
        Since 3.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetVersionInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetVersionInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_version_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetVersionInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_version_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_version_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def list_protocol_output_dir_files(self, _message=None, _timeout=None, **kwargs):
        """Returns all the files that are within the protocol output dir specified in the user_conf - or a descendant of that directory
        if `path` is supplied in the request.

        INVALID_ARGUMENT will be returned if the `path` argument in the request is not a descendant of the protocol output directory

        NOT_FOUND will be returned if the path does not exist. 'The path' being either the protocol output directory if the `path` argument is not specified
        or a valid `path` argument is specified but does not exist.

        Since 3.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.ListProtocolOutputDirFilesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            path (str, optional): Specify the root path to list files from. If the path is left empty, then the base protocol output directory
                will be used.

                Note that the path specified HAS to be a descendant of the protocol output directory, otherwise a INVALID_ARGUMENT
                error will be returned

                If the path is left empty, and the path specified in the user config doesn't exist, then the NOT_FOUND error code
                will be returned

        Returns:
            iter of minknow_api.manager_pb2.ListProtocolOutputDirFilesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocol_output_dir_files,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ListProtocolOutputDirFilesRequest()

        if "path" in kwargs:
            unused_args.remove("path")
            _message.path = kwargs['path']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocol_output_dir_files: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocol_output_dir_files,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def create_directory(self, _message=None, _timeout=None, **kwargs):
        """Create a directory within the protocol output directory tree.

        Errors:
            INVALID_ARGUMENT will be returned if the parent path (where the directory is requested to
                be created) is not within the protocol output directory, or if invalid characters are
                in the requested directory name.

            FAILED_PRECONDITION will be returned if the parent path is not a directory.

            NOT_FOUND will be returned if the parent path does not exist.

            ALREADY_EXISTS will be returned if the directory exists and is not a directory (if the
                directory already exists, this is treated as success).

        The possible valid parent paths can be determined using list_protocol_output_dir_files().

        Since 3.6

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.CreateDirectoryRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            parent_path (str, optional): The path at which to create the directory.

                This must exist, be a directory, and be within the protocol output directory. This can be
                determined via calls to list_protocol_output_dir_files().
            name (str, optional): The name of the directory to create.

                This must be a single path component (ie: it cannot contain '/' or '\'). There may be other
                restrictions on valid characters, depending on the operating system.

        Returns:
            minknow_api.manager_pb2.CreateDirectoryResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.create_directory,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = CreateDirectoryRequest()

        if "parent_path" in kwargs:
            unused_args.remove("parent_path")
            _message.parent_path = kwargs['parent_path']

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to create_directory: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.create_directory,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Returns information about the amount of disk space available, how much
        space is needed to stop an experiment cleanly and if MinKNOW thinks
        that the free disk-space is approaching or past this limit

        Since 3.7

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetDiskSpaceInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_default_output_directories(self, _message=None, _timeout=None, **kwargs):
        """As with `instance.get_default_output_directories`, this will return the
        paths that are defined in the config used when an instance of minknow
        is started.

        Since 4.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetDefaultOutputDirectoriesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.OutputDirectories

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_default_output_directories,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetDefaultOutputDirectoriesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_default_output_directories: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_default_output_directories,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def stream_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Stream information about the amount of disk space available, how quickly
        it is being used, how much space is needed to stop an experiment cleanly
        and if MinKNOW thinks that the free disk-space is approaching or past
        this limit

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.StreamDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            period (int, optional): Disk space information will be streamed with this value determining the
                period in seconds between updates.
                A period of 0 is invalid

        Returns:
            iter of minknow_api.manager_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = StreamDiskSpaceInfoRequest()

        if "period" in kwargs:
            unused_args.remove("period")
            _message.period = kwargs['period']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_barcode_kit_info(self, _message=None, _timeout=None, **kwargs):
        """Get info about all available barcoding kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetBarcodeKitInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetBarcodeKitInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_barcode_kit_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetBarcodeKitInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_barcode_kit_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_barcode_kit_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_lamp_kit_info(self, _message=None, _timeout=None, **kwargs):
        """Get info about all available lamp kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetLampKitInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetLampKitInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_lamp_kit_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetLampKitInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_lamp_kit_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_lamp_kit_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_barcode_keys(self, _message=None, _timeout=None, **kwargs):
        """List all barcode keys associated with the specified barcoding kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetBarcodeKeysRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            barcode_kit_names (str, optional): Names of barcode kits to obtain barcode names for

                Fails with INVALID_ARGUMENT if any of the requested `barcode_kit_names` are unavailable
            lamp_kit_name (str, optional): Name of lamp kit to obtain barcode names for.

                Fails with INVALID_ARGUMENT if the requested `lamp_kit_name` is unavailable.

        Returns:
            minknow_api.manager_pb2.GetBarcodeKeysResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_barcode_keys,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetBarcodeKeysRequest()

        if "barcode_kit_names" in kwargs:
            unused_args.remove("barcode_kit_names")
            _message.barcode_kit_names.extend(kwargs['barcode_kit_names'])

        if "lamp_kit_name" in kwargs:
            unused_args.remove("lamp_kit_name")
            _message.lamp_kit_name = kwargs['lamp_kit_name']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_barcode_keys: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_barcode_keys,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_flow_cell_types(self, _message=None, _timeout=None, **kwargs):
        """List all known types of flow cell.

        The primary purpose of this RPC is to provide a list of flow cell types for a user to select
        from (although most flow cells are capable of telling MinKNOW their product code, making user
        selection unnecessary).

        A secondary benefit of this call is it allows extra information about flow cell types to be
        given.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.GetFlowCellTypesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetFlowCellTypesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.get_flow_cell_types is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_flow_cell_types,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetFlowCellTypesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_flow_cell_types: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_flow_cell_types,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_sequencing_kits(self, _message=None, _timeout=None, **kwargs):
        """List all known sequencing kits.

        The intention is to provide a list of sequencing kits for a user to select from, plus extra
        information that can be used to filter that list.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.GetSequencingKitsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            flow_cell_product_code (str, optional): The product code of the flow cell that will be used for sequencing.

                Only kits compatible with this flow cell type will be returned (currently, this means that
                there is at least one (sequencing or control) protocol that is compatible with both the kit
                and this flow cell product code).

                This may also affect the returned information about the kit. For example, if it isn't
                possible to basecall on the flow cell, none of the kits will claim to be barcoding capable
                (or compatible with any barcoding expansion kits).

        Returns:
            minknow_api.manager_pb2.GetSequencingKitsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.get_sequencing_kits is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_sequencing_kits,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetSequencingKitsRequest()

        if "flow_cell_product_code" in kwargs:
            unused_args.remove("flow_cell_product_code")
            _message.flow_cell_product_code = kwargs['flow_cell_product_code']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_sequencing_kits: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_sequencing_kits,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def add_simulated_device(self, _message=None, _timeout=None, **kwargs):
        """Creates a simulated device of the type your system is configured for

        Since 4.3

        

        Args:
            _message (minknow_api.manager_pb2.AddSimulatedDeviceRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            name (str): The name of the position, this must be unique and the correct format:

                For MinIONs and MinION-mk1Cs, "MS" followed by five digits, eg: "MS12345".
                For GridIONs, "GS" followed by five digits, eg: "GS12345".

                PromethIONs position-names have no format restriction, but must be unique

        Returns:
            minknow_api.manager_pb2.AddSimulatedDeviceResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.add_simulated_device,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = AddSimulatedDeviceRequest()

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']
        else:
            raise ArgumentError("add_simulated_device requires a 'name' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to add_simulated_device: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.add_simulated_device,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def remove_simulated_device(self, _message=None, _timeout=None, **kwargs):
        """Removes a simulated device

        Since 4.3

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.RemoveSimulatedDeviceRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            name (str): The name of the simulated device to be removed

        Returns:
            minknow_api.manager_pb2.RemoveSimulatedDeviceResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.remove_simulated_device,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = RemoveSimulatedDeviceRequest()

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']
        else:
            raise ArgumentError("remove_simulated_device requires a 'name' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to remove_simulated_device: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.remove_simulated_device,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def local_authentication_token_path(self, _message=None, _timeout=None, **kwargs):
        """Get the path for the local authentication token.

        This RPC is only useful when connecting to MinKNOW from the same computer that MinKNOW is
        running on (ie: connecting to "localhost"). If this file exists (which it should if MinKNOW's
        guest mode is not completely disabled), it contains a description of a token that can be used
        to connect to MinKNOW. This is most useful when MinKNOW's guest mode is set to "local_only",
        as it certifies that the client is connecting from the local machine. If the guest mode is
        set to "enabled", no token is required to connect.

        The contents of the file is a json object with two fields, "token" and "expires". "token" is
        the string that can be passed in a "local-auth" gRPC authentication metadata field, while
        "expires" gives the time the token will expire (in RFC3339 format). Note that a new token
        will be written out shortly before this time (and, in fact, the token will be accepted a
        short time after).


        An example token file is::

         {
           "token": "30fe5214-a7c5-4cb3-b521-b1ec8a49592a",
           "expires": "2020-12-18T14:26:12.021934+00:00"
         }

        To connect before 14:26:12.021934 on 2020-12-18, a client would set the metadata field
        "local-auth" to "30fe5214-a7c5-4cb3-b521-b1ec8a49592a". At around 14:26:12, the client should
        re-read the file and update the metadata field with the newly-read value.

        Since 4.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.LocalAuthenticationTokenPathRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.LocalAuthenticationTokenPathResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.local_authentication_token_path,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = LocalAuthenticationTokenPathRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to local_authentication_token_path: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.local_authentication_token_path,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
