# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dynamicadaptor']

package_data = \
{'': ['*']}

install_requires = \
['loguru>=0.6.0,<0.7.0', 'pydantic>=1.10.4,<2.0.0']

setup_kwargs = {
    'name': 'dynamicadaptor',
    'version': '0.3.0',
    'description': '',
    'long_description': '\n# DynamicAdaptor\n\n-------------\n\n用于将bilibili的grpc动态和web动态转换成特定的数据类型\n\n### 原理说明\n\n将grpc数据转换成json数据，之后使用pydantic进行信息摘要。\nweb端的json数据同理\n\n### 下载安装\n\n```bash\npip install dynamicadaptor\n```\n\n### 使用方法\n\n```python\n\nfrom google.protobuf.json_format import MessageToDict\nfrom dynamicadaptor.DynamicConversion import formate_message\nfrom bilirpc.api import get_dy_detail\nimport asyncio\nimport httpx\n\n\n# 如果数据是grpc返回的数据，则需要转换成json数据\nasync def sample1():\n    dynamic_grpc = await get_dy_detail("746530608345251842")\n    dynamic: dict = MessageToDict(dynamic_grpc[0])\n    dynamic_formate =await formate_message("grpc", dynamic)\n    print(dynamic_formate)\n\n\nasyncio.run(sample1())\n\n\n# 如果是web返回的数据\nasync def sample2():\n    url = "https://api.bilibili.com/x/polymer/web-dynamic/v1/detail?timezone_offset=-480&id=746530608345251842"\n    headers = {\n        "Referer": "https://t.bilibili.com/746530608345251842"\n    }\n    result = httpx.get(url, headers=headers).json()\n    dynamic_formate =await formate_message("web", result["data"]["item"])\n    print(dynamic_formate)\n\n\nasyncio.run(sample2())\n\n\n\n\n```\n\n## 数据结构\n\n```bash\nmessage\n├─message_type: str\n├─message_id:str\n├─header: Head\n|   ├─name: str\n|   ├─mid: int\n|   ├─face: Optional[str]  \n|   ├─pub_time: Optional[str]\n|   ├─pub_ts: Optional[int]\n|   ├─vip: Optional\n|   |   ├─status: Optional[int]\n|   |   ├─type: int\n|   |   └─vatar_subscript: Optional[int]\n|   |\n|   ├─pendant: Optional\n|   |   ├─pid: Optional[int]\n|   |   ├─image: Optional[str]\n|   |   └─pendant_name: Optional[str]\n|   └─official_verify: Optional\n|      └─type: int\n├─text: Optional\n|   ├─text: Optional\n|   ├─topic: Optional\n|   |   └─name: str\n|   └─rich_text_nodes:Optional[List[RichTextDetail]]\n|      ├─type: str\n|      ├─text: str\n|      ├─orig_text: Optional[str]\n|      └─emoji: Optional\n|          ├─icon_url: Optional[str]\n|          ├─text: Optional[str]\n|          └─type: Union[int, str, None]     \n|   \n├─major: Optional\n|   ├─type: str\n|   ├─draw: Optional\n|   |   └─items: List\n|   |       ├─height: int\n|   |       ├─width: int\n|   |       └─src: str\n|   ├─archive: Optional\n|   |   ├─cover: str\n|   |   ├─title: str\n|   |   ├─desc: Optional[str]\n|   |   ├─duration_text: str\n|   |   └─badge: Optional\n|   |       ├─text: Optional[str]\n|   |       ├─color: Optional[str]\n|   |       └─bg_color: Optional[str] \n|   ├─live_rcmd: Optional\n|   |   └─content: Json\n|   |       └─live_play_info\n|   |           ├─title: str\n|   |           ├─cover: str                  \n|   |           └─watched_show\n|   |               └─text_large:str\n|   ├─article: Optional\n|   |   ├─cover: List[str]\n|   |   ├─title: str\n|   |   ├─desc: str\n|   |   └─label: str\n|   ├─common: Optional\n|   |   ├─biz_type: int\n|   |   ├─cover: Optional[str]\n|   |   ├─desc: Optional[str]\n|   |   ├─title: Optional[str]  \n|   |   └─badge: Optional\n|   |       ├─text: Optional[str]\n|   |       ├─color: Optional[str]\n|   |       └─bg_color: Optional[str]\n|   ├─music: Optional\n|   |   ├─cover: str\n|   |   ├─label: str\n|   |   └─title: str\n|   ├─pgc: Optional\n|   |   ├─cover: str\n|   |   ├─title: str\n|   |   ├─badge\n|   |   |   ├─text: Optional[str]\n|   |   |   ├─color: Optional[str]\n|   |   |   └─bg_color: Optional[str]\n|   |   └─stat\n|   |       ├─danmaku: str\n|   |       └─play: str\n|   ├─medialist: Optional\n|   |   ├─cover: str\n|   |   ├─title: str\n|   |   ├─sub_title: str\n|   |   └─badge\n|   |       ├─text: Optional[str]\n|   |       ├─color: Optional[str]\n|   |       └─bg_color: Optional[str]\n|   ├─courses: Optional\n|   |   ├─cover: str\n|   |   ├─title: str\n|   |   ├─desc: str\n|   |   ├─sub_title: str\n|   |   └─badge\n|   |       ├─text: Optional[str]\n|   |       ├─color: Optional[str]\n|   |       └─bg_color: Optional[str]\n|   └─live\n|       ├─cover: str\n|       ├─title: str\n|       ├─desc_first: str\n|       ├─desc_second: str\n|       └─badge\n|           ├─text: Optional[str]\n|           ├─color: Optional[str]\n|           └─bg_color: Optional[str]\n├─additional: Optional\n|   ├─type: str\n|   ├─goods: Optional\n|   |   ├─head_text: str\n|   |   └─items: List\n|   |       ├─cover: str\n|   |       ├─price: str\n|   |       └─name: str\n|   ├─reserve: Optional\n|   |   ├─title: str\n|   |   ├─desc1\n|   |   |   └─text: str  \n|   |   └─desc2\n|   |       └─text: str\n|   ├─common\n|   |   ├─sub_type: str\n|   |   ├─head_text: Optional[str]\n|   |   ├─cover: str\n|   |   ├─desc1: str\n|   |   ├─desc2: Optional[str]\n|   |   └─title: str\n|   ├─ugc\n|   |   ├─cover: str\n|   |   ├─title: str\n|   |   ├─desc_second: str\n|   |   ├─duration: str\n|   |   └─head_text: Optional[str]\n|   └─vote\n|       ├─desc: str\n|       └─join_num: int\n└─forward: Optional\n    ├─message_type: str\n    ├─message_id:str\n    ├─header: Head\n    |   ├─name: str\n    |   ├─mid: int\n    |   ├─face: Optional[str]  \n    |   ├─pub_time: Optional[str]\n    |   ├─pub_ts: Optional[int]\n    |   ├─vip: Optional\n    |   |   ├─status: Optional[int]\n    |   |   ├─type: int\n    |   |   └─vatar_subscript: Optional[int]\n    |   |\n    |   ├─pendant: Optional\n    |   |   ├─pid: Optional[int]\n    |   |   ├─image: Optional[str]\n    |   |   └─pendant_name: Optional[str]\n    |   └─official_verify: Optional\n    |      └─type: int\n    ├─text: Optional\n    |   ├─text: Optional\n    |   ├─topic: Optional\n    |   |   └─name: str\n    |   └─rich_text_nodes:Optional[List[RichTextDetail]]\n    |      ├─type: str\n    |      ├─text: str\n    |      ├─orig_text: Optional[str]\n    |      └─emoji: Optional\n    |          ├─icon_url: Optional[str]\n    |          ├─text: Optional[str]\n    |          └─type: Union[int, str, None]     \n    |   \n    ├─major: Optional\n    |   ├─type: str\n    |   ├─draw: Optional\n    |   |   └─items: List\n    |   |       ├─height: int\n    |   |       ├─width: int\n    |   |       └─src: str\n    |   ├─archive: Optional\n    |   |   ├─cover: str\n    |   |   ├─title: str\n    |   |   ├─desc: Optional[str]\n    |   |   ├─duration_text: str\n    |   |   └─badge: Optional\n    |   |       ├─text: Optional[str]\n    |   |       ├─color: Optional[str]\n    |   |       └─bg_color: Optional[str] \n    |   ├─live_rcmd: Optional\n    |   |   └─content: Json\n    |   |       └─live_play_info\n    |   |           ├─title: str\n    |   |           ├─cover: str                  \n    |   |           └─watched_show\n    |   |               └─text_large:str\n    |   ├─article: Optional\n    |   |   ├─cover: List[str]\n    |   |   ├─title: str\n    |   |   ├─desc: str\n    |   |   └─label: str\n    |   ├─common: Optional\n    |   |   ├─biz_type: int\n    |   |   ├─cover: Optional[str]\n    |   |   ├─desc: Optional[str]\n    |   |   ├─title: Optional[str]  \n    |   |   └─badge: Optional\n    |   |       ├─text: Optional[str]\n    |   |       ├─color: Optional[str]\n    |   |       └─bg_color: Optional[str]\n    |   ├─music: Optional\n    |   |   ├─cover: str\n    |   |   ├─label: str\n    |   |   └─title: str\n    |   ├─pgc: Optional\n    |   |   ├─cover: str\n    |   |   ├─title: str\n    |   |   ├─badge\n    |   |   |   ├─text: Optional[str]\n    |   |   |   ├─color: Optional[str]\n    |   |   |   └─bg_color: Optional[str]\n    |   |   └─stat\n    |   |       ├─danmaku: str\n    |   |       └─play: str\n    |   ├─medialist: Optional\n    |   |   ├─cover: str\n    |   |   ├─title: str\n    |   |   ├─sub_title: str\n    |   |   └─badge\n    |   |       ├─text: Optional[str]\n    |   |       ├─color: Optional[str]\n    |   |       └─bg_color: Optional[str]\n    |   ├─courses: Optional\n    |   |   ├─cover: str\n    |   |   ├─title: str\n    |   |   ├─desc: str\n    |   |   ├─sub_title: str\n    |   |   └─badge\n    |   |       ├─text: Optional[str]\n    |   |       ├─color: Optional[str]\n    |   |       └─bg_color: Optional[str]\n    |   └─live\n    |       ├─cover: str\n    |       ├─title: str\n    |       ├─desc_first: str\n    |       ├─desc_second: str\n    |       └─badge\n    |           ├─text: Optional[str]\n    |           ├─color: Optional[str]\n    |           └─bg_color: Optional[str]\n    └─additional: Optional\n        ├─type: str\n        ├─goods: Optional\n        |   ├─head_text: str\n        |   └─items: List\n        |       ├─cover: str\n        |       ├─price: str\n        |       └─name: str\n        ├─reserve: Optional\n        |   ├─title: str\n        |   ├─desc1\n        |   |   └─text: str  \n        |   └─desc2\n        |       └─text: str\n        ├─common\n        |   ├─sub_type: str\n        |   ├─head_text: Optional[str]\n        |   ├─cover: str\n        |   ├─desc1: str\n        |   ├─desc2: Optional[str]\n        |   └─title: str\n        ├─ugc\n        |   ├─cover: str\n        |   ├─title: str\n        |   ├─desc_second: str\n        |   ├─duration: str\n        |   └─head_text: Optional[str]\n        └─vote\n            ├─desc: str\n            └─join_num: int\n```\n\n## License\n\nGPL\n',
    'author': 'DMC',
    'author_email': 'lzxder@outlook.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
