from multiprocessing import cpu_count

global_args = {
    "output_dir": "outputs/",
    "best_model_dir": "outputs/best_model",
    "cache_dir": "cache_dir/",
    "fp16": True,
    "fp16_opt_level": "O1",
    "max_seq_length": 128,
    "train_batch_size": 8,
    "gradient_accumulation_steps": 1,
    "eval_batch_size": 8,
    "num_train_epochs": 1,
    "weight_decay": 0,
    "learning_rate": 4e-5,
    "adam_epsilon": 1e-8,
    "warmup_ratio": 0.06,
    "warmup_steps": 0,
    "max_grad_norm": 1.0,
    "do_lower_case": False,
    "logging_steps": 50,
    "save_steps": 2000,
    "no_cache": False,
    "save_model_every_epoch": True,
    "evaluate_during_training": False,
    "evaluate_during_training_steps": 2000,
    "evaluate_during_training_verbose": False,
    "use_cached_eval_features": False,
    "save_eval_checkpoints": True,
    "tensorboard_dir": None,
    "overwrite_output_dir": False,
    "reprocess_input_data": True,
    "process_count": cpu_count() - 2 if cpu_count() > 2 else 1,
    "n_gpu": 1,
    "use_multiprocessing": True,
    "silent": False,
    "wandb_project": None,
    "wandb_kwargs": {},
    "use_early_stopping": False,
    "early_stopping_patience": 3,
    "early_stopping_delta": 0,
    "early_stopping_metric": "eval_loss",
    "early_stopping_metric_minimize": True,
    "early_stopping_consider_epochs": False,
    "manual_seed": None,
    "encoding": None,
    "config": {},
}
