# SPDX-FileCopyrightText: © 2024-2025 Jimmy Fitzpatrick <jcfitzpatrick12@gmail.com>
# This file is part of SPECTRE
# SPDX-License-Identifier: GPL-3.0-or-later

"""Create and transform spectrogram data."""

from ._analytical import get_analytical_spectrogram, validate_analytically, TestResults
from ._spectrogram import Spectrogram, FrequencyCut, TimeCut, SpectrumUnit, TimeType
from ._transform import (
    frequency_chop,
    time_chop,
    frequency_average,
    time_average,
    join_spectrograms,
)

__all__ = [
    "get_analytical_spectrogram",
    "validate_analytically",
    "TestResults",
    "Spectrogram",
    "FrequencyCut",
    "TimeCut",
    "SpectrumUnit",
    "frequency_chop",
    "time_chop",
    "frequency_average",
    "time_average",
    "join_spectrograms",
    "TimeType",
]
