# SPDX-FileCopyrightText: © 2024-2025 Jimmy Fitzpatrick <jcfitzpatrick12@gmail.com>
# This file is part of SPECTRE
# SPDX-License-Identifier: GPL-3.0-or-later

from enum import Enum


class BatchKey(Enum):
    """Key bound to a `Batch` plugin class.

    :ivar IQ_STREAM: Represents the default batch data generated  by `spectre`,
    containing IQ stream data and other data derived from it.
    :ivar CALLISTO: Represents FITS files generated by the e-Callisto network.
    """

    IQ_STREAM = "iq_stream"
    CALLISTO = "callisto"
