"""
Event constants from SDL's C API.

This module is auto-generated by `build_libtcod.py`.
"""
# --- SDL scancodes ---
SCANCODE_UNKNOWN = 0
SCANCODE_A = 4
SCANCODE_B = 5
SCANCODE_C = 6
SCANCODE_D = 7
SCANCODE_E = 8
SCANCODE_F = 9
SCANCODE_G = 10
SCANCODE_H = 11
SCANCODE_I = 12
SCANCODE_J = 13
SCANCODE_K = 14
SCANCODE_L = 15
SCANCODE_M = 16
SCANCODE_N = 17
SCANCODE_O = 18
SCANCODE_P = 19
SCANCODE_Q = 20
SCANCODE_R = 21
SCANCODE_S = 22
SCANCODE_T = 23
SCANCODE_U = 24
SCANCODE_V = 25
SCANCODE_W = 26
SCANCODE_X = 27
SCANCODE_Y = 28
SCANCODE_Z = 29
SCANCODE_1 = 30
SCANCODE_2 = 31
SCANCODE_3 = 32
SCANCODE_4 = 33
SCANCODE_5 = 34
SCANCODE_6 = 35
SCANCODE_7 = 36
SCANCODE_8 = 37
SCANCODE_9 = 38
SCANCODE_0 = 39
SCANCODE_RETURN = 40
SCANCODE_ESCAPE = 41
SCANCODE_BACKSPACE = 42
SCANCODE_TAB = 43
SCANCODE_SPACE = 44
SCANCODE_MINUS = 45
SCANCODE_EQUALS = 46
SCANCODE_LEFTBRACKET = 47
SCANCODE_RIGHTBRACKET = 48
SCANCODE_BACKSLASH = 49
SCANCODE_NONUSHASH = 50
SCANCODE_SEMICOLON = 51
SCANCODE_APOSTROPHE = 52
SCANCODE_GRAVE = 53
SCANCODE_COMMA = 54
SCANCODE_PERIOD = 55
SCANCODE_SLASH = 56
SCANCODE_CAPSLOCK = 57
SCANCODE_F1 = 58
SCANCODE_F2 = 59
SCANCODE_F3 = 60
SCANCODE_F4 = 61
SCANCODE_F5 = 62
SCANCODE_F6 = 63
SCANCODE_F7 = 64
SCANCODE_F8 = 65
SCANCODE_F9 = 66
SCANCODE_F10 = 67
SCANCODE_F11 = 68
SCANCODE_F12 = 69
SCANCODE_PRINTSCREEN = 70
SCANCODE_SCROLLLOCK = 71
SCANCODE_PAUSE = 72
SCANCODE_INSERT = 73
SCANCODE_HOME = 74
SCANCODE_PAGEUP = 75
SCANCODE_DELETE = 76
SCANCODE_END = 77
SCANCODE_PAGEDOWN = 78
SCANCODE_RIGHT = 79
SCANCODE_LEFT = 80
SCANCODE_DOWN = 81
SCANCODE_UP = 82
SCANCODE_NUMLOCKCLEAR = 83
SCANCODE_KP_DIVIDE = 84
SCANCODE_KP_MULTIPLY = 85
SCANCODE_KP_MINUS = 86
SCANCODE_KP_PLUS = 87
SCANCODE_KP_ENTER = 88
SCANCODE_KP_1 = 89
SCANCODE_KP_2 = 90
SCANCODE_KP_3 = 91
SCANCODE_KP_4 = 92
SCANCODE_KP_5 = 93
SCANCODE_KP_6 = 94
SCANCODE_KP_7 = 95
SCANCODE_KP_8 = 96
SCANCODE_KP_9 = 97
SCANCODE_KP_0 = 98
SCANCODE_KP_PERIOD = 99
SCANCODE_NONUSBACKSLASH = 100
SCANCODE_APPLICATION = 101
SCANCODE_POWER = 102
SCANCODE_KP_EQUALS = 103
SCANCODE_F13 = 104
SCANCODE_F14 = 105
SCANCODE_F15 = 106
SCANCODE_F16 = 107
SCANCODE_F17 = 108
SCANCODE_F18 = 109
SCANCODE_F19 = 110
SCANCODE_F20 = 111
SCANCODE_F21 = 112
SCANCODE_F22 = 113
SCANCODE_F23 = 114
SCANCODE_F24 = 115
SCANCODE_EXECUTE = 116
SCANCODE_HELP = 117
SCANCODE_MENU = 118
SCANCODE_SELECT = 119
SCANCODE_STOP = 120
SCANCODE_AGAIN = 121
SCANCODE_UNDO = 122
SCANCODE_CUT = 123
SCANCODE_COPY = 124
SCANCODE_PASTE = 125
SCANCODE_FIND = 126
SCANCODE_MUTE = 127
SCANCODE_VOLUMEUP = 128
SCANCODE_VOLUMEDOWN = 129
SCANCODE_KP_COMMA = 133
SCANCODE_KP_EQUALSAS400 = 134
SCANCODE_INTERNATIONAL1 = 135
SCANCODE_INTERNATIONAL2 = 136
SCANCODE_INTERNATIONAL3 = 137
SCANCODE_INTERNATIONAL4 = 138
SCANCODE_INTERNATIONAL5 = 139
SCANCODE_INTERNATIONAL6 = 140
SCANCODE_INTERNATIONAL7 = 141
SCANCODE_INTERNATIONAL8 = 142
SCANCODE_INTERNATIONAL9 = 143
SCANCODE_LANG1 = 144
SCANCODE_LANG2 = 145
SCANCODE_LANG3 = 146
SCANCODE_LANG4 = 147
SCANCODE_LANG5 = 148
SCANCODE_LANG6 = 149
SCANCODE_LANG7 = 150
SCANCODE_LANG8 = 151
SCANCODE_LANG9 = 152
SCANCODE_ALTERASE = 153
SCANCODE_SYSREQ = 154
SCANCODE_CANCEL = 155
SCANCODE_CLEAR = 156
SCANCODE_PRIOR = 157
SCANCODE_RETURN2 = 158
SCANCODE_SEPARATOR = 159
SCANCODE_OUT = 160
SCANCODE_OPER = 161
SCANCODE_CLEARAGAIN = 162
SCANCODE_CRSEL = 163
SCANCODE_EXSEL = 164
SCANCODE_KP_00 = 176
SCANCODE_KP_000 = 177
SCANCODE_THOUSANDSSEPARATOR = 178
SCANCODE_DECIMALSEPARATOR = 179
SCANCODE_CURRENCYUNIT = 180
SCANCODE_CURRENCYSUBUNIT = 181
SCANCODE_KP_LEFTPAREN = 182
SCANCODE_KP_RIGHTPAREN = 183
SCANCODE_KP_LEFTBRACE = 184
SCANCODE_KP_RIGHTBRACE = 185
SCANCODE_KP_TAB = 186
SCANCODE_KP_BACKSPACE = 187
SCANCODE_KP_A = 188
SCANCODE_KP_B = 189
SCANCODE_KP_C = 190
SCANCODE_KP_D = 191
SCANCODE_KP_E = 192
SCANCODE_KP_F = 193
SCANCODE_KP_XOR = 194
SCANCODE_KP_POWER = 195
SCANCODE_KP_PERCENT = 196
SCANCODE_KP_LESS = 197
SCANCODE_KP_GREATER = 198
SCANCODE_KP_AMPERSAND = 199
SCANCODE_KP_DBLAMPERSAND = 200
SCANCODE_KP_VERTICALBAR = 201
SCANCODE_KP_DBLVERTICALBAR = 202
SCANCODE_KP_COLON = 203
SCANCODE_KP_HASH = 204
SCANCODE_KP_SPACE = 205
SCANCODE_KP_AT = 206
SCANCODE_KP_EXCLAM = 207
SCANCODE_KP_MEMSTORE = 208
SCANCODE_KP_MEMRECALL = 209
SCANCODE_KP_MEMCLEAR = 210
SCANCODE_KP_MEMADD = 211
SCANCODE_KP_MEMSUBTRACT = 212
SCANCODE_KP_MEMMULTIPLY = 213
SCANCODE_KP_MEMDIVIDE = 214
SCANCODE_KP_PLUSMINUS = 215
SCANCODE_KP_CLEAR = 216
SCANCODE_KP_CLEARENTRY = 217
SCANCODE_KP_BINARY = 218
SCANCODE_KP_OCTAL = 219
SCANCODE_KP_DECIMAL = 220
SCANCODE_KP_HEXADECIMAL = 221
SCANCODE_LCTRL = 224
SCANCODE_LSHIFT = 225
SCANCODE_LALT = 226
SCANCODE_LGUI = 227
SCANCODE_RCTRL = 228
SCANCODE_RSHIFT = 229
SCANCODE_RALT = 230
SCANCODE_RGUI = 231
SCANCODE_MODE = 257
SCANCODE_AUDIONEXT = 258
SCANCODE_AUDIOPREV = 259
SCANCODE_AUDIOSTOP = 260
SCANCODE_AUDIOPLAY = 261
SCANCODE_AUDIOMUTE = 262
SCANCODE_MEDIASELECT = 263
SCANCODE_WWW = 264
SCANCODE_MAIL = 265
SCANCODE_CALCULATOR = 266
SCANCODE_COMPUTER = 267
SCANCODE_AC_SEARCH = 268
SCANCODE_AC_HOME = 269
SCANCODE_AC_BACK = 270
SCANCODE_AC_FORWARD = 271
SCANCODE_AC_STOP = 272
SCANCODE_AC_REFRESH = 273
SCANCODE_AC_BOOKMARKS = 274
SCANCODE_BRIGHTNESSDOWN = 275
SCANCODE_BRIGHTNESSUP = 276
SCANCODE_DISPLAYSWITCH = 277
SCANCODE_KBDILLUMTOGGLE = 278
SCANCODE_KBDILLUMDOWN = 279
SCANCODE_KBDILLUMUP = 280
SCANCODE_EJECT = 281
SCANCODE_SLEEP = 282
SCANCODE_APP1 = 283
SCANCODE_APP2 = 284
SCANCODE_AUDIOREWIND = 285
SCANCODE_AUDIOFASTFORWARD = 286
_REVERSE_SCANCODE_TABLE = {
    0: "tcod.event.SCANCODE_UNKNOWN",
    4: "tcod.event.SCANCODE_A",
    5: "tcod.event.SCANCODE_B",
    6: "tcod.event.SCANCODE_C",
    7: "tcod.event.SCANCODE_D",
    8: "tcod.event.SCANCODE_E",
    9: "tcod.event.SCANCODE_F",
    10: "tcod.event.SCANCODE_G",
    11: "tcod.event.SCANCODE_H",
    12: "tcod.event.SCANCODE_I",
    13: "tcod.event.SCANCODE_J",
    14: "tcod.event.SCANCODE_K",
    15: "tcod.event.SCANCODE_L",
    16: "tcod.event.SCANCODE_M",
    17: "tcod.event.SCANCODE_N",
    18: "tcod.event.SCANCODE_O",
    19: "tcod.event.SCANCODE_P",
    20: "tcod.event.SCANCODE_Q",
    21: "tcod.event.SCANCODE_R",
    22: "tcod.event.SCANCODE_S",
    23: "tcod.event.SCANCODE_T",
    24: "tcod.event.SCANCODE_U",
    25: "tcod.event.SCANCODE_V",
    26: "tcod.event.SCANCODE_W",
    27: "tcod.event.SCANCODE_X",
    28: "tcod.event.SCANCODE_Y",
    29: "tcod.event.SCANCODE_Z",
    30: "tcod.event.SCANCODE_1",
    31: "tcod.event.SCANCODE_2",
    32: "tcod.event.SCANCODE_3",
    33: "tcod.event.SCANCODE_4",
    34: "tcod.event.SCANCODE_5",
    35: "tcod.event.SCANCODE_6",
    36: "tcod.event.SCANCODE_7",
    37: "tcod.event.SCANCODE_8",
    38: "tcod.event.SCANCODE_9",
    39: "tcod.event.SCANCODE_0",
    40: "tcod.event.SCANCODE_RETURN",
    41: "tcod.event.SCANCODE_ESCAPE",
    42: "tcod.event.SCANCODE_BACKSPACE",
    43: "tcod.event.SCANCODE_TAB",
    44: "tcod.event.SCANCODE_SPACE",
    45: "tcod.event.SCANCODE_MINUS",
    46: "tcod.event.SCANCODE_EQUALS",
    47: "tcod.event.SCANCODE_LEFTBRACKET",
    48: "tcod.event.SCANCODE_RIGHTBRACKET",
    49: "tcod.event.SCANCODE_BACKSLASH",
    50: "tcod.event.SCANCODE_NONUSHASH",
    51: "tcod.event.SCANCODE_SEMICOLON",
    52: "tcod.event.SCANCODE_APOSTROPHE",
    53: "tcod.event.SCANCODE_GRAVE",
    54: "tcod.event.SCANCODE_COMMA",
    55: "tcod.event.SCANCODE_PERIOD",
    56: "tcod.event.SCANCODE_SLASH",
    57: "tcod.event.SCANCODE_CAPSLOCK",
    58: "tcod.event.SCANCODE_F1",
    59: "tcod.event.SCANCODE_F2",
    60: "tcod.event.SCANCODE_F3",
    61: "tcod.event.SCANCODE_F4",
    62: "tcod.event.SCANCODE_F5",
    63: "tcod.event.SCANCODE_F6",
    64: "tcod.event.SCANCODE_F7",
    65: "tcod.event.SCANCODE_F8",
    66: "tcod.event.SCANCODE_F9",
    67: "tcod.event.SCANCODE_F10",
    68: "tcod.event.SCANCODE_F11",
    69: "tcod.event.SCANCODE_F12",
    70: "tcod.event.SCANCODE_PRINTSCREEN",
    71: "tcod.event.SCANCODE_SCROLLLOCK",
    72: "tcod.event.SCANCODE_PAUSE",
    73: "tcod.event.SCANCODE_INSERT",
    74: "tcod.event.SCANCODE_HOME",
    75: "tcod.event.SCANCODE_PAGEUP",
    76: "tcod.event.SCANCODE_DELETE",
    77: "tcod.event.SCANCODE_END",
    78: "tcod.event.SCANCODE_PAGEDOWN",
    79: "tcod.event.SCANCODE_RIGHT",
    80: "tcod.event.SCANCODE_LEFT",
    81: "tcod.event.SCANCODE_DOWN",
    82: "tcod.event.SCANCODE_UP",
    83: "tcod.event.SCANCODE_NUMLOCKCLEAR",
    84: "tcod.event.SCANCODE_KP_DIVIDE",
    85: "tcod.event.SCANCODE_KP_MULTIPLY",
    86: "tcod.event.SCANCODE_KP_MINUS",
    87: "tcod.event.SCANCODE_KP_PLUS",
    88: "tcod.event.SCANCODE_KP_ENTER",
    89: "tcod.event.SCANCODE_KP_1",
    90: "tcod.event.SCANCODE_KP_2",
    91: "tcod.event.SCANCODE_KP_3",
    92: "tcod.event.SCANCODE_KP_4",
    93: "tcod.event.SCANCODE_KP_5",
    94: "tcod.event.SCANCODE_KP_6",
    95: "tcod.event.SCANCODE_KP_7",
    96: "tcod.event.SCANCODE_KP_8",
    97: "tcod.event.SCANCODE_KP_9",
    98: "tcod.event.SCANCODE_KP_0",
    99: "tcod.event.SCANCODE_KP_PERIOD",
    100: "tcod.event.SCANCODE_NONUSBACKSLASH",
    101: "tcod.event.SCANCODE_APPLICATION",
    102: "tcod.event.SCANCODE_POWER",
    103: "tcod.event.SCANCODE_KP_EQUALS",
    104: "tcod.event.SCANCODE_F13",
    105: "tcod.event.SCANCODE_F14",
    106: "tcod.event.SCANCODE_F15",
    107: "tcod.event.SCANCODE_F16",
    108: "tcod.event.SCANCODE_F17",
    109: "tcod.event.SCANCODE_F18",
    110: "tcod.event.SCANCODE_F19",
    111: "tcod.event.SCANCODE_F20",
    112: "tcod.event.SCANCODE_F21",
    113: "tcod.event.SCANCODE_F22",
    114: "tcod.event.SCANCODE_F23",
    115: "tcod.event.SCANCODE_F24",
    116: "tcod.event.SCANCODE_EXECUTE",
    117: "tcod.event.SCANCODE_HELP",
    118: "tcod.event.SCANCODE_MENU",
    119: "tcod.event.SCANCODE_SELECT",
    120: "tcod.event.SCANCODE_STOP",
    121: "tcod.event.SCANCODE_AGAIN",
    122: "tcod.event.SCANCODE_UNDO",
    123: "tcod.event.SCANCODE_CUT",
    124: "tcod.event.SCANCODE_COPY",
    125: "tcod.event.SCANCODE_PASTE",
    126: "tcod.event.SCANCODE_FIND",
    127: "tcod.event.SCANCODE_MUTE",
    128: "tcod.event.SCANCODE_VOLUMEUP",
    129: "tcod.event.SCANCODE_VOLUMEDOWN",
    133: "tcod.event.SCANCODE_KP_COMMA",
    134: "tcod.event.SCANCODE_KP_EQUALSAS400",
    135: "tcod.event.SCANCODE_INTERNATIONAL1",
    136: "tcod.event.SCANCODE_INTERNATIONAL2",
    137: "tcod.event.SCANCODE_INTERNATIONAL3",
    138: "tcod.event.SCANCODE_INTERNATIONAL4",
    139: "tcod.event.SCANCODE_INTERNATIONAL5",
    140: "tcod.event.SCANCODE_INTERNATIONAL6",
    141: "tcod.event.SCANCODE_INTERNATIONAL7",
    142: "tcod.event.SCANCODE_INTERNATIONAL8",
    143: "tcod.event.SCANCODE_INTERNATIONAL9",
    144: "tcod.event.SCANCODE_LANG1",
    145: "tcod.event.SCANCODE_LANG2",
    146: "tcod.event.SCANCODE_LANG3",
    147: "tcod.event.SCANCODE_LANG4",
    148: "tcod.event.SCANCODE_LANG5",
    149: "tcod.event.SCANCODE_LANG6",
    150: "tcod.event.SCANCODE_LANG7",
    151: "tcod.event.SCANCODE_LANG8",
    152: "tcod.event.SCANCODE_LANG9",
    153: "tcod.event.SCANCODE_ALTERASE",
    154: "tcod.event.SCANCODE_SYSREQ",
    155: "tcod.event.SCANCODE_CANCEL",
    156: "tcod.event.SCANCODE_CLEAR",
    157: "tcod.event.SCANCODE_PRIOR",
    158: "tcod.event.SCANCODE_RETURN2",
    159: "tcod.event.SCANCODE_SEPARATOR",
    160: "tcod.event.SCANCODE_OUT",
    161: "tcod.event.SCANCODE_OPER",
    162: "tcod.event.SCANCODE_CLEARAGAIN",
    163: "tcod.event.SCANCODE_CRSEL",
    164: "tcod.event.SCANCODE_EXSEL",
    176: "tcod.event.SCANCODE_KP_00",
    177: "tcod.event.SCANCODE_KP_000",
    178: "tcod.event.SCANCODE_THOUSANDSSEPARATOR",
    179: "tcod.event.SCANCODE_DECIMALSEPARATOR",
    180: "tcod.event.SCANCODE_CURRENCYUNIT",
    181: "tcod.event.SCANCODE_CURRENCYSUBUNIT",
    182: "tcod.event.SCANCODE_KP_LEFTPAREN",
    183: "tcod.event.SCANCODE_KP_RIGHTPAREN",
    184: "tcod.event.SCANCODE_KP_LEFTBRACE",
    185: "tcod.event.SCANCODE_KP_RIGHTBRACE",
    186: "tcod.event.SCANCODE_KP_TAB",
    187: "tcod.event.SCANCODE_KP_BACKSPACE",
    188: "tcod.event.SCANCODE_KP_A",
    189: "tcod.event.SCANCODE_KP_B",
    190: "tcod.event.SCANCODE_KP_C",
    191: "tcod.event.SCANCODE_KP_D",
    192: "tcod.event.SCANCODE_KP_E",
    193: "tcod.event.SCANCODE_KP_F",
    194: "tcod.event.SCANCODE_KP_XOR",
    195: "tcod.event.SCANCODE_KP_POWER",
    196: "tcod.event.SCANCODE_KP_PERCENT",
    197: "tcod.event.SCANCODE_KP_LESS",
    198: "tcod.event.SCANCODE_KP_GREATER",
    199: "tcod.event.SCANCODE_KP_AMPERSAND",
    200: "tcod.event.SCANCODE_KP_DBLAMPERSAND",
    201: "tcod.event.SCANCODE_KP_VERTICALBAR",
    202: "tcod.event.SCANCODE_KP_DBLVERTICALBAR",
    203: "tcod.event.SCANCODE_KP_COLON",
    204: "tcod.event.SCANCODE_KP_HASH",
    205: "tcod.event.SCANCODE_KP_SPACE",
    206: "tcod.event.SCANCODE_KP_AT",
    207: "tcod.event.SCANCODE_KP_EXCLAM",
    208: "tcod.event.SCANCODE_KP_MEMSTORE",
    209: "tcod.event.SCANCODE_KP_MEMRECALL",
    210: "tcod.event.SCANCODE_KP_MEMCLEAR",
    211: "tcod.event.SCANCODE_KP_MEMADD",
    212: "tcod.event.SCANCODE_KP_MEMSUBTRACT",
    213: "tcod.event.SCANCODE_KP_MEMMULTIPLY",
    214: "tcod.event.SCANCODE_KP_MEMDIVIDE",
    215: "tcod.event.SCANCODE_KP_PLUSMINUS",
    216: "tcod.event.SCANCODE_KP_CLEAR",
    217: "tcod.event.SCANCODE_KP_CLEARENTRY",
    218: "tcod.event.SCANCODE_KP_BINARY",
    219: "tcod.event.SCANCODE_KP_OCTAL",
    220: "tcod.event.SCANCODE_KP_DECIMAL",
    221: "tcod.event.SCANCODE_KP_HEXADECIMAL",
    224: "tcod.event.SCANCODE_LCTRL",
    225: "tcod.event.SCANCODE_LSHIFT",
    226: "tcod.event.SCANCODE_LALT",
    227: "tcod.event.SCANCODE_LGUI",
    228: "tcod.event.SCANCODE_RCTRL",
    229: "tcod.event.SCANCODE_RSHIFT",
    230: "tcod.event.SCANCODE_RALT",
    231: "tcod.event.SCANCODE_RGUI",
    257: "tcod.event.SCANCODE_MODE",
    258: "tcod.event.SCANCODE_AUDIONEXT",
    259: "tcod.event.SCANCODE_AUDIOPREV",
    260: "tcod.event.SCANCODE_AUDIOSTOP",
    261: "tcod.event.SCANCODE_AUDIOPLAY",
    262: "tcod.event.SCANCODE_AUDIOMUTE",
    263: "tcod.event.SCANCODE_MEDIASELECT",
    264: "tcod.event.SCANCODE_WWW",
    265: "tcod.event.SCANCODE_MAIL",
    266: "tcod.event.SCANCODE_CALCULATOR",
    267: "tcod.event.SCANCODE_COMPUTER",
    268: "tcod.event.SCANCODE_AC_SEARCH",
    269: "tcod.event.SCANCODE_AC_HOME",
    270: "tcod.event.SCANCODE_AC_BACK",
    271: "tcod.event.SCANCODE_AC_FORWARD",
    272: "tcod.event.SCANCODE_AC_STOP",
    273: "tcod.event.SCANCODE_AC_REFRESH",
    274: "tcod.event.SCANCODE_AC_BOOKMARKS",
    275: "tcod.event.SCANCODE_BRIGHTNESSDOWN",
    276: "tcod.event.SCANCODE_BRIGHTNESSUP",
    277: "tcod.event.SCANCODE_DISPLAYSWITCH",
    278: "tcod.event.SCANCODE_KBDILLUMTOGGLE",
    279: "tcod.event.SCANCODE_KBDILLUMDOWN",
    280: "tcod.event.SCANCODE_KBDILLUMUP",
    281: "tcod.event.SCANCODE_EJECT",
    282: "tcod.event.SCANCODE_SLEEP",
    283: "tcod.event.SCANCODE_APP1",
    284: "tcod.event.SCANCODE_APP2",
    285: "tcod.event.SCANCODE_AUDIOREWIND",
    286: "tcod.event.SCANCODE_AUDIOFASTFORWARD",
}

# --- SDL keyboard symbols ---
K_UNKNOWN = 0
K_BACKSPACE = 8
K_TAB = 9
K_RETURN = 13
K_ESCAPE = 27
K_SPACE = 32
K_EXCLAIM = 33
K_QUOTEDBL = 34
K_HASH = 35
K_DOLLAR = 36
K_PERCENT = 37
K_AMPERSAND = 38
K_QUOTE = 39
K_LEFTPAREN = 40
K_RIGHTPAREN = 41
K_ASTERISK = 42
K_PLUS = 43
K_COMMA = 44
K_MINUS = 45
K_PERIOD = 46
K_SLASH = 47
K_0 = 48
K_1 = 49
K_2 = 50
K_3 = 51
K_4 = 52
K_5 = 53
K_6 = 54
K_7 = 55
K_8 = 56
K_9 = 57
K_COLON = 58
K_SEMICOLON = 59
K_LESS = 60
K_EQUALS = 61
K_GREATER = 62
K_QUESTION = 63
K_AT = 64
K_LEFTBRACKET = 91
K_BACKSLASH = 92
K_RIGHTBRACKET = 93
K_CARET = 94
K_UNDERSCORE = 95
K_BACKQUOTE = 96
K_a = 97
K_b = 98
K_c = 99
K_d = 100
K_e = 101
K_f = 102
K_g = 103
K_h = 104
K_i = 105
K_j = 106
K_k = 107
K_l = 108
K_m = 109
K_n = 110
K_o = 111
K_p = 112
K_q = 113
K_r = 114
K_s = 115
K_t = 116
K_u = 117
K_v = 118
K_w = 119
K_x = 120
K_y = 121
K_z = 122
K_DELETE = 127
K_CAPSLOCK = 1073741881
K_F1 = 1073741882
K_F2 = 1073741883
K_F3 = 1073741884
K_F4 = 1073741885
K_F5 = 1073741886
K_F6 = 1073741887
K_F7 = 1073741888
K_F8 = 1073741889
K_F9 = 1073741890
K_F10 = 1073741891
K_F11 = 1073741892
K_F12 = 1073741893
K_PRINTSCREEN = 1073741894
K_SCROLLLOCK = 1073741895
K_PAUSE = 1073741896
K_INSERT = 1073741897
K_HOME = 1073741898
K_PAGEUP = 1073741899
K_END = 1073741901
K_PAGEDOWN = 1073741902
K_RIGHT = 1073741903
K_LEFT = 1073741904
K_DOWN = 1073741905
K_UP = 1073741906
K_NUMLOCKCLEAR = 1073741907
K_KP_DIVIDE = 1073741908
K_KP_MULTIPLY = 1073741909
K_KP_MINUS = 1073741910
K_KP_PLUS = 1073741911
K_KP_ENTER = 1073741912
K_KP_1 = 1073741913
K_KP_2 = 1073741914
K_KP_3 = 1073741915
K_KP_4 = 1073741916
K_KP_5 = 1073741917
K_KP_6 = 1073741918
K_KP_7 = 1073741919
K_KP_8 = 1073741920
K_KP_9 = 1073741921
K_KP_0 = 1073741922
K_KP_PERIOD = 1073741923
K_APPLICATION = 1073741925
K_POWER = 1073741926
K_KP_EQUALS = 1073741927
K_F13 = 1073741928
K_F14 = 1073741929
K_F15 = 1073741930
K_F16 = 1073741931
K_F17 = 1073741932
K_F18 = 1073741933
K_F19 = 1073741934
K_F20 = 1073741935
K_F21 = 1073741936
K_F22 = 1073741937
K_F23 = 1073741938
K_F24 = 1073741939
K_EXECUTE = 1073741940
K_HELP = 1073741941
K_MENU = 1073741942
K_SELECT = 1073741943
K_STOP = 1073741944
K_AGAIN = 1073741945
K_UNDO = 1073741946
K_CUT = 1073741947
K_COPY = 1073741948
K_PASTE = 1073741949
K_FIND = 1073741950
K_MUTE = 1073741951
K_VOLUMEUP = 1073741952
K_VOLUMEDOWN = 1073741953
K_KP_COMMA = 1073741957
K_KP_EQUALSAS400 = 1073741958
K_ALTERASE = 1073741977
K_SYSREQ = 1073741978
K_CANCEL = 1073741979
K_CLEAR = 1073741980
K_PRIOR = 1073741981
K_RETURN2 = 1073741982
K_SEPARATOR = 1073741983
K_OUT = 1073741984
K_OPER = 1073741985
K_CLEARAGAIN = 1073741986
K_CRSEL = 1073741987
K_EXSEL = 1073741988
K_KP_00 = 1073742000
K_KP_000 = 1073742001
K_THOUSANDSSEPARATOR = 1073742002
K_DECIMALSEPARATOR = 1073742003
K_CURRENCYUNIT = 1073742004
K_CURRENCYSUBUNIT = 1073742005
K_KP_LEFTPAREN = 1073742006
K_KP_RIGHTPAREN = 1073742007
K_KP_LEFTBRACE = 1073742008
K_KP_RIGHTBRACE = 1073742009
K_KP_TAB = 1073742010
K_KP_BACKSPACE = 1073742011
K_KP_A = 1073742012
K_KP_B = 1073742013
K_KP_C = 1073742014
K_KP_D = 1073742015
K_KP_E = 1073742016
K_KP_F = 1073742017
K_KP_XOR = 1073742018
K_KP_POWER = 1073742019
K_KP_PERCENT = 1073742020
K_KP_LESS = 1073742021
K_KP_GREATER = 1073742022
K_KP_AMPERSAND = 1073742023
K_KP_DBLAMPERSAND = 1073742024
K_KP_VERTICALBAR = 1073742025
K_KP_DBLVERTICALBAR = 1073742026
K_KP_COLON = 1073742027
K_KP_HASH = 1073742028
K_KP_SPACE = 1073742029
K_KP_AT = 1073742030
K_KP_EXCLAM = 1073742031
K_KP_MEMSTORE = 1073742032
K_KP_MEMRECALL = 1073742033
K_KP_MEMCLEAR = 1073742034
K_KP_MEMADD = 1073742035
K_KP_MEMSUBTRACT = 1073742036
K_KP_MEMMULTIPLY = 1073742037
K_KP_MEMDIVIDE = 1073742038
K_KP_PLUSMINUS = 1073742039
K_KP_CLEAR = 1073742040
K_KP_CLEARENTRY = 1073742041
K_KP_BINARY = 1073742042
K_KP_OCTAL = 1073742043
K_KP_DECIMAL = 1073742044
K_KP_HEXADECIMAL = 1073742045
K_LCTRL = 1073742048
K_LSHIFT = 1073742049
K_LALT = 1073742050
K_LGUI = 1073742051
K_RCTRL = 1073742052
K_RSHIFT = 1073742053
K_RALT = 1073742054
K_RGUI = 1073742055
K_MODE = 1073742081
K_AUDIONEXT = 1073742082
K_AUDIOPREV = 1073742083
K_AUDIOSTOP = 1073742084
K_AUDIOPLAY = 1073742085
K_AUDIOMUTE = 1073742086
K_MEDIASELECT = 1073742087
K_WWW = 1073742088
K_MAIL = 1073742089
K_CALCULATOR = 1073742090
K_COMPUTER = 1073742091
K_AC_SEARCH = 1073742092
K_AC_HOME = 1073742093
K_AC_BACK = 1073742094
K_AC_FORWARD = 1073742095
K_AC_STOP = 1073742096
K_AC_REFRESH = 1073742097
K_AC_BOOKMARKS = 1073742098
K_BRIGHTNESSDOWN = 1073742099
K_BRIGHTNESSUP = 1073742100
K_DISPLAYSWITCH = 1073742101
K_KBDILLUMTOGGLE = 1073742102
K_KBDILLUMDOWN = 1073742103
K_KBDILLUMUP = 1073742104
K_EJECT = 1073742105
K_SLEEP = 1073742106
K_APP1 = 1073742107
K_APP2 = 1073742108
K_AUDIOREWIND = 1073742109
K_AUDIOFASTFORWARD = 1073742110
_REVERSE_SYM_TABLE = {
    0: "tcod.event.K_UNKNOWN",
    8: "tcod.event.K_BACKSPACE",
    9: "tcod.event.K_TAB",
    13: "tcod.event.K_RETURN",
    27: "tcod.event.K_ESCAPE",
    32: "tcod.event.K_SPACE",
    33: "tcod.event.K_EXCLAIM",
    34: "tcod.event.K_QUOTEDBL",
    35: "tcod.event.K_HASH",
    36: "tcod.event.K_DOLLAR",
    37: "tcod.event.K_PERCENT",
    38: "tcod.event.K_AMPERSAND",
    39: "tcod.event.K_QUOTE",
    40: "tcod.event.K_LEFTPAREN",
    41: "tcod.event.K_RIGHTPAREN",
    42: "tcod.event.K_ASTERISK",
    43: "tcod.event.K_PLUS",
    44: "tcod.event.K_COMMA",
    45: "tcod.event.K_MINUS",
    46: "tcod.event.K_PERIOD",
    47: "tcod.event.K_SLASH",
    48: "tcod.event.K_0",
    49: "tcod.event.K_1",
    50: "tcod.event.K_2",
    51: "tcod.event.K_3",
    52: "tcod.event.K_4",
    53: "tcod.event.K_5",
    54: "tcod.event.K_6",
    55: "tcod.event.K_7",
    56: "tcod.event.K_8",
    57: "tcod.event.K_9",
    58: "tcod.event.K_COLON",
    59: "tcod.event.K_SEMICOLON",
    60: "tcod.event.K_LESS",
    61: "tcod.event.K_EQUALS",
    62: "tcod.event.K_GREATER",
    63: "tcod.event.K_QUESTION",
    64: "tcod.event.K_AT",
    91: "tcod.event.K_LEFTBRACKET",
    92: "tcod.event.K_BACKSLASH",
    93: "tcod.event.K_RIGHTBRACKET",
    94: "tcod.event.K_CARET",
    95: "tcod.event.K_UNDERSCORE",
    96: "tcod.event.K_BACKQUOTE",
    97: "tcod.event.K_a",
    98: "tcod.event.K_b",
    99: "tcod.event.K_c",
    100: "tcod.event.K_d",
    101: "tcod.event.K_e",
    102: "tcod.event.K_f",
    103: "tcod.event.K_g",
    104: "tcod.event.K_h",
    105: "tcod.event.K_i",
    106: "tcod.event.K_j",
    107: "tcod.event.K_k",
    108: "tcod.event.K_l",
    109: "tcod.event.K_m",
    110: "tcod.event.K_n",
    111: "tcod.event.K_o",
    112: "tcod.event.K_p",
    113: "tcod.event.K_q",
    114: "tcod.event.K_r",
    115: "tcod.event.K_s",
    116: "tcod.event.K_t",
    117: "tcod.event.K_u",
    118: "tcod.event.K_v",
    119: "tcod.event.K_w",
    120: "tcod.event.K_x",
    121: "tcod.event.K_y",
    122: "tcod.event.K_z",
    127: "tcod.event.K_DELETE",
    1073741881: "tcod.event.K_CAPSLOCK",
    1073741882: "tcod.event.K_F1",
    1073741883: "tcod.event.K_F2",
    1073741884: "tcod.event.K_F3",
    1073741885: "tcod.event.K_F4",
    1073741886: "tcod.event.K_F5",
    1073741887: "tcod.event.K_F6",
    1073741888: "tcod.event.K_F7",
    1073741889: "tcod.event.K_F8",
    1073741890: "tcod.event.K_F9",
    1073741891: "tcod.event.K_F10",
    1073741892: "tcod.event.K_F11",
    1073741893: "tcod.event.K_F12",
    1073741894: "tcod.event.K_PRINTSCREEN",
    1073741895: "tcod.event.K_SCROLLLOCK",
    1073741896: "tcod.event.K_PAUSE",
    1073741897: "tcod.event.K_INSERT",
    1073741898: "tcod.event.K_HOME",
    1073741899: "tcod.event.K_PAGEUP",
    1073741901: "tcod.event.K_END",
    1073741902: "tcod.event.K_PAGEDOWN",
    1073741903: "tcod.event.K_RIGHT",
    1073741904: "tcod.event.K_LEFT",
    1073741905: "tcod.event.K_DOWN",
    1073741906: "tcod.event.K_UP",
    1073741907: "tcod.event.K_NUMLOCKCLEAR",
    1073741908: "tcod.event.K_KP_DIVIDE",
    1073741909: "tcod.event.K_KP_MULTIPLY",
    1073741910: "tcod.event.K_KP_MINUS",
    1073741911: "tcod.event.K_KP_PLUS",
    1073741912: "tcod.event.K_KP_ENTER",
    1073741913: "tcod.event.K_KP_1",
    1073741914: "tcod.event.K_KP_2",
    1073741915: "tcod.event.K_KP_3",
    1073741916: "tcod.event.K_KP_4",
    1073741917: "tcod.event.K_KP_5",
    1073741918: "tcod.event.K_KP_6",
    1073741919: "tcod.event.K_KP_7",
    1073741920: "tcod.event.K_KP_8",
    1073741921: "tcod.event.K_KP_9",
    1073741922: "tcod.event.K_KP_0",
    1073741923: "tcod.event.K_KP_PERIOD",
    1073741925: "tcod.event.K_APPLICATION",
    1073741926: "tcod.event.K_POWER",
    1073741927: "tcod.event.K_KP_EQUALS",
    1073741928: "tcod.event.K_F13",
    1073741929: "tcod.event.K_F14",
    1073741930: "tcod.event.K_F15",
    1073741931: "tcod.event.K_F16",
    1073741932: "tcod.event.K_F17",
    1073741933: "tcod.event.K_F18",
    1073741934: "tcod.event.K_F19",
    1073741935: "tcod.event.K_F20",
    1073741936: "tcod.event.K_F21",
    1073741937: "tcod.event.K_F22",
    1073741938: "tcod.event.K_F23",
    1073741939: "tcod.event.K_F24",
    1073741940: "tcod.event.K_EXECUTE",
    1073741941: "tcod.event.K_HELP",
    1073741942: "tcod.event.K_MENU",
    1073741943: "tcod.event.K_SELECT",
    1073741944: "tcod.event.K_STOP",
    1073741945: "tcod.event.K_AGAIN",
    1073741946: "tcod.event.K_UNDO",
    1073741947: "tcod.event.K_CUT",
    1073741948: "tcod.event.K_COPY",
    1073741949: "tcod.event.K_PASTE",
    1073741950: "tcod.event.K_FIND",
    1073741951: "tcod.event.K_MUTE",
    1073741952: "tcod.event.K_VOLUMEUP",
    1073741953: "tcod.event.K_VOLUMEDOWN",
    1073741957: "tcod.event.K_KP_COMMA",
    1073741958: "tcod.event.K_KP_EQUALSAS400",
    1073741977: "tcod.event.K_ALTERASE",
    1073741978: "tcod.event.K_SYSREQ",
    1073741979: "tcod.event.K_CANCEL",
    1073741980: "tcod.event.K_CLEAR",
    1073741981: "tcod.event.K_PRIOR",
    1073741982: "tcod.event.K_RETURN2",
    1073741983: "tcod.event.K_SEPARATOR",
    1073741984: "tcod.event.K_OUT",
    1073741985: "tcod.event.K_OPER",
    1073741986: "tcod.event.K_CLEARAGAIN",
    1073741987: "tcod.event.K_CRSEL",
    1073741988: "tcod.event.K_EXSEL",
    1073742000: "tcod.event.K_KP_00",
    1073742001: "tcod.event.K_KP_000",
    1073742002: "tcod.event.K_THOUSANDSSEPARATOR",
    1073742003: "tcod.event.K_DECIMALSEPARATOR",
    1073742004: "tcod.event.K_CURRENCYUNIT",
    1073742005: "tcod.event.K_CURRENCYSUBUNIT",
    1073742006: "tcod.event.K_KP_LEFTPAREN",
    1073742007: "tcod.event.K_KP_RIGHTPAREN",
    1073742008: "tcod.event.K_KP_LEFTBRACE",
    1073742009: "tcod.event.K_KP_RIGHTBRACE",
    1073742010: "tcod.event.K_KP_TAB",
    1073742011: "tcod.event.K_KP_BACKSPACE",
    1073742012: "tcod.event.K_KP_A",
    1073742013: "tcod.event.K_KP_B",
    1073742014: "tcod.event.K_KP_C",
    1073742015: "tcod.event.K_KP_D",
    1073742016: "tcod.event.K_KP_E",
    1073742017: "tcod.event.K_KP_F",
    1073742018: "tcod.event.K_KP_XOR",
    1073742019: "tcod.event.K_KP_POWER",
    1073742020: "tcod.event.K_KP_PERCENT",
    1073742021: "tcod.event.K_KP_LESS",
    1073742022: "tcod.event.K_KP_GREATER",
    1073742023: "tcod.event.K_KP_AMPERSAND",
    1073742024: "tcod.event.K_KP_DBLAMPERSAND",
    1073742025: "tcod.event.K_KP_VERTICALBAR",
    1073742026: "tcod.event.K_KP_DBLVERTICALBAR",
    1073742027: "tcod.event.K_KP_COLON",
    1073742028: "tcod.event.K_KP_HASH",
    1073742029: "tcod.event.K_KP_SPACE",
    1073742030: "tcod.event.K_KP_AT",
    1073742031: "tcod.event.K_KP_EXCLAM",
    1073742032: "tcod.event.K_KP_MEMSTORE",
    1073742033: "tcod.event.K_KP_MEMRECALL",
    1073742034: "tcod.event.K_KP_MEMCLEAR",
    1073742035: "tcod.event.K_KP_MEMADD",
    1073742036: "tcod.event.K_KP_MEMSUBTRACT",
    1073742037: "tcod.event.K_KP_MEMMULTIPLY",
    1073742038: "tcod.event.K_KP_MEMDIVIDE",
    1073742039: "tcod.event.K_KP_PLUSMINUS",
    1073742040: "tcod.event.K_KP_CLEAR",
    1073742041: "tcod.event.K_KP_CLEARENTRY",
    1073742042: "tcod.event.K_KP_BINARY",
    1073742043: "tcod.event.K_KP_OCTAL",
    1073742044: "tcod.event.K_KP_DECIMAL",
    1073742045: "tcod.event.K_KP_HEXADECIMAL",
    1073742048: "tcod.event.K_LCTRL",
    1073742049: "tcod.event.K_LSHIFT",
    1073742050: "tcod.event.K_LALT",
    1073742051: "tcod.event.K_LGUI",
    1073742052: "tcod.event.K_RCTRL",
    1073742053: "tcod.event.K_RSHIFT",
    1073742054: "tcod.event.K_RALT",
    1073742055: "tcod.event.K_RGUI",
    1073742081: "tcod.event.K_MODE",
    1073742082: "tcod.event.K_AUDIONEXT",
    1073742083: "tcod.event.K_AUDIOPREV",
    1073742084: "tcod.event.K_AUDIOSTOP",
    1073742085: "tcod.event.K_AUDIOPLAY",
    1073742086: "tcod.event.K_AUDIOMUTE",
    1073742087: "tcod.event.K_MEDIASELECT",
    1073742088: "tcod.event.K_WWW",
    1073742089: "tcod.event.K_MAIL",
    1073742090: "tcod.event.K_CALCULATOR",
    1073742091: "tcod.event.K_COMPUTER",
    1073742092: "tcod.event.K_AC_SEARCH",
    1073742093: "tcod.event.K_AC_HOME",
    1073742094: "tcod.event.K_AC_BACK",
    1073742095: "tcod.event.K_AC_FORWARD",
    1073742096: "tcod.event.K_AC_STOP",
    1073742097: "tcod.event.K_AC_REFRESH",
    1073742098: "tcod.event.K_AC_BOOKMARKS",
    1073742099: "tcod.event.K_BRIGHTNESSDOWN",
    1073742100: "tcod.event.K_BRIGHTNESSUP",
    1073742101: "tcod.event.K_DISPLAYSWITCH",
    1073742102: "tcod.event.K_KBDILLUMTOGGLE",
    1073742103: "tcod.event.K_KBDILLUMDOWN",
    1073742104: "tcod.event.K_KBDILLUMUP",
    1073742105: "tcod.event.K_EJECT",
    1073742106: "tcod.event.K_SLEEP",
    1073742107: "tcod.event.K_APP1",
    1073742108: "tcod.event.K_APP2",
    1073742109: "tcod.event.K_AUDIOREWIND",
    1073742110: "tcod.event.K_AUDIOFASTFORWARD",
}

# --- SDL keyboard modifiers ---
KMOD_NONE = 0
KMOD_LSHIFT = 1
KMOD_RSHIFT = 2
KMOD_LCTRL = 64
KMOD_RCTRL = 128
KMOD_LALT = 256
KMOD_RALT = 512
KMOD_LGUI = 1024
KMOD_RGUI = 2048
KMOD_NUM = 4096
KMOD_CAPS = 8192
KMOD_MODE = 16384
KMOD_RESERVED = 32768
_REVERSE_MOD_TABLE = {
    0: "tcod.event.KMOD_NONE",
    1: "tcod.event.KMOD_LSHIFT",
    2: "tcod.event.KMOD_RSHIFT",
    64: "tcod.event.KMOD_LCTRL",
    128: "tcod.event.KMOD_RCTRL",
    256: "tcod.event.KMOD_LALT",
    512: "tcod.event.KMOD_RALT",
    1024: "tcod.event.KMOD_LGUI",
    2048: "tcod.event.KMOD_RGUI",
    4096: "tcod.event.KMOD_NUM",
    8192: "tcod.event.KMOD_CAPS",
    16384: "tcod.event.KMOD_MODE",
    32768: "tcod.event.KMOD_RESERVED",
}

# --- SDL wheel ---
MOUSEWHEEL_NORMAL = 0
MOUSEWHEEL_FLIPPED = 1
MOUSEWHEEL = 1027
_REVERSE_WHEEL_TABLE = {
    0: "tcod.event.MOUSEWHEEL_NORMAL",
    1: "tcod.event.MOUSEWHEEL_FLIPPED",
    1027: "tcod.event.MOUSEWHEEL",
}

__all__ = [
    "SCANCODE_UNKNOWN",
    "SCANCODE_A",
    "SCANCODE_B",
    "SCANCODE_C",
    "SCANCODE_D",
    "SCANCODE_E",
    "SCANCODE_F",
    "SCANCODE_G",
    "SCANCODE_H",
    "SCANCODE_I",
    "SCANCODE_J",
    "SCANCODE_K",
    "SCANCODE_L",
    "SCANCODE_M",
    "SCANCODE_N",
    "SCANCODE_O",
    "SCANCODE_P",
    "SCANCODE_Q",
    "SCANCODE_R",
    "SCANCODE_S",
    "SCANCODE_T",
    "SCANCODE_U",
    "SCANCODE_V",
    "SCANCODE_W",
    "SCANCODE_X",
    "SCANCODE_Y",
    "SCANCODE_Z",
    "SCANCODE_1",
    "SCANCODE_2",
    "SCANCODE_3",
    "SCANCODE_4",
    "SCANCODE_5",
    "SCANCODE_6",
    "SCANCODE_7",
    "SCANCODE_8",
    "SCANCODE_9",
    "SCANCODE_0",
    "SCANCODE_RETURN",
    "SCANCODE_ESCAPE",
    "SCANCODE_BACKSPACE",
    "SCANCODE_TAB",
    "SCANCODE_SPACE",
    "SCANCODE_MINUS",
    "SCANCODE_EQUALS",
    "SCANCODE_LEFTBRACKET",
    "SCANCODE_RIGHTBRACKET",
    "SCANCODE_BACKSLASH",
    "SCANCODE_NONUSHASH",
    "SCANCODE_SEMICOLON",
    "SCANCODE_APOSTROPHE",
    "SCANCODE_GRAVE",
    "SCANCODE_COMMA",
    "SCANCODE_PERIOD",
    "SCANCODE_SLASH",
    "SCANCODE_CAPSLOCK",
    "SCANCODE_F1",
    "SCANCODE_F2",
    "SCANCODE_F3",
    "SCANCODE_F4",
    "SCANCODE_F5",
    "SCANCODE_F6",
    "SCANCODE_F7",
    "SCANCODE_F8",
    "SCANCODE_F9",
    "SCANCODE_F10",
    "SCANCODE_F11",
    "SCANCODE_F12",
    "SCANCODE_PRINTSCREEN",
    "SCANCODE_SCROLLLOCK",
    "SCANCODE_PAUSE",
    "SCANCODE_INSERT",
    "SCANCODE_HOME",
    "SCANCODE_PAGEUP",
    "SCANCODE_DELETE",
    "SCANCODE_END",
    "SCANCODE_PAGEDOWN",
    "SCANCODE_RIGHT",
    "SCANCODE_LEFT",
    "SCANCODE_DOWN",
    "SCANCODE_UP",
    "SCANCODE_NUMLOCKCLEAR",
    "SCANCODE_KP_DIVIDE",
    "SCANCODE_KP_MULTIPLY",
    "SCANCODE_KP_MINUS",
    "SCANCODE_KP_PLUS",
    "SCANCODE_KP_ENTER",
    "SCANCODE_KP_1",
    "SCANCODE_KP_2",
    "SCANCODE_KP_3",
    "SCANCODE_KP_4",
    "SCANCODE_KP_5",
    "SCANCODE_KP_6",
    "SCANCODE_KP_7",
    "SCANCODE_KP_8",
    "SCANCODE_KP_9",
    "SCANCODE_KP_0",
    "SCANCODE_KP_PERIOD",
    "SCANCODE_NONUSBACKSLASH",
    "SCANCODE_APPLICATION",
    "SCANCODE_POWER",
    "SCANCODE_KP_EQUALS",
    "SCANCODE_F13",
    "SCANCODE_F14",
    "SCANCODE_F15",
    "SCANCODE_F16",
    "SCANCODE_F17",
    "SCANCODE_F18",
    "SCANCODE_F19",
    "SCANCODE_F20",
    "SCANCODE_F21",
    "SCANCODE_F22",
    "SCANCODE_F23",
    "SCANCODE_F24",
    "SCANCODE_EXECUTE",
    "SCANCODE_HELP",
    "SCANCODE_MENU",
    "SCANCODE_SELECT",
    "SCANCODE_STOP",
    "SCANCODE_AGAIN",
    "SCANCODE_UNDO",
    "SCANCODE_CUT",
    "SCANCODE_COPY",
    "SCANCODE_PASTE",
    "SCANCODE_FIND",
    "SCANCODE_MUTE",
    "SCANCODE_VOLUMEUP",
    "SCANCODE_VOLUMEDOWN",
    "SCANCODE_KP_COMMA",
    "SCANCODE_KP_EQUALSAS400",
    "SCANCODE_INTERNATIONAL1",
    "SCANCODE_INTERNATIONAL2",
    "SCANCODE_INTERNATIONAL3",
    "SCANCODE_INTERNATIONAL4",
    "SCANCODE_INTERNATIONAL5",
    "SCANCODE_INTERNATIONAL6",
    "SCANCODE_INTERNATIONAL7",
    "SCANCODE_INTERNATIONAL8",
    "SCANCODE_INTERNATIONAL9",
    "SCANCODE_LANG1",
    "SCANCODE_LANG2",
    "SCANCODE_LANG3",
    "SCANCODE_LANG4",
    "SCANCODE_LANG5",
    "SCANCODE_LANG6",
    "SCANCODE_LANG7",
    "SCANCODE_LANG8",
    "SCANCODE_LANG9",
    "SCANCODE_ALTERASE",
    "SCANCODE_SYSREQ",
    "SCANCODE_CANCEL",
    "SCANCODE_CLEAR",
    "SCANCODE_PRIOR",
    "SCANCODE_RETURN2",
    "SCANCODE_SEPARATOR",
    "SCANCODE_OUT",
    "SCANCODE_OPER",
    "SCANCODE_CLEARAGAIN",
    "SCANCODE_CRSEL",
    "SCANCODE_EXSEL",
    "SCANCODE_KP_00",
    "SCANCODE_KP_000",
    "SCANCODE_THOUSANDSSEPARATOR",
    "SCANCODE_DECIMALSEPARATOR",
    "SCANCODE_CURRENCYUNIT",
    "SCANCODE_CURRENCYSUBUNIT",
    "SCANCODE_KP_LEFTPAREN",
    "SCANCODE_KP_RIGHTPAREN",
    "SCANCODE_KP_LEFTBRACE",
    "SCANCODE_KP_RIGHTBRACE",
    "SCANCODE_KP_TAB",
    "SCANCODE_KP_BACKSPACE",
    "SCANCODE_KP_A",
    "SCANCODE_KP_B",
    "SCANCODE_KP_C",
    "SCANCODE_KP_D",
    "SCANCODE_KP_E",
    "SCANCODE_KP_F",
    "SCANCODE_KP_XOR",
    "SCANCODE_KP_POWER",
    "SCANCODE_KP_PERCENT",
    "SCANCODE_KP_LESS",
    "SCANCODE_KP_GREATER",
    "SCANCODE_KP_AMPERSAND",
    "SCANCODE_KP_DBLAMPERSAND",
    "SCANCODE_KP_VERTICALBAR",
    "SCANCODE_KP_DBLVERTICALBAR",
    "SCANCODE_KP_COLON",
    "SCANCODE_KP_HASH",
    "SCANCODE_KP_SPACE",
    "SCANCODE_KP_AT",
    "SCANCODE_KP_EXCLAM",
    "SCANCODE_KP_MEMSTORE",
    "SCANCODE_KP_MEMRECALL",
    "SCANCODE_KP_MEMCLEAR",
    "SCANCODE_KP_MEMADD",
    "SCANCODE_KP_MEMSUBTRACT",
    "SCANCODE_KP_MEMMULTIPLY",
    "SCANCODE_KP_MEMDIVIDE",
    "SCANCODE_KP_PLUSMINUS",
    "SCANCODE_KP_CLEAR",
    "SCANCODE_KP_CLEARENTRY",
    "SCANCODE_KP_BINARY",
    "SCANCODE_KP_OCTAL",
    "SCANCODE_KP_DECIMAL",
    "SCANCODE_KP_HEXADECIMAL",
    "SCANCODE_LCTRL",
    "SCANCODE_LSHIFT",
    "SCANCODE_LALT",
    "SCANCODE_LGUI",
    "SCANCODE_RCTRL",
    "SCANCODE_RSHIFT",
    "SCANCODE_RALT",
    "SCANCODE_RGUI",
    "SCANCODE_MODE",
    "SCANCODE_AUDIONEXT",
    "SCANCODE_AUDIOPREV",
    "SCANCODE_AUDIOSTOP",
    "SCANCODE_AUDIOPLAY",
    "SCANCODE_AUDIOMUTE",
    "SCANCODE_MEDIASELECT",
    "SCANCODE_WWW",
    "SCANCODE_MAIL",
    "SCANCODE_CALCULATOR",
    "SCANCODE_COMPUTER",
    "SCANCODE_AC_SEARCH",
    "SCANCODE_AC_HOME",
    "SCANCODE_AC_BACK",
    "SCANCODE_AC_FORWARD",
    "SCANCODE_AC_STOP",
    "SCANCODE_AC_REFRESH",
    "SCANCODE_AC_BOOKMARKS",
    "SCANCODE_BRIGHTNESSDOWN",
    "SCANCODE_BRIGHTNESSUP",
    "SCANCODE_DISPLAYSWITCH",
    "SCANCODE_KBDILLUMTOGGLE",
    "SCANCODE_KBDILLUMDOWN",
    "SCANCODE_KBDILLUMUP",
    "SCANCODE_EJECT",
    "SCANCODE_SLEEP",
    "SCANCODE_APP1",
    "SCANCODE_APP2",
    "SCANCODE_AUDIOREWIND",
    "SCANCODE_AUDIOFASTFORWARD",
    "K_UNKNOWN",
    "K_BACKSPACE",
    "K_TAB",
    "K_RETURN",
    "K_ESCAPE",
    "K_SPACE",
    "K_EXCLAIM",
    "K_QUOTEDBL",
    "K_HASH",
    "K_DOLLAR",
    "K_PERCENT",
    "K_AMPERSAND",
    "K_QUOTE",
    "K_LEFTPAREN",
    "K_RIGHTPAREN",
    "K_ASTERISK",
    "K_PLUS",
    "K_COMMA",
    "K_MINUS",
    "K_PERIOD",
    "K_SLASH",
    "K_0",
    "K_1",
    "K_2",
    "K_3",
    "K_4",
    "K_5",
    "K_6",
    "K_7",
    "K_8",
    "K_9",
    "K_COLON",
    "K_SEMICOLON",
    "K_LESS",
    "K_EQUALS",
    "K_GREATER",
    "K_QUESTION",
    "K_AT",
    "K_LEFTBRACKET",
    "K_BACKSLASH",
    "K_RIGHTBRACKET",
    "K_CARET",
    "K_UNDERSCORE",
    "K_BACKQUOTE",
    "K_a",
    "K_b",
    "K_c",
    "K_d",
    "K_e",
    "K_f",
    "K_g",
    "K_h",
    "K_i",
    "K_j",
    "K_k",
    "K_l",
    "K_m",
    "K_n",
    "K_o",
    "K_p",
    "K_q",
    "K_r",
    "K_s",
    "K_t",
    "K_u",
    "K_v",
    "K_w",
    "K_x",
    "K_y",
    "K_z",
    "K_DELETE",
    "K_CAPSLOCK",
    "K_F1",
    "K_F2",
    "K_F3",
    "K_F4",
    "K_F5",
    "K_F6",
    "K_F7",
    "K_F8",
    "K_F9",
    "K_F10",
    "K_F11",
    "K_F12",
    "K_PRINTSCREEN",
    "K_SCROLLLOCK",
    "K_PAUSE",
    "K_INSERT",
    "K_HOME",
    "K_PAGEUP",
    "K_END",
    "K_PAGEDOWN",
    "K_RIGHT",
    "K_LEFT",
    "K_DOWN",
    "K_UP",
    "K_NUMLOCKCLEAR",
    "K_KP_DIVIDE",
    "K_KP_MULTIPLY",
    "K_KP_MINUS",
    "K_KP_PLUS",
    "K_KP_ENTER",
    "K_KP_1",
    "K_KP_2",
    "K_KP_3",
    "K_KP_4",
    "K_KP_5",
    "K_KP_6",
    "K_KP_7",
    "K_KP_8",
    "K_KP_9",
    "K_KP_0",
    "K_KP_PERIOD",
    "K_APPLICATION",
    "K_POWER",
    "K_KP_EQUALS",
    "K_F13",
    "K_F14",
    "K_F15",
    "K_F16",
    "K_F17",
    "K_F18",
    "K_F19",
    "K_F20",
    "K_F21",
    "K_F22",
    "K_F23",
    "K_F24",
    "K_EXECUTE",
    "K_HELP",
    "K_MENU",
    "K_SELECT",
    "K_STOP",
    "K_AGAIN",
    "K_UNDO",
    "K_CUT",
    "K_COPY",
    "K_PASTE",
    "K_FIND",
    "K_MUTE",
    "K_VOLUMEUP",
    "K_VOLUMEDOWN",
    "K_KP_COMMA",
    "K_KP_EQUALSAS400",
    "K_ALTERASE",
    "K_SYSREQ",
    "K_CANCEL",
    "K_CLEAR",
    "K_PRIOR",
    "K_RETURN2",
    "K_SEPARATOR",
    "K_OUT",
    "K_OPER",
    "K_CLEARAGAIN",
    "K_CRSEL",
    "K_EXSEL",
    "K_KP_00",
    "K_KP_000",
    "K_THOUSANDSSEPARATOR",
    "K_DECIMALSEPARATOR",
    "K_CURRENCYUNIT",
    "K_CURRENCYSUBUNIT",
    "K_KP_LEFTPAREN",
    "K_KP_RIGHTPAREN",
    "K_KP_LEFTBRACE",
    "K_KP_RIGHTBRACE",
    "K_KP_TAB",
    "K_KP_BACKSPACE",
    "K_KP_A",
    "K_KP_B",
    "K_KP_C",
    "K_KP_D",
    "K_KP_E",
    "K_KP_F",
    "K_KP_XOR",
    "K_KP_POWER",
    "K_KP_PERCENT",
    "K_KP_LESS",
    "K_KP_GREATER",
    "K_KP_AMPERSAND",
    "K_KP_DBLAMPERSAND",
    "K_KP_VERTICALBAR",
    "K_KP_DBLVERTICALBAR",
    "K_KP_COLON",
    "K_KP_HASH",
    "K_KP_SPACE",
    "K_KP_AT",
    "K_KP_EXCLAM",
    "K_KP_MEMSTORE",
    "K_KP_MEMRECALL",
    "K_KP_MEMCLEAR",
    "K_KP_MEMADD",
    "K_KP_MEMSUBTRACT",
    "K_KP_MEMMULTIPLY",
    "K_KP_MEMDIVIDE",
    "K_KP_PLUSMINUS",
    "K_KP_CLEAR",
    "K_KP_CLEARENTRY",
    "K_KP_BINARY",
    "K_KP_OCTAL",
    "K_KP_DECIMAL",
    "K_KP_HEXADECIMAL",
    "K_LCTRL",
    "K_LSHIFT",
    "K_LALT",
    "K_LGUI",
    "K_RCTRL",
    "K_RSHIFT",
    "K_RALT",
    "K_RGUI",
    "K_MODE",
    "K_AUDIONEXT",
    "K_AUDIOPREV",
    "K_AUDIOSTOP",
    "K_AUDIOPLAY",
    "K_AUDIOMUTE",
    "K_MEDIASELECT",
    "K_WWW",
    "K_MAIL",
    "K_CALCULATOR",
    "K_COMPUTER",
    "K_AC_SEARCH",
    "K_AC_HOME",
    "K_AC_BACK",
    "K_AC_FORWARD",
    "K_AC_STOP",
    "K_AC_REFRESH",
    "K_AC_BOOKMARKS",
    "K_BRIGHTNESSDOWN",
    "K_BRIGHTNESSUP",
    "K_DISPLAYSWITCH",
    "K_KBDILLUMTOGGLE",
    "K_KBDILLUMDOWN",
    "K_KBDILLUMUP",
    "K_EJECT",
    "K_SLEEP",
    "K_APP1",
    "K_APP2",
    "K_AUDIOREWIND",
    "K_AUDIOFASTFORWARD",
    "KMOD_NONE",
    "KMOD_LSHIFT",
    "KMOD_RSHIFT",
    "KMOD_LCTRL",
    "KMOD_RCTRL",
    "KMOD_LALT",
    "KMOD_RALT",
    "KMOD_LGUI",
    "KMOD_RGUI",
    "KMOD_NUM",
    "KMOD_CAPS",
    "KMOD_MODE",
    "KMOD_RESERVED",
    "MOUSEWHEEL_NORMAL",
    "MOUSEWHEEL_FLIPPED",
    "MOUSEWHEEL",
]
