py::class_<librapid::Extent>(module, "Extent")
	.def(py::init<>())
	.def(py::init<const std::vector<int64_t> &>())
	.def(py::init<const librapid::Extent &>())
	.def_static("zero", [](int64_t dims) { return librapid::Extent::zero(dims); })
	.def("stride", [](const librapid::Extent & this_) { return this_.stride(); })
	.def("strideAdjusted", [](const librapid::Extent & this_) { return this_.strideAdjusted(); })
	.def("index", [](const librapid::Extent & this_, const librapid::Extent & ind) { return this_.index(ind); }, py::arg("ind"))
	.def("indexAdjusted", [](const librapid::Extent & this_, const librapid::Extent & ind) { return this_.indexAdjusted(ind); }, py::arg("ind"))
	.def("indexAdjusted", [](const librapid::Extent & this_, const librapid::Extent & ind) { return this_.indexAdjusted(ind); }, py::arg("ind"))
	.def("reverseIndex", [](const librapid::Extent & this_, int64_t ind) { return this_.reverseIndex(ind); }, py::arg("ind"))
	.def("reverseIndex", [](const librapid::Extent & this_, int64_t ind) { return this_.reverseIndex(ind); }, py::arg("ind"))
	.def("partial", [](const librapid::Extent & this_, int64_t start, int64_t end) { return this_.partial(start, end); }, py::arg("start") = int64_t(0), py::arg("end") = int64_t(-1))
	.def("swivelled", [](const librapid::Extent & this_, const librapid::Extent & order) { return this_.swivelled(order); }, py::arg("order"))
	.def("swivel", [](librapid::Extent & this_, const librapid::Extent & order) { this_.swivel(order); }, py::arg("order"))
	.def("size", [](const librapid::Extent & this_) { return this_.size(); })
	.def("sizeAdjusted", [](const librapid::Extent & this_) { return this_.sizeAdjusted(); })
	.def("__getitem__", [](const librapid::Extent & this_, int64_t index) { return this_[index]; }, py::arg("index"))
	.def("__setitem__", [](librapid::Extent & this_, int64_t index, int64_t val) { this_[index] = val; }, py::arg("index"), py::arg("val"))
	.def("adjusted", [](const librapid::Extent & this_, int64_t ind) { return this_.adjusted(ind); }, py::arg("ind"))
	.def("__eq__", [](const librapid::Extent & this_, const librapid::Extent & other) { return this_ == other; }, py::arg("other"))
	.def("str", [](const librapid::Extent & this_) { return this_.str(); })
	.def("__str__", [](const librapid::Extent & this_) { return this_.str(); })
	.def("__repr__", [](const librapid::Extent & this_) { return "<librapid::" + this_.str() + ">"; });
