import unittest
import numpy

def corr_data(N, L, seed):
    '''

See: http://stackoverflow.com/questions/20357854/how-can-i-generate-gaussian-random-process-using-matlab.
    '''
    # Use identical seed so tests are reproducible.
    rand = numpy.random.RandomState(seed=seed)
    return numpy.convolve(rand.randn(2**N), numpy.ones(2**L)/10, 'same')

weights = numpy.fromfunction(lambda i: numpy.cos(2.0*numpy.pi*i/1024.0) + 1.0,
                             (1024,))

data_1D = numpy.array(corr_data(10, 6, 5))
reblock_1D = [
    (0, 1024, numpy.array(0.20848489810011175), numpy.array(0.5059733357706058), numpy.array(0.022228688348921586), numpy.array(0.0004914292726987686)),
    (1, 512, numpy.array(0.20848489810011178), numpy.array(0.5015874592634239), numpy.array(0.0312995687889446), numpy.array(0.0009790681131713157)),
    (2, 256, numpy.array(0.20848489810011184), numpy.array(0.4956240227095556), numpy.array(0.04400035612025432), numpy.array(0.001948368517458123)),
    (3, 128, numpy.array(0.20848489810011173), numpy.array(0.48304884454343255), numpy.array(0.06143141784132584), numpy.array(0.003854549974240774)),
    (4, 64, numpy.array(0.2084848981001117), numpy.array(0.46303627895395055), numpy.array(0.08505846141716576), numpy.array(0.007577610011170585)),
    (5, 32, numpy.array(0.20848489810011178), numpy.array(0.40641824428237183), numpy.array(0.11269680622725792), numpy.array(0.014312508703377615)),
    (6, 16, numpy.array(0.20848489810011178), numpy.array(0.3388777084790293), numpy.array(0.14553300924511708), numpy.array(0.026570570675052838)),
    (7, 8, numpy.array(0.20848489810011178), numpy.array(0.228782900550399), numpy.array(0.16910902568698064), numpy.array(0.04519628822370252)),
    (8, 4, numpy.array(0.20848489810011178), numpy.array(0.21072809492758346), numpy.array(0.229525649398702), numpy.array(0.09370345398462808)),
    (9, 2, numpy.array(0.20848489810011175), numpy.array(0.011498881312406542), numpy.array(0.07582506614704185), numpy.array(0.05361641845649181))
]
reblock_1D_opt = [9]
reblock_1D_ddof = [
    (0, 1024, numpy.array(0.20848489810011175), numpy.array(0.5054792211848923), numpy.array(0.022217831846027897), numpy.array(0.0004909493612996486)),
    (1, 512, numpy.array(0.20848489810011178), numpy.array(0.50060779625705), numpy.array(0.0312689878644089), numpy.array(0.000977155870762778)),
    (2, 256, numpy.array(0.20848489810011184), numpy.array(0.4936879913708464), numpy.array(0.04391433383637248), numpy.array(0.001940757702936802)),
    (3, 128, numpy.array(0.20848489810011173), numpy.array(0.479275025445437), numpy.array(0.061190980841072294), numpy.array(0.0038244363025670184)),
    (4, 64, numpy.array(0.2084848981001117), numpy.array(0.4558013370952951), numpy.array(0.08439132592935121), numpy.array(0.007459209854746044)),
    (5, 32, numpy.array(0.20848489810011178), numpy.array(0.3937176741485477), numpy.array(0.11092194245117652), numpy.array(0.013865242806397065)),
    (6, 16, numpy.array(0.20848489810011178), numpy.array(0.31769785169909), numpy.array(0.1409117302824471), numpy.array(0.02490991000786203)),
    (7, 8, numpy.array(0.20848489810011178), numpy.array(0.20018503798159912), numpy.array(0.15818700878295883), numpy.array(0.03954675219573971)),
    (8, 4, numpy.array(0.20848489810011178), numpy.array(0.1580460711956876), numpy.array(0.19877504319939637), numpy.array(0.07027759048847104)),
    (9, 2, numpy.array(0.20848489810011175), numpy.array(0.005749440656203271), numpy.array(0.05361641845649181), numpy.array(0.026808209228245904))
]
weighted_reblock_1D = [
    (0, 1024, numpy.array(0.39642457548303961), numpy.array(0.56240112081115567), numpy.array(0.0287024348586181), numpy.array(0.0007773519875686496)),
    (1, 512, numpy.array(0.3964245754830395), numpy.array(0.55813399596489899), numpy.array(0.040437025868275814), numpy.array(0.0015499271328715228)),
    (2, 256, numpy.array(0.39642457548303928), numpy.array(0.55195296193041787), numpy.array(0.05686869659929437), numpy.array(0.0030871418588118297)),
    (3, 128, numpy.array(0.39642457548303972), numpy.array(0.5399409181450453), numpy.array(0.07954254065242952), numpy.array(0.006124495944804281)),
    (4, 64, numpy.array(0.39642457548303955), numpy.array(0.51934562453636601), numpy.array(0.11031281877684435), numpy.array(0.012082514269610895)),
    (5, 32, numpy.array(0.39642457548303961), numpy.array(0.4542612454057724), numpy.array(0.14584493037928686), numpy.array(0.022857487575947317)),
    (6, 16, numpy.array(0.39642457548303955), numpy.array(0.35238869676743551), numpy.array(0.18137166887458914), numpy.array(0.04115221509843656)),
    (7, 8, numpy.array(0.39642457548303955), numpy.array(0.23086379378697872), numpy.array(0.2063016672275681), numpy.array(0.06935238142385586)),
    (8, 4, numpy.array(0.39642457548303955), numpy.array(0.2050969122442291), numpy.array(0.2684305406799057), numpy.array(0.13968653419369398)),
    (9, 2, numpy.array(0.39642457548303961), numpy.array(0.091372102810237096), numpy.array(0.21374336406909553), numpy.array(0.15113995871897004))
]
weighted_reblock_1D_opt = [8]
weighted_reblock_1D_ddof = [
    (0, 1024, numpy.array(0.39642457548303961), numpy.array(0.56157729104434251), numpy.array(0.028681404863225148), numpy.array(0.0007762132883681097)),
    (1, 512, numpy.array(0.3964245754830395), numpy.array(0.55649884290382745), numpy.array(0.04037774868189072), numpy.array(0.0015453863449709912)),
    (2, 256, numpy.array(0.39642457548303928), numpy.array(0.54871891327751521), numpy.array(0.05670184693939338), numpy.array(0.0030690534207411437)),
    (3, 128, numpy.array(0.39642457548303972), numpy.array(0.53361390237160189), numpy.array(0.07907512846728215), numpy.array(0.006052729236364605)),
    (4, 64, numpy.array(0.39642457548303955), numpy.array(0.50717670654987312), numpy.array(0.1090127745159775), numpy.array(0.011799405838017226)),
    (5, 32, numpy.array(0.39642457548303961), numpy.array(0.43299050168843334), numpy.array(0.14238940611426093), numpy.array(0.021787187687573747)),
    (6, 16, numpy.array(0.39642457548303955), numpy.array(0.3194930144970819), numpy.array(0.17269873161226296), numpy.array(0.03731063276331179)),
    (7, 8, numpy.array(0.39642457548303955), numpy.array(0.18830341588610447), numpy.array(0.18631761781154219), numpy.array(0.05656707839600898)),
    (8, 4, numpy.array(0.39642457548303955), numpy.array(0.1330419570745226), numpy.array(0.21619551365949558), numpy.array(0.09061165125663259)),
    (9, 2, numpy.array(0.39642457548303961), numpy.array(0.04568587712666318), numpy.array(0.15113909389111366), numpy.array(0.07556969108289141))
]
data_2D = numpy.array((corr_data(10, 6, 5), corr_data(10, 6, 7)))
reblock_2D = [
    (0, 1024, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.50597334,  0.02776897], [ 0.02776897,  0.61260927]]), numpy.array([ 0.02222869,  0.02445917]), numpy.array([ 0.00049143,  0.00054074])),
    (1, 512, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.50158746,  0.02837632], [ 0.02837632,  0.60851945]]), numpy.array([ 0.03129957,  0.03447484]), numpy.array([ 0.00097907,  0.00107839])),
    (2, 256, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.49562402,  0.02892238], [ 0.02892238,  0.60270839]]), numpy.array([ 0.04400036,  0.04852143]), numpy.array([ 0.00194837,  0.00214857])),
    (3, 128, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.48304884,  0.02940551], [ 0.02940551,  0.59443823]]), numpy.array([ 0.06143142,  0.06814726]), numpy.array([ 0.00385455,  0.00427594])),
    (4, 64, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.46303628,  0.02918235], [ 0.02918235,  0.57765284]]), numpy.array([ 0.08505846,  0.09500434]), numpy.array([ 0.00757761,  0.00846366])),
    (5, 32, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.40641824,  0.03257275], [ 0.03257275,  0.5392826 ]]), numpy.array([ 0.11269681,  0.12981749]), numpy.array([ 0.01431251,  0.01648684])),
    (6, 16, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.33887771, -0.00386415], [-0.00386415,  0.45358458]]), numpy.array([ 0.14553301,  0.16837172]), numpy.array([ 0.02657057,  0.03074033])),
    (7, 8, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.2287829 ,  0.08372261], [ 0.08372261,  0.35810369]]), numpy.array([ 0.16910903,  0.21157259]), numpy.array([ 0.04519629,  0.05654515])),
    (8, 4, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.21072809,  0.12820696], [ 0.12820696,  0.20183304]]), numpy.array([ 0.22952565,  0.22462916]), numpy.array([ 0.09370345,  0.09170447])),
    (9, 2, numpy.array([ 0.2084849, -0.1791132]), numpy.array([[ 0.01149888,  0.04086769], [ 0.04086769,  0.14524615]]), numpy.array([ 0.07582507,  0.26948669]), numpy.array([ 0.05361642,  0.19055586]))
]
reblock_2D_opt = [9,8]
weighted_reblock_2D = [
    (0, 1024, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.56240112,  0.14605526], [ 0.14605526,  0.5857983 ]]), numpy.array([ 0.02870243,  0.02929339]), numpy.array([ 0.00077735,  0.00079336])),
    (1, 512, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.558134  ,  0.14659638], [ 0.14659638,  0.58212177]]), numpy.array([ 0.04043703,  0.04129685]), numpy.array([ 0.00154993,  0.00158288])),
    (2, 256, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.55195296,  0.14716981], [ 0.14716981,  0.57717541]]), numpy.array([ 0.0568687 ,  0.05815354]), numpy.array([ 0.00308714,  0.00315689])),
    (3, 128, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.53994092,  0.14766302], [ 0.14766302,  0.56857315]]), numpy.array([ 0.07954254,  0.08162431]), numpy.array([ 0.0061245 ,  0.00628478])),
    (4, 64, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.51934562,  0.14892764], [ 0.14892764,  0.55657569]]), numpy.array([ 0.11031282,  0.11419836]), numpy.array([ 0.01208251,  0.0125081 ])),
    (5, 32, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.45426125,  0.15496076], [ 0.15496076,  0.51297391]]), numpy.array([ 0.14584493,  0.15498374]), numpy.array([ 0.02285749,  0.02428976])),
    (6, 16, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.3523887 ,  0.0780725 ], [ 0.0780725 ,  0.44651165]]), numpy.array([ 0.18137167,  0.20416198]), numpy.array([ 0.04115222,  0.04632321])),
    (7, 8, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.23086379,  0.13047858], [ 0.13047858,  0.41257354]]), numpy.array([ 0.20630167,  0.27578809]), numpy.array([ 0.06935238,  0.09271162])),
    (8, 4, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.20509691,  0.21058012], [ 0.21058012,  0.2373417 ]]), numpy.array([ 0.26843054,  0.28876157]), numpy.array([ 0.13968653,  0.15026644])),
    (9, 2, numpy.array([ 0.39642458,  0.04204868]), numpy.array([[ 0.0913721 ,  0.11915272], [ 0.11915272,  0.1553797 ]]), numpy.array([ 0.21374336,  0.27872952]), numpy.array([ 0.15113996,  0.19709229])),
]
weighted_reblock_2D_opt = [8,9]
