from setuptools import setup, find_packages

VERSION = '1' 
DESCRIPTION = 'Writing style analyzer'
LONG_DESCRIPTION = '''This package analyzes the style of a given writing sample using "involved" and "informational" linguistic features. The main objective of "involved" features is to build a relationship with a reader, engage or involve a reader in a text, and they include pronouns, non-phrasal coordination ("and"), and questions. The main objective of "informational" features is to convey facts and draw attention to the factual information in a text rather than build a relationship with a reader, and they include determiners (such as "the", "which", "both", etc.), past tense verbs, and numbers. The package calculates the number of "involved" and "informational" features and prints out an "involved-informational ratio". The higher the "involved-informational ratio", the more "involved" a given writing sample. These linguistic features are based on the work of Biber (1988), Argamon et al. (2003), Pennebaker (2011).
More information on the [Github page](https://github.com/el2727/test_update)'''

# Setting up
setup(
        name="test_update", 
        version=VERSION,
        author="Test",
        author_email="<youremail@email.com>",
        description=DESCRIPTION,
        long_description=LONG_DESCRIPTION,
        packages=find_packages(),
        install_requires=['spacy'],
        
        keywords=['python', 'test style'],
        classifiers= [
            "Development Status :: 3 - Alpha",
            "Intended Audience :: Education",
            "Programming Language :: Python :: 2",
            "Programming Language :: Python :: 3",
            "Operating System :: MacOS :: MacOS X",
            "Operating System :: Microsoft :: Windows",
        ]
)