from io import open
from setuptools import setup

# Project short description.
short_description = 'A tool for reconstructing paleobathymetry on oceanic and continental crust.'

# Read project long description from 'README'.
with open('README.rst', encoding='utf-8') as long_description_file:
    long_description = long_description_file.read()

# Read package __version__.
exec(open('pybacktrack/version.py').read())

setup(
    name='pybacktrack',
    version=__version__,
    description=short_description,
    long_description=long_description,
    url='https://github.com/EarthByte/pyBacktrack',
    author='John Cannon',
    author_email='john.cannon@sydney.edu.au',
    license='GPL',
    classifiers=['Intended Audience :: Developers',
                 'Intended Audience :: Education',
                 'Intended Audience :: Science/Research',
                 'License :: OSI Approved :: GNU General Public License v2 (GPLv2)',
                 'Operating System :: POSIX :: Linux',
                 'Operating System :: MacOS :: MacOS X',
                 'Operating System :: Microsoft :: Windows',
                 'Programming Language :: Python :: 2.7',
                 'Programming Language :: Python :: 3',
                 'Topic :: Scientific/Engineering'],
    keywords='bathymetry backtrack backstrip rift subsidence tectonic',
    project_urls={
        'Documentation': 'http://pybacktrack.readthedocs.io',
        'Source': 'https://github.com/EarthByte/pyBacktrack'
    },
    packages=['pybacktrack', 'pybacktrack.util'],
    install_requires=['numpy', 'scipy'],
    # 'pytest-runner' is needed so that 'python setup.py test' works.
    # It gets installed to local './.eggs', not installed on the system...
    setup_requires=['pytest-runner'],
    tests_require=['pytest', 'pytest-pep8'],
    python_requires='>=2.7',
    #
    # From the setuptools docs...
    #
    # If include_package_data set to True, this tells setuptools to automatically include any data files
    # it finds inside your package directories that are specified by your MANIFEST.in file.
    #
    # You do not need to use package_data if you are using include_package_data,
    # unless you need to add e.g. files that are generated by your setup script and build process.
    #
    include_package_data=True,
    # package_data={'pybacktrack': ['bundle_data/*']},
    zip_safe=False)
