#! C:\Python27
import os
import math
import numpy as np
import pandas as pd
import cv2
import time
'''
Read binary mask of cells generated by the CellProfiler
Find coordinates of the cell outline
Organize coordinates in a dataframe
Save dataframe as a pickle to pass it to another python script
'''

#print upto 4 degits below zero
np.set_printoptions(precision=4,suppress=True)

def read_selected_imageset(masterUIpath,BuildModel=False):
	#cwd = os.path.abspath(os.path.dirname(__file__))
	#UI = pd.read_csv(cwd + '/' + 'masterUI.csv')

	UI = pd.read_csv(masterUIpath + 'masterUI.csv')

	if BuildModel:
		on = UI.build_model
		tag = 'build_model'
	else:
		on = UI.apply_model
		tag = 'apply_model'

	setpath = UI.maskset_path
	on = [0 if math.isnan(x) else x for x in on]
	index = np.argwhere(on).flatten()

	activeset = setpath[index]

	print 'converting masks from ........'
	print activeset

	binaries=[]
	for index, dirname in enumerate(activeset):
		dirname = os.path.abspath(dirname)
		imagefolders = os.listdir(dirname)
		for folder in imagefolders:
			subdir = os.path.join(dirname,folder)
			binary = os.path.join(subdir,'masks_in_pickle.pickle')
			binaries = np.append(binaries, binary)
	#iterate each cell photo to record pixel coordinate into dataframe
	boundarymaster=[]
	for cellbinary in binaries:
		boundary = pd.read_pickle(cellbinary)
		boundarymaster.append(boundary)
	df = pd.concat(boundarymaster,ignore_index=True)

	### need to edit this specific path to relative path
	#cwd = os.path.abspath(os.path.dirname(__file__))
	#dst = cwd.replace('sourcecode','picklejar')
	#dst = dst.replace('\\','/')
	#dst = dst + '/'

	dst = os.path.join(masterUIpath,'picklejar')
	dst = os.path.abspath(dst)
	pathlist=[dst,tag+'_Vampire_input.pickle']
	path = os.path.join(*pathlist)

	if not os.path.exists(dst):
		os.makedirs(dst)
	df.to_pickle(path)
	return df
