#! C:\Python27
import os
import math
import numpy as np
import pandas as pd
import cv2
import time
from get_bdprops_v3b import *
'''
Read binary mask of cells generated by the CellProfiler
Find coordinates of the cell outline
Organize coordinates in a dataframe
Save dataframe as a pickle to pass it to another python script
'''

def get_immediate_subdirectories(a_dir):
    return [a_dir + name for name in os.listdir(a_dir)
            if os.path.isdir(os.path.join(a_dir, name))]

def record(rph,cva,direc):
	CellsCSV = pd.read_csv(direc + '/Cells.csv')
	CellsCSV['mean_rph']=rph['mean']
	CellsCSV['median_rph']=rph['median']
	CellsCSV['mode_rph']=rph['mode']
	CellsCSV['max_rph']=rph['max']
	CellsCSV['min_rph']=rph['min']
	CellsCSV['Q1_rph']=rph['Q1']
	CellsCSV['Q3_rph']=rph['Q3']
	CellsCSV['mean of Q3_rph']=rph['mean of Q3']
	CellsCSV['mean of Q1_rph']=rph['mean of Q1']
	CellsCSV['sum_rph']=rph['sum']
	CellsCSV['harmonic mean_rph']=rph['harmonic mean']
	CellsCSV['mean with trim 3%_rph']=rph['mean with trim 3%']
	CellsCSV['mean with trim 5%_rph']=rph['mean with trim 5%']
	CellsCSV['mean with trim 15%_rph']=rph['mean with trim 15%']
	CellsCSV['mean with trim 25%_rph']=rph['mean with trim 25%']
	CellsCSV['standard deviation_rph']=rph['standard deviation']
	CellsCSV['std/abs mean_rph']=rph['std/abs mean']
	CellsCSV['std/abs median_rph']=rph['std/abs median']
	CellsCSV['std/abs mode_rph']=rph['std/abs mode']
	CellsCSV['skew_rph']=rph['skew']
	CellsCSV['kurtosis_rph']=rph['kurtosis']
	CellsCSV['mean of abs of x - mean_rph']=rph['mean of abs of x - mean']
	CellsCSV['max-min_rph']=rph['max-min']
	CellsCSV['75perc-25perc_rph']=rph['75perc-25perc']
	CellsCSV['sum of power 2_rph']=rph['sum of power 2']
	CellsCSV['sum of power 3_rph']=rph['sum of power 3']
	CellsCSV['mean of power 2_rph']=rph['mean of power 2']
	CellsCSV['mean of power 3_rph']=rph['mean of power 3']
	CellsCSV['mean of power 4_rph']=rph['mean of power 4']
	CellsCSV['mean of power 5_rph']=rph['mean of power 5']
	CellsCSV['sum of power 2 of x - mean of x_rph']=rph['sum of power 2 of x - mean of x']
	CellsCSV['sum of power 3 of x - mean of x_rph']=rph['sum of power 3 of x - mean of x']
	CellsCSV['mean of power 2 of x - mean of x_rph']=rph['mean of power 2 of x - mean of x']
	CellsCSV['mean of power 3 of x - mean of x_rph']=rph['mean of power 3 of x - mean of x']
	CellsCSV['mean of power 4 of x - mean of x_rph']=rph['mean of power 4 of x - mean of x']
	CellsCSV['mean of power 5 of x - mean of x_rph']=rph['mean of power 5 of x - mean of x']
	CellsCSV['number of local maxima_rph']=rph['number of local maxima']
	CellsCSV['genicoeff_rph']=rph['genicoeff']

	CellsCSV.to_csv(direc + '/Cells.csv')
#print upto 4 degits below zero
np.set_printoptions(precision=4,suppress=True)

def mask_reader_individual(direc):
	#cwd = os.path.abspath(os.path.dirname(__file__))
	operators = [
	'mean','median','mode','max','min','Q1','Q3','mean of Q3',
	'mean of Q1','sum','harmonic mean','mean with trim 3%','mean with trim 5%',
	'mean with trim 15%','mean with trim 25%','standard deviation',
	'std/abs mean','std/abs median','std/abs mode','skew','kurtosis',
	'mean of abs of x - mean','max-min','75perc-25perc','sum of power 2','sum of power 3',
	'mean of power 2','mean of power 3','mean of power 4','mean of power 5',
	'sum of power 2 of x - mean of x','sum of power 3 of x - mean of x',
	'mean of power 2 of x - mean of x','mean of power 3 of x - mean of x',
	'mean of power 4 of x - mean of x','mean of power 5 of x - mean of x',
	'number of local maxima','genicoeff'
	]

	rph_master = pd.DataFrame(columns=operators)
	cva_master = pd.DataFrame(columns=operators)

	if direc[-1] != '/': direc=direc+'/'
	activeset = get_immediate_subdirectories(direc)
	cellphotos=[]
	for index, dirname in enumerate(activeset):
		dirname = dirname + '/'
		imagefolders = os.listdir(dirname)
		for folder in imagefolders:
			subdir = dirname + folder +'/'
			cellphoto = os.listdir(subdir)
			cellphoto = np.core.defchararray.add(subdir,cellphoto)
			cellphotos = np.append(cellphotos, cellphoto)
			cellphotos = [x for x in cellphotos if 'Cells' in x]
	#iterate each cell photo to record pixel coordinate into dataframe
			boundarymaster=[]
			for cellbinary in cellphotos:
				#load image
				im = cv2.imread(cellbinary)
				#find boundary using openCV function
				imgray = cv2.cvtColor(im,cv2.COLOR_BGR2GRAY)
				ret,thresh = cv2.threshold(imgray,127,255,0)
				im2, contours, hierarchy = cv2.findContours(thresh,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)
				#postprocess boundary to match with matlab
				contour = np.empty(2)
				for i in range(len(contours[0])):
					contour = np.vstack((contours[0][i][0],contour))
				contour=contour[0:-1]
				contour.T[0] = contour.T[0]+1
				contour.T[1] = contour.T[1]+1

				boundary = np.empty((2,len(contour.T[1])))
				boundary[0] = contour.T[1]
				boundary[1] = contour.T[0]
				boundary = boundary.T.astype(int)
				#record
				boundarymaster.append(boundary)

			df = pd.DataFrame(boundarymaster)
			### need to edit this specific path to relative path
			#cwd = os.path.abspath(os.path.dirname(__file__))
			#dst = cwd.replace('sourcecode','picklejar')
			#dst = dst.replace('\\','/')
			#dst = dst + '/'

			dst = subdir
			path = dst + 'masks_in_pickle' +'.pickle'

			# if not os.path.exists(dst):
			# 	os.makedirs(dst)
			if not os.path.exists(path):
				df.to_pickle(path)
			print 'getting properties'
			rph,cva=get_bdprops(dst,df,operators)
			rph_master = pd.concat([rph_master,rph],ignore_index=True)
			cva_master = pd.concat([cva_master,cva],ignore_index=True)
		print 'generated property dataframe for the set: ' + dirname
	record(rph_master,cva_master,direc)	
	print 'recorded the image properties'	
	return 
