# Available APIs

```{image} https://raw.githubusercontent.com/dmedina559/bedrock-server-manager/main/src/bedrock_server_manager/web/static/image/icon/favicon.svg
:alt: Bedrock Server Manager Logo
:width: 150px
:align: center
```

---

> _This was auto-generated by the `api_docs_generator` plugin on 2025-08-14 15:07:44 UTC._
> _Application Version: 3.6.0_

---
This lists contains all functions available to plugins via the `self.api` object.
For an updated list of available APIs, please download and run the [api_docs_generator](https://github.com/DMedina559/bedrock-server-manager/blob/main/plugins/api_docs_generator.py) plugin.

## `add_players_manually_api`
```python
self.api.add_players_manually_api(player_strings: List[str], settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Adds or updates player data in the database.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `player_strings` | `List[str]` | `REQUIRED` |
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `add_players_to_allowlist_api`
```python
self.api.add_players_to_allowlist_api(server_name: str, new_players_data: List[Dict[str, Any]], app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Adds new players to the allowlist for a specific server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `new_players_data` | `List[Dict[str, Any]]` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `backup_all`
```python
self.api.backup_all(server_name: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Performs a full backup of the server's world and configuration files.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `backup_config_file`
```python
self.api.backup_config_file(server_name: str, file_to_backup: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Creates a backup of a specific server configuration file.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `file_to_backup` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `backup_world`
```python
self.api.backup_world(server_name: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Creates a backup of the server's world directory.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `configure_player_permission`
```python
self.api.configure_player_permission(server_name: str, xuid: str, player_name: Optional[str], permission: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Sets a player's permission level in permissions.json.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `xuid` | `str` | `REQUIRED` |
| `player_name` | `Optional[str]` | `REQUIRED` |
| `permission` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `export_world`
```python
self.api.export_world(server_name: str, export_dir: Optional[str] = None, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Exports the server's currently active world to a .mcworld archive.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `export_dir` | `Optional[str]` | `None` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_all_global_settings`
```python
self.api.get_all_global_settings(app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Reads the entire global application settings configuration.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_all_known_players_api`
```python
self.api.get_all_known_players_api(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves all player data from the database.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_all_server_settings`
```python
self.api.get_all_server_settings(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Reads the entire JSON configuration for a specific server from its

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_all_servers_data`
```python
self.api.get_all_servers_data(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves status and version for all detected servers.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_application_info_api`
```python
self.api.get_application_info_api(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves general information about the application.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_bedrock_process_info`
```python
self.api.get_bedrock_process_info(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves resource usage for a running Bedrock server process.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_global_setting`
```python
self.api.get_global_setting(key: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Reads a single value from the global application settings.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `key` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_plugin_statuses`
```python
self.api.get_plugin_statuses(app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves the statuses and metadata of all discovered plugins.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_allowlist_api`
```python
self.api.get_server_allowlist_api(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves the allowlist for a specific server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_config_status`
```python
self.api.get_server_config_status(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Gets the status from the server's configuration file.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_installed_version`
```python
self.api.get_server_installed_version(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Gets the installed version from the server's configuration file.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_permissions_api`
```python
self.api.get_server_permissions_api(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves processed permissions data for a server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_properties_api`
```python
self.api.get_server_properties_api(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Reads and returns the `server.properties` file for a server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_running_status`
```python
self.api.get_server_running_status(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Checks if the server process is currently running.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_server_setting`
```python
self.api.get_server_setting(server_name: str, key: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Reads any value from a server's specific JSON configuration file

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `key` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_system_and_app_info`
```python
self.api.get_system_and_app_info(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves basic system and application information.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `get_web_server_status`
```python
self.api.get_web_server_status(app_context: bedrock_server_manager.context.AppContext)
```
**Description:** Checks the status of the web server process.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `app_context` | `bedrock_server_manager.context.AppContext` | `REQUIRED` |

---


## `get_world_name`
```python
self.api.get_world_name(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Retrieves the configured world name (`level-name`) for a server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `import_addon`
```python
self.api.import_addon(server_name: str, addon_file_path: str, stop_start_server: bool = True, restart_only_on_success: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Installs an addon to a specified Bedrock server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `addon_file_path` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `restart_only_on_success` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `import_world`
```python
self.api.import_world(server_name: str, selected_file_path: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Imports a world from a .mcworld file, replacing the active world.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `selected_file_path` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `install_new_server`
```python
self.api.install_new_server(server_name: str, target_version: str = 'LATEST', server_zip_path: Optional[str] = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Installs a new Bedrock server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `target_version` | `str` | `'LATEST'` |
| `server_zip_path` | `Optional[str]` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `list_available_addons_api`
```python
self.api.list_available_addons_api(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Lists available .mcaddon and .mcpack files from the content directory.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `list_available_worlds_api`
```python
self.api.list_available_worlds_api(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Lists available .mcworld files from the content directory.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `list_backup_files`
```python
self.api.list_backup_files(server_name: str, backup_type: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Lists available backup files for a given server and type.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `backup_type` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `modify_server_properties`
```python
self.api.modify_server_properties(server_name: str, properties_to_update: Dict[str, str], restart_after_modify: bool = False, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Modifies one or more properties in `server.properties`.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `properties_to_update` | `Dict[str, str]` | `REQUIRED` |
| `restart_after_modify` | `bool` | `False` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `prune_download_cache`
```python
self.api.prune_download_cache(download_dir: str, keep_count: Optional[int] = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Prunes old downloaded server archives (.zip) in a directory.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `download_dir` | `str` | `REQUIRED` |
| `keep_count` | `Optional[int]` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `prune_old_backups`
```python
self.api.prune_old_backups(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Prunes old backups for a server based on retention settings.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `remove_players_from_allowlist`
```python
self.api.remove_players_from_allowlist(server_name: str, player_names: List[str], app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Removes one or more players from the server's allowlist by name.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `player_names` | `List[str]` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `reset_world`
```python
self.api.reset_world(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Resets the server's world by deleting the active world directory.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `restart_server`
```python
self.api.restart_server(server_name: str, send_message: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Restarts the specified Bedrock server by orchestrating stop and start.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `send_message` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `restore_all`
```python
self.api.restore_all(server_name: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Restores the server from the latest available backups.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `restore_config_file`
```python
self.api.restore_config_file(server_name: str, backup_file_path: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Restores a specific config file from a backup.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `backup_file_path` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `restore_world`
```python
self.api.restore_world(server_name: str, backup_file_path: str, stop_start_server: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Restores a server's world from a specific backup file.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `backup_file_path` | `str` | `REQUIRED` |
| `stop_start_server` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `scan_and_update_player_db_api`
```python
self.api.scan_and_update_player_db_api(settings: Any = None, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Scans all server logs to discover and save player data.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `settings` | `Any` | `None` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `send_command`
```python
self.api.send_command(server_name: str, command: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Sends a command to a running Bedrock server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `command` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `server_lifecycle_manager`
```python
self.api.server_lifecycle_manager(server_name: str, stop_before: bool, start_after: bool = True, restart_on_success_only: bool = False, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** A context manager to safely stop and restart a server for an operation.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `stop_before` | `bool` | `REQUIRED` |
| `start_after` | `bool` | `True` |
| `restart_on_success_only` | `bool` | `False` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `set_custom_global_setting`
```python
self.api.set_custom_global_setting(key: str, value: Any, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Writes a custom value to the global application settings.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `key` | `str` | `REQUIRED` |
| `value` | `Any` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `set_server_custom_value`
```python
self.api.set_server_custom_value(server_name: str, key: str, value: Any, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Writes a key-value pair to the 'custom' section of a server's specific

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `key` | `str` | `REQUIRED` |
| `value` | `Any` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `start_server`
```python
self.api.start_server(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Starts the specified Bedrock server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `stop_server`
```python
self.api.stop_server(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Stops the specified Bedrock server.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `update_server`
```python
self.api.update_server(server_name: str, send_message: bool = True, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Updates an existing server to its configured target version.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `send_message` | `bool` | `True` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `validate_server_exist`
```python
self.api.validate_server_exist(server_name: str, app_context: Optional[bedrock_server_manager.context.AppContext] = None)
```
**Description:** Validates if a server is correctly installed.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |
| `app_context` | `Optional[bedrock_server_manager.context.AppContext]` | `None` |

---


## `validate_server_name_format`
```python
self.api.validate_server_name_format(server_name: str)
```
**Description:** Validates the format of a potential server name.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `server_name` | `str` | `REQUIRED` |

---


## `validate_server_property_value`
```python
self.api.validate_server_property_value(property_name: str, value: str)
```
**Description:** Validates a single server property value based on known rules.

**Parameters:**

| Name | Type | Default |
|------|------|---------|
| `property_name` | `str` | `REQUIRED` |
| `value` | `str` | `REQUIRED` |

---

