# OpenLeap

## Table of contents
* [General Info](#general-info)
* [Technologies](#technologies)
* [Setup](#setup)

## General Info
OpenLeap is an open source project that allows you to add hand gesture control to your Python projects. 

## Technologies

Project was created with technologies:

* Python
* OpenCV
* MediaPipe
* SciKit Learn

## Setup
OpenLeap can be installed using pip, as shown below.

```
$ pip install openleap
```

## Simple Example

```
import openleap

controller = openleap.OpenLeap(SCREEN_SHOW=True, SHOW_DATA_ON_IMAGE=True, GESTURE_MODEL='sign_language')

controller.loop()

```

OpenLeap object can be created with couple of options. 
1. SCREEN_SHOW - if set to True, window with camera feed will be created. 
2. SCREEN_TYPE - 'cam' or 'black' background. 
3. SHOW_DATA_ON_IMAGE - descriptive
4. SHOW_DATA_IN_CONSOLE - descriptive
5. GESTURE_MODEL - chose gesture recognition model, 'basic' or 'sign_language'

## Access hand information

Recognized gestures, hand position, tilt and so on are stored in a dictionary called 'data' that consists of two dataclass objects for right and left hand. Dataclass object is of given structure:

```
@dataclass
class Data:
    x : float = 0
    y : float = 0
    z : float = 0
    distance: float = 0.0
    angle: float = 0.0
    gesture: str = None
```


