/**
 * Valid SPDX License identifiers.
 */
export declare class SpdxLicense {
    readonly id: string;
    private static readonly _ALL;
    /**
     * BSD Zero Clause License
     *
     * @osiApproved
     *
     * @see http://landley.net/toybox/license.html
     */
    static readonly ZERO_BSD: SpdxLicense;
    /**
     * Attribution Assurance License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/attribution
     */
    static readonly AAL: SpdxLicense;
    /**
     * Amazon Digital Services License
     *
     * @see https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense
     */
    static readonly ADSL: SpdxLicense;
    /**
     * Academic Free License v1.1
     *
     * @osiApproved
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-1.1.txt
     */
    static readonly AFL_1_1: SpdxLicense;
    /**
     * Academic Free License v1.2
     *
     * @osiApproved
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-1.2.txt
     */
    static readonly AFL_1_2: SpdxLicense;
    /**
     * Academic Free License v2.0
     *
     * @osiApproved
     *
     * @see http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt
     */
    static readonly AFL_2_0: SpdxLicense;
    /**
     * Academic Free License v2.1
     *
     * @osiApproved
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-2.1.txt
     */
    static readonly AFL_2_1: SpdxLicense;
    /**
     * Academic Free License v3.0
     *
     * @osiApproved
     *
     * @see http://www.rosenlaw.com/AFL3.0.htm
     */
    static readonly AFL_3_0: SpdxLicense;
    /**
     * Affero General Public License v1.0
     *
     * @see http://www.affero.org/oagpl.html
     */
    static readonly AGPL_1_0: SpdxLicense;
    /**
     * Affero General Public License v1.0 only
     *
     * @see http://www.affero.org/oagpl.html
     */
    static readonly AGPL_1_0_ONLY: SpdxLicense;
    /**
     * Affero General Public License v1.0 or later
     *
     * @see http://www.affero.org/oagpl.html
     */
    static readonly AGPL_1_0_OR_LATER: SpdxLicense;
    /**
     * GNU Affero General Public License v3.0
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     */
    static readonly AGPL_3_0: SpdxLicense;
    /**
     * GNU Affero General Public License v3.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     */
    static readonly AGPL_3_0_ONLY: SpdxLicense;
    /**
     * GNU Affero General Public License v3.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     */
    static readonly AGPL_3_0_OR_LATER: SpdxLicense;
    /**
     * AMD's plpa_map.c License
     *
     * @see https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License
     */
    static readonly AMDPLPA: SpdxLicense;
    /**
     * Apple MIT License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Apple_MIT_License
     */
    static readonly AML: SpdxLicense;
    /**
     * Academy of Motion Picture Arts and Sciences BSD
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD
     */
    static readonly AMPAS: SpdxLicense;
    /**
     * ANTLR Software Rights Notice
     *
     * @see http://www.antlr2.org/license.html
     */
    static readonly ANTLR_PD: SpdxLicense;
    /**
     * ANTLR Software Rights Notice with license fallback
     *
     * @see http://www.antlr2.org/license.html
     */
    static readonly ANTLR_PD_FALLBACK: SpdxLicense;
    /**
     * Adobe Postscript AFM License
     *
     * @see https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM
     */
    static readonly APAFML: SpdxLicense;
    /**
     * Adaptive Public License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/APL-1.0
     */
    static readonly APL_1_0: SpdxLicense;
    /**
     * Apple Public Source License 1.0
     *
     * @osiApproved
     *
     * @see https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0
     */
    static readonly APSL_1_0: SpdxLicense;
    /**
     * Apple Public Source License 1.1
     *
     * @osiApproved
     *
     * @see http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE
     */
    static readonly APSL_1_1: SpdxLicense;
    /**
     * Apple Public Source License 1.2
     *
     * @osiApproved
     *
     * @see http://www.samurajdata.se/opensource/mirror/licenses/apsl.php
     */
    static readonly APSL_1_2: SpdxLicense;
    /**
     * Apple Public Source License 2.0
     *
     * @osiApproved
     *
     * @see http://www.opensource.apple.com/license/apsl/
     */
    static readonly APSL_2_0: SpdxLicense;
    /**
     * Abstyles License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Abstyles
     */
    static readonly ABSTYLES: SpdxLicense;
    /**
     * Adobe Systems Incorporated Source Code License Agreement
     *
     * @see https://fedoraproject.org/wiki/Licensing/AdobeLicense
     */
    static readonly ADOBE_2006: SpdxLicense;
    /**
     * Adobe Glyph List License
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph
     */
    static readonly ADOBE_GLYPH: SpdxLicense;
    /**
     * Afmparse License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Afmparse
     */
    static readonly AFMPARSE: SpdxLicense;
    /**
     * Aladdin Free Public License
     *
     * @see http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm
     */
    static readonly ALADDIN: SpdxLicense;
    /**
     * Apache License 1.0
     *
     * @see http://www.apache.org/licenses/LICENSE-1.0
     */
    static readonly APACHE_1_0: SpdxLicense;
    /**
     * Apache License 1.1
     *
     * @osiApproved
     *
     * @see http://apache.org/licenses/LICENSE-1.1
     */
    static readonly APACHE_1_1: SpdxLicense;
    /**
     * Apache License 2.0
     *
     * @osiApproved
     *
     * @see http://www.apache.org/licenses/LICENSE-2.0
     */
    static readonly APACHE_2_0: SpdxLicense;
    /**
     * Artistic License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Artistic-1.0
     */
    static readonly ARTISTIC_1_0: SpdxLicense;
    /**
     * Artistic License 1.0 (Perl)
     *
     * @osiApproved
     *
     * @see http://dev.perl.org/licenses/artistic.html
     */
    static readonly ARTISTIC_1_0_PERL: SpdxLicense;
    /**
     * Artistic License 1.0 w/clause 8
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Artistic-1.0
     */
    static readonly ARTISTIC_1_0_CL8: SpdxLicense;
    /**
     * Artistic License 2.0
     *
     * @osiApproved
     *
     * @see http://www.perlfoundation.org/artistic_license_2_0
     */
    static readonly ARTISTIC_2_0: SpdxLicense;
    /**
     * BSD 1-Clause License
     *
     * @osiApproved
     *
     * @see https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823
     */
    static readonly BSD_1_CLAUSE: SpdxLicense;
    /**
     * BSD 2-Clause "Simplified" License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/BSD-2-Clause
     */
    static readonly BSD_2_CLAUSE: SpdxLicense;
    /**
     * BSD 2-Clause FreeBSD License
     *
     * @see http://www.freebsd.org/copyright/freebsd-license.html
     */
    static readonly BSD_2_CLAUSE_FREEBSD: SpdxLicense;
    /**
     * BSD 2-Clause NetBSD License
     *
     * @see http://www.netbsd.org/about/redistribution.html#default
     */
    static readonly BSD_2_CLAUSE_NETBSD: SpdxLicense;
    /**
     * BSD-2-Clause Plus Patent License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/BSDplusPatent
     */
    static readonly BSD_2_CLAUSE_PATENT: SpdxLicense;
    /**
     * BSD 2-Clause with views sentence
     *
     * @see http://www.freebsd.org/copyright/freebsd-license.html
     */
    static readonly BSD_2_CLAUSE_VIEWS: SpdxLicense;
    /**
     * BSD 3-Clause "New" or "Revised" License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/BSD-3-Clause
     */
    static readonly BSD_3_CLAUSE: SpdxLicense;
    /**
     * BSD with attribution
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution
     */
    static readonly BSD_3_CLAUSE_ATTRIBUTION: SpdxLicense;
    /**
     * BSD 3-Clause Clear License
     *
     * @see http://labs.metacarta.com/license-explanation.html#license
     */
    static readonly BSD_3_CLAUSE_CLEAR: SpdxLicense;
    /**
     * Lawrence Berkeley National Labs BSD variant license
     *
     * @osiApproved
     *
     * @see https://fedoraproject.org/wiki/Licensing/LBNLBSD
     */
    static readonly BSD_3_CLAUSE_LBNL: SpdxLicense;
    /**
     * BSD 3-Clause No Nuclear License
     *
     * @see http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: SpdxLicense;
    /**
     * BSD 3-Clause No Nuclear License 2014
     *
     * @see https://java.net/projects/javaeetutorial/pages/BerkeleyLicense
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: SpdxLicense;
    /**
     * BSD 3-Clause No Nuclear Warranty
     *
     * @see https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: SpdxLicense;
    /**
     * BSD 3-Clause Open MPI variant
     *
     * @see https://www.open-mpi.org/community/license.php
     */
    static readonly BSD_3_CLAUSE_OPEN_MPI: SpdxLicense;
    /**
     * BSD 4-Clause "Original" or "Old" License
     *
     * @see http://directory.fsf.org/wiki/License:BSD_4Clause
     */
    static readonly BSD_4_CLAUSE: SpdxLicense;
    /**
     * BSD-4-Clause (University of California-Specific)
     *
     * @see http://www.freebsd.org/copyright/license.html
     */
    static readonly BSD_4_CLAUSE_UC: SpdxLicense;
    /**
     * BSD Protection License
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD_Protection_License
     */
    static readonly BSD_PROTECTION: SpdxLicense;
    /**
     * BSD Source Code Attribution
     *
     * @see https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt
     */
    static readonly BSD_SOURCE_CODE: SpdxLicense;
    /**
     * Boost Software License 1.0
     *
     * @osiApproved
     *
     * @see http://www.boost.org/LICENSE_1_0.txt
     */
    static readonly BSL_1_0: SpdxLicense;
    /**
     * Business Source License 1.1
     *
     * @see https://mariadb.com/bsl11/
     */
    static readonly BUSL_1_1: SpdxLicense;
    /**
     * Bahyph License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Bahyph
     */
    static readonly BAHYPH: SpdxLicense;
    /**
     * Barr License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Barr
     */
    static readonly BARR: SpdxLicense;
    /**
     * Beerware License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Beerware
     */
    static readonly BEERWARE: SpdxLicense;
    /**
     * BitTorrent Open Source License v1.0
     *
     * @see http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s
     */
    static readonly BITTORRENT_1_0: SpdxLicense;
    /**
     * BitTorrent Open Source License v1.1
     *
     * @see http://directory.fsf.org/wiki/License:BitTorrentOSL1.1
     */
    static readonly BITTORRENT_1_1: SpdxLicense;
    /**
     * Blue Oak Model License 1.0.0
     *
     * @see https://blueoakcouncil.org/license/1.0.0
     */
    static readonly BLUEOAK_1_0_0: SpdxLicense;
    /**
     * Borceux license
     *
     * @see https://fedoraproject.org/wiki/Licensing/Borceux
     */
    static readonly BORCEUX: SpdxLicense;
    /**
     * Cryptographic Autonomy License 1.0
     *
     * @osiApproved
     *
     * @see http://cryptographicautonomylicense.com/license-text.html
     */
    static readonly CAL_1_0: SpdxLicense;
    /**
     * Cryptographic Autonomy License 1.0 (Combined Work Exception)
     *
     * @osiApproved
     *
     * @see http://cryptographicautonomylicense.com/license-text.html
     */
    static readonly CAL_1_0_COMBINED_WORK_EXCEPTION: SpdxLicense;
    /**
     * Computer Associates Trusted Open Source License 1.1
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/CATOSL-1.1
     */
    static readonly CATOSL_1_1: SpdxLicense;
    /**
     * Creative Commons Attribution 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by/1.0/legalcode
     */
    static readonly CC_BY_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by/2.0/legalcode
     */
    static readonly CC_BY_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by/2.5/legalcode
     */
    static readonly CC_BY_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by/3.0/legalcode
     */
    static readonly CC_BY_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution 3.0 Austria
     *
     * @see https://creativecommons.org/licenses/by/3.0/at/legalcode
     */
    static readonly CC_BY_3_0_AT: SpdxLicense;
    /**
     * Creative Commons Attribution 3.0 United States
     *
     * @see https://creativecommons.org/licenses/by/3.0/us/legalcode
     */
    static readonly CC_BY_3_0_US: SpdxLicense;
    /**
     * Creative Commons Attribution 4.0 International
     *
     * @see https://creativecommons.org/licenses/by/4.0/legalcode
     */
    static readonly CC_BY_4_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc/1.0/legalcode
     */
    static readonly CC_BY_NC_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc/2.0/legalcode
     */
    static readonly CC_BY_NC_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc/2.5/legalcode
     */
    static readonly CC_BY_NC_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by-nc/3.0/legalcode
     */
    static readonly CC_BY_NC_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial 4.0 International
     *
     * @see https://creativecommons.org/licenses/by-nc/4.0/legalcode
     */
    static readonly CC_BY_NC_4_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode
     */
    static readonly CC_BY_NC_ND_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode
     */
    static readonly CC_BY_NC_ND_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode
     */
    static readonly CC_BY_NC_ND_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode
     */
    static readonly CC_BY_NC_ND_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode
     */
    static readonly CC_BY_NC_ND_3_0_IGO: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial No Derivatives 4.0 International
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode
     */
    static readonly CC_BY_NC_ND_4_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial Share Alike 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode
     */
    static readonly CC_BY_NC_SA_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial Share Alike 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode
     */
    static readonly CC_BY_NC_SA_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial Share Alike 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode
     */
    static readonly CC_BY_NC_SA_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial Share Alike 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
     */
    static readonly CC_BY_NC_SA_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution Non Commercial Share Alike 4.0 International
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode
     */
    static readonly CC_BY_NC_SA_4_0: SpdxLicense;
    /**
     * Creative Commons Attribution No Derivatives 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nd/1.0/legalcode
     */
    static readonly CC_BY_ND_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution No Derivatives 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-nd/2.0/legalcode
     */
    static readonly CC_BY_ND_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution No Derivatives 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by-nd/2.5/legalcode
     */
    static readonly CC_BY_ND_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution No Derivatives 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by-nd/3.0/legalcode
     */
    static readonly CC_BY_ND_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution No Derivatives 4.0 International
     *
     * @see https://creativecommons.org/licenses/by-nd/4.0/legalcode
     */
    static readonly CC_BY_ND_4_0: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 1.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-sa/1.0/legalcode
     */
    static readonly CC_BY_SA_1_0: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 2.0 Generic
     *
     * @see https://creativecommons.org/licenses/by-sa/2.0/legalcode
     */
    static readonly CC_BY_SA_2_0: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 2.0 England and Wales
     *
     * @see https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode
     */
    static readonly CC_BY_SA_2_0_UK: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 2.5 Generic
     *
     * @see https://creativecommons.org/licenses/by-sa/2.5/legalcode
     */
    static readonly CC_BY_SA_2_5: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 3.0 Unported
     *
     * @see https://creativecommons.org/licenses/by-sa/3.0/legalcode
     */
    static readonly CC_BY_SA_3_0: SpdxLicense;
    /**
     * Creative Commons Attribution-Share Alike 3.0 Austria
     *
     * @see https://creativecommons.org/licenses/by-sa/3.0/at/legalcode
     */
    static readonly CC_BY_SA_3_0_AT: SpdxLicense;
    /**
     * Creative Commons Attribution Share Alike 4.0 International
     *
     * @see https://creativecommons.org/licenses/by-sa/4.0/legalcode
     */
    static readonly CC_BY_SA_4_0: SpdxLicense;
    /**
     * Creative Commons Public Domain Dedication and Certification
     *
     * @see https://creativecommons.org/licenses/publicdomain/
     */
    static readonly CC_PDDC: SpdxLicense;
    /**
     * Creative Commons Zero v1.0 Universal
     *
     * @see https://creativecommons.org/publicdomain/zero/1.0/legalcode
     */
    static readonly CC0_1_0: SpdxLicense;
    /**
     * Common Development and Distribution License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/cddl1
     */
    static readonly CDDL_1_0: SpdxLicense;
    /**
     * Common Development and Distribution License 1.1
     *
     * @see http://glassfish.java.net/public/CDDL+GPL_1_1.html
     */
    static readonly CDDL_1_1: SpdxLicense;
    /**
     * Community Data License Agreement Permissive 1.0
     *
     * @see https://cdla.io/permissive-1-0
     */
    static readonly CDLA_PERMISSIVE_1_0: SpdxLicense;
    /**
     * Community Data License Agreement Sharing 1.0
     *
     * @see https://cdla.io/sharing-1-0
     */
    static readonly CDLA_SHARING_1_0: SpdxLicense;
    /**
     * CeCILL Free Software License Agreement v1.0
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html
     */
    static readonly CECILL_1_0: SpdxLicense;
    /**
     * CeCILL Free Software License Agreement v1.1
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html
     */
    static readonly CECILL_1_1: SpdxLicense;
    /**
     * CeCILL Free Software License Agreement v2.0
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
     */
    static readonly CECILL_2_0: SpdxLicense;
    /**
     * CeCILL Free Software License Agreement v2.1
     *
     * @osiApproved
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html
     */
    static readonly CECILL_2_1: SpdxLicense;
    /**
     * CeCILL-B Free Software License Agreement
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
     */
    static readonly CECILL_B: SpdxLicense;
    /**
     * CeCILL-C Free Software License Agreement
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
     */
    static readonly CECILL_C: SpdxLicense;
    /**
     * CERN Open Hardware Licence v1.1
     *
     * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1
     */
    static readonly CERN_OHL_1_1: SpdxLicense;
    /**
     * CERN Open Hardware Licence v1.2
     *
     * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2
     */
    static readonly CERN_OHL_1_2: SpdxLicense;
    /**
     * CERN Open Hardware Licence Version 2 - Permissive
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     */
    static readonly CERN_OHL_P_2_0: SpdxLicense;
    /**
     * CERN Open Hardware Licence Version 2 - Strongly Reciprocal
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     */
    static readonly CERN_OHL_S_2_0: SpdxLicense;
    /**
     * CERN Open Hardware Licence Version 2 - Weakly Reciprocal
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     */
    static readonly CERN_OHL_W_2_0: SpdxLicense;
    /**
     * CNRI Jython License
     *
     * @see http://www.jython.org/license.html
     */
    static readonly CNRI_JYTHON: SpdxLicense;
    /**
     * CNRI Python License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/CNRI-Python
     */
    static readonly CNRI_PYTHON: SpdxLicense;
    /**
     * CNRI Python Open Source GPL Compatible License Agreement
     *
     * @see http://www.python.org/download/releases/1.6.1/download_win/
     */
    static readonly CNRI_PYTHON_GPL_COMPATIBLE: SpdxLicense;
    /**
     * Common Public Attribution License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/CPAL-1.0
     */
    static readonly CPAL_1_0: SpdxLicense;
    /**
     * Common Public License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/CPL-1.0
     */
    static readonly CPL_1_0: SpdxLicense;
    /**
     * Code Project Open License 1.02
     *
     * @see http://www.codeproject.com/info/cpol10.aspx
     */
    static readonly CPOL_1_02: SpdxLicense;
    /**
     * CUA Office Public License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/CUA-OPL-1.0
     */
    static readonly CUA_OPL_1_0: SpdxLicense;
    /**
     * Caldera License
     *
     * @see http://www.lemis.com/grog/UNIX/ancient-source-all.pdf
     */
    static readonly CALDERA: SpdxLicense;
    /**
     * Clarified Artistic License
     *
     * @see http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/
     */
    static readonly CL_ARTISTIC: SpdxLicense;
    /**
     * Condor Public License v1.1
     *
     * @see http://research.cs.wisc.edu/condor/license.html#condor
     */
    static readonly CONDOR_1_1: SpdxLicense;
    /**
     * Crossword License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Crossword
     */
    static readonly CROSSWORD: SpdxLicense;
    /**
     * CrystalStacker License
     *
     * @see https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker
     */
    static readonly CRYSTAL_STACKER: SpdxLicense;
    /**
     * Cube License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Cube
     */
    static readonly CUBE: SpdxLicense;
    /**
     * Deutsche Freie Software Lizenz
     *
     * @see http://www.dipp.nrw.de/d-fsl/lizenzen/
     */
    static readonly D_FSL_1_0: SpdxLicense;
    /**
     * DOC License
     *
     * @see http://www.cs.wustl.edu/~schmidt/ACE-copying.html
     */
    static readonly DOC: SpdxLicense;
    /**
     * DSDP License
     *
     * @see https://fedoraproject.org/wiki/Licensing/DSDP
     */
    static readonly DSDP: SpdxLicense;
    /**
     * Dotseqn License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Dotseqn
     */
    static readonly DOTSEQN: SpdxLicense;
    /**
     * Educational Community License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/ECL-1.0
     */
    static readonly ECL_1_0: SpdxLicense;
    /**
     * Educational Community License v2.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/ECL-2.0
     */
    static readonly ECL_2_0: SpdxLicense;
    /**
     * Eiffel Forum License v1.0
     *
     * @osiApproved
     *
     * @see http://www.eiffel-nice.org/license/forum.txt
     */
    static readonly EFL_1_0: SpdxLicense;
    /**
     * Eiffel Forum License v2.0
     *
     * @osiApproved
     *
     * @see http://www.eiffel-nice.org/license/eiffel-forum-license-2.html
     */
    static readonly EFL_2_0: SpdxLicense;
    /**
     * EPICS Open License
     *
     * @see https://epics.anl.gov/license/open.php
     */
    static readonly EPICS: SpdxLicense;
    /**
     * Eclipse Public License 1.0
     *
     * @osiApproved
     *
     * @see http://www.eclipse.org/legal/epl-v10.html
     */
    static readonly EPL_1_0: SpdxLicense;
    /**
     * Eclipse Public License 2.0
     *
     * @osiApproved
     *
     * @see https://www.eclipse.org/legal/epl-2.0
     */
    static readonly EPL_2_0: SpdxLicense;
    /**
     * EU DataGrid Software License
     *
     * @osiApproved
     *
     * @see http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
     */
    static readonly EUDATAGRID: SpdxLicense;
    /**
     * European Union Public License 1.0
     *
     * @see http://ec.europa.eu/idabc/en/document/7330.html
     */
    static readonly EUPL_1_0: SpdxLicense;
    /**
     * European Union Public License 1.1
     *
     * @osiApproved
     *
     * @see https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
     */
    static readonly EUPL_1_1: SpdxLicense;
    /**
     * European Union Public License 1.2
     *
     * @osiApproved
     *
     * @see https://joinup.ec.europa.eu/page/eupl-text-11-12
     */
    static readonly EUPL_1_2: SpdxLicense;
    /**
     * Entessa Public License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Entessa
     */
    static readonly ENTESSA: SpdxLicense;
    /**
     * Erlang Public License v1.1
     *
     * @see http://www.erlang.org/EPLICENSE
     */
    static readonly ERLPL_1_1: SpdxLicense;
    /**
     * Eurosym License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Eurosym
     */
    static readonly EUROSYM: SpdxLicense;
    /**
     * FSF All Permissive License
     *
     * @see https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html
     */
    static readonly FSFAP: SpdxLicense;
    /**
     * FSF Unlimited License
     *
     * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License
     */
    static readonly FSFUL: SpdxLicense;
    /**
     * FSF Unlimited License (with License Retention)
     *
     * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant
     */
    static readonly FSFULLR: SpdxLicense;
    /**
     * Freetype Project License
     *
     * @see http://freetype.fis.uniroma2.it/FTL.TXT
     */
    static readonly FTL: SpdxLicense;
    /**
     * Fair License
     *
     * @osiApproved
     *
     * @see http://fairlicense.org/
     */
    static readonly FAIR: SpdxLicense;
    /**
     * Frameworx Open License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Frameworx-1.0
     */
    static readonly FRAMEWORX_1_0: SpdxLicense;
    /**
     * FreeImage Public License v1.0
     *
     * @see http://freeimage.sourceforge.net/freeimage-license.txt
     */
    static readonly FREE_IMAGE: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 only - invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 or later - invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 only - no invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 or later - no invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 only
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.1 or later
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     */
    static readonly GFDL_1_1_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 only - invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 or later - invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 only - no invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 or later - no invariants
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 only
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.2 or later
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     */
    static readonly GFDL_1_2_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 only - invariants
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 or later - invariants
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 only - no invariants
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 or later - no invariants
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 only
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_ONLY: SpdxLicense;
    /**
     * GNU Free Documentation License v1.3 or later
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     */
    static readonly GFDL_1_3_OR_LATER: SpdxLicense;
    /**
     * GL2PS License
     *
     * @see http://www.geuz.org/gl2ps/COPYING.GL2PS
     */
    static readonly GL2_P_S: SpdxLicense;
    /**
     * Good Luck With That Public License
     *
     * @see https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85
     */
    static readonly GLWTPL: SpdxLicense;
    /**
     * GNU General Public License v1.0 only
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     */
    static readonly GPL_1_0: SpdxLicense;
    /**
     * GNU General Public License v1.0 or later
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     */
    static readonly GPL_1_0_PLUS: SpdxLicense;
    /**
     * GNU General Public License v1.0 only
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     */
    static readonly GPL_1_0_ONLY: SpdxLicense;
    /**
     * GNU General Public License v1.0 or later
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     */
    static readonly GPL_1_0_OR_LATER: SpdxLicense;
    /**
     * GNU General Public License v2.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     */
    static readonly GPL_2_0: SpdxLicense;
    /**
     * GNU General Public License v2.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     */
    static readonly GPL_2_0_PLUS: SpdxLicense;
    /**
     * GNU General Public License v2.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     */
    static readonly GPL_2_0_ONLY: SpdxLicense;
    /**
     * GNU General Public License v2.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     */
    static readonly GPL_2_0_OR_LATER: SpdxLicense;
    /**
     * GNU General Public License v2.0 w/GCC Runtime Library exception
     *
     * @see https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10
     */
    static readonly GPL_2_0_WITH_GCC_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v2.0 w/Autoconf exception
     *
     * @see http://ac-archive.sourceforge.net/doc/copyright.html
     */
    static readonly GPL_2_0_WITH_AUTOCONF_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v2.0 w/Bison exception
     *
     * @see http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141
     */
    static readonly GPL_2_0_WITH_BISON_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v2.0 w/Classpath exception
     *
     * @see https://www.gnu.org/software/classpath/license.html
     */
    static readonly GPL_2_0_WITH_CLASSPATH_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v2.0 w/Font exception
     *
     * @see https://www.gnu.org/licenses/gpl-faq.html#FontException
     */
    static readonly GPL_2_0_WITH_FONT_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v3.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     */
    static readonly GPL_3_0: SpdxLicense;
    /**
     * GNU General Public License v3.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     */
    static readonly GPL_3_0_PLUS: SpdxLicense;
    /**
     * GNU General Public License v3.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     */
    static readonly GPL_3_0_ONLY: SpdxLicense;
    /**
     * GNU General Public License v3.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     */
    static readonly GPL_3_0_OR_LATER: SpdxLicense;
    /**
     * GNU General Public License v3.0 w/GCC Runtime Library exception
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/gcc-exception-3.1.html
     */
    static readonly GPL_3_0_WITH_GCC_EXCEPTION: SpdxLicense;
    /**
     * GNU General Public License v3.0 w/Autoconf exception
     *
     * @see https://www.gnu.org/licenses/autoconf-exception-3.0.html
     */
    static readonly GPL_3_0_WITH_AUTOCONF_EXCEPTION: SpdxLicense;
    /**
     * Giftware License
     *
     * @see http://liballeg.org/license.html#allegro-4-the-giftware-license
     */
    static readonly GIFTWARE: SpdxLicense;
    /**
     * 3dfx Glide License
     *
     * @see http://www.users.on.net/~triforce/glidexp/COPYING.txt
     */
    static readonly GLIDE: SpdxLicense;
    /**
     * Glulxe License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Glulxe
     */
    static readonly GLULXE: SpdxLicense;
    /**
     * Historical Permission Notice and Disclaimer
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/HPND
     */
    static readonly HPND: SpdxLicense;
    /**
     * Historical Permission Notice and Disclaimer - sell variant
     *
     * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19
     */
    static readonly HPND_SELL_VARIANT: SpdxLicense;
    /**
     * HTML Tidy License
     *
     * @see https://github.com/htacg/tidy-html5/blob/next/README/LICENSE.md
     */
    static readonly HTMLTIDY: SpdxLicense;
    /**
     * Haskell Language Report License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License
     */
    static readonly HASKELL_REPORT: SpdxLicense;
    /**
     * Hippocratic License 2.1
     *
     * @see https://firstdonoharm.dev/version/2/1/license.html
     */
    static readonly HIPPOCRATIC_2_1: SpdxLicense;
    /**
     * IBM PowerPC Initialization and Boot Software
     *
     * @see http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d
     */
    static readonly IBM_PIBS: SpdxLicense;
    /**
     * ICU License
     *
     * @see http://source.icu-project.org/repos/icu/icu/trunk/license.html
     */
    static readonly ICU: SpdxLicense;
    /**
     * Independent JPEG Group License
     *
     * @see http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2
     */
    static readonly IJG: SpdxLicense;
    /**
     * IPA Font License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/IPA
     */
    static readonly IPA: SpdxLicense;
    /**
     * IBM Public License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/IPL-1.0
     */
    static readonly IPL_1_0: SpdxLicense;
    /**
     * ISC License
     *
     * @osiApproved
     *
     * @see https://www.isc.org/downloads/software-support-policy/isc-license/
     */
    static readonly ISC: SpdxLicense;
    /**
     * ImageMagick License
     *
     * @see http://www.imagemagick.org/script/license.php
     */
    static readonly IMAGE_MAGICK: SpdxLicense;
    /**
     * Imlib2 License
     *
     * @see http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING
     */
    static readonly IMLIB2: SpdxLicense;
    /**
     * Info-ZIP License
     *
     * @see http://www.info-zip.org/license.html
     */
    static readonly INFO_ZIP: SpdxLicense;
    /**
     * Intel Open Source License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Intel
     */
    static readonly INTEL: SpdxLicense;
    /**
     * Intel ACPI Software License Agreement
     *
     * @see https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement
     */
    static readonly INTEL_ACPI: SpdxLicense;
    /**
     * Interbase Public License v1.0
     *
     * @see https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html
     */
    static readonly INTERBASE_1_0: SpdxLicense;
    /**
     * Japan Network Information Center License
     *
     * @see https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366
     */
    static readonly JPNIC: SpdxLicense;
    /**
     * JSON License
     *
     * @see http://www.json.org/license.html
     */
    static readonly JSON: SpdxLicense;
    /**
     * JasPer License
     *
     * @see http://www.ece.uvic.ca/~mdadams/jasper/LICENSE
     */
    static readonly JASPER_2_0: SpdxLicense;
    /**
     * Licence Art Libre 1.2
     *
     * @see http://artlibre.org/licence/lal/licence-art-libre-12/
     */
    static readonly LAL_1_2: SpdxLicense;
    /**
     * Licence Art Libre 1.3
     *
     * @see https://artlibre.org/
     */
    static readonly LAL_1_3: SpdxLicense;
    /**
     * GNU Library General Public License v2 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     */
    static readonly LGPL_2_0: SpdxLicense;
    /**
     * GNU Library General Public License v2 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     */
    static readonly LGPL_2_0_PLUS: SpdxLicense;
    /**
     * GNU Library General Public License v2 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     */
    static readonly LGPL_2_0_ONLY: SpdxLicense;
    /**
     * GNU Library General Public License v2 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     */
    static readonly LGPL_2_0_OR_LATER: SpdxLicense;
    /**
     * GNU Lesser General Public License v2.1 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     */
    static readonly LGPL_2_1: SpdxLicense;
    /**
     * GNU Library General Public License v2.1 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     */
    static readonly LGPL_2_1_PLUS: SpdxLicense;
    /**
     * GNU Lesser General Public License v2.1 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     */
    static readonly LGPL_2_1_ONLY: SpdxLicense;
    /**
     * GNU Lesser General Public License v2.1 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     */
    static readonly LGPL_2_1_OR_LATER: SpdxLicense;
    /**
     * GNU Lesser General Public License v3.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     */
    static readonly LGPL_3_0: SpdxLicense;
    /**
     * GNU Lesser General Public License v3.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     */
    static readonly LGPL_3_0_PLUS: SpdxLicense;
    /**
     * GNU Lesser General Public License v3.0 only
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     */
    static readonly LGPL_3_0_ONLY: SpdxLicense;
    /**
     * GNU Lesser General Public License v3.0 or later
     *
     * @osiApproved
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     */
    static readonly LGPL_3_0_OR_LATER: SpdxLicense;
    /**
     * Lesser General Public License For Linguistic Resources
     *
     * @see http://www-igm.univ-mlv.fr/~unitex/lgpllr.html
     */
    static readonly LGPLLR: SpdxLicense;
    /**
     * Lucent Public License Version 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/LPL-1.0
     */
    static readonly LPL_1_0: SpdxLicense;
    /**
     * Lucent Public License v1.02
     *
     * @osiApproved
     *
     * @see http://plan9.bell-labs.com/plan9/license.html
     */
    static readonly LPL_1_02: SpdxLicense;
    /**
     * LaTeX Project Public License v1.0
     *
     * @see http://www.latex-project.org/lppl/lppl-1-0.txt
     */
    static readonly LPPL_1_0: SpdxLicense;
    /**
     * LaTeX Project Public License v1.1
     *
     * @see http://www.latex-project.org/lppl/lppl-1-1.txt
     */
    static readonly LPPL_1_1: SpdxLicense;
    /**
     * LaTeX Project Public License v1.2
     *
     * @see http://www.latex-project.org/lppl/lppl-1-2.txt
     */
    static readonly LPPL_1_2: SpdxLicense;
    /**
     * LaTeX Project Public License v1.3a
     *
     * @see http://www.latex-project.org/lppl/lppl-1-3a.txt
     */
    static readonly LPPL_1_3A: SpdxLicense;
    /**
     * LaTeX Project Public License v1.3c
     *
     * @osiApproved
     *
     * @see http://www.latex-project.org/lppl/lppl-1-3c.txt
     */
    static readonly LPPL_1_3C: SpdxLicense;
    /**
     * Latex2e License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Latex2e
     */
    static readonly LATEX2_E: SpdxLicense;
    /**
     * Leptonica License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Leptonica
     */
    static readonly LEPTONICA: SpdxLicense;
    /**
     * Licence Libre du Québec – Permissive version 1.1
     *
     * @osiApproved
     *
     * @see https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/
     */
    static readonly LILIQ_P_1_1: SpdxLicense;
    /**
     * Licence Libre du Québec – Réciprocité version 1.1
     *
     * @osiApproved
     *
     * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/
     */
    static readonly LILIQ_R_1_1: SpdxLicense;
    /**
     * Licence Libre du Québec – Réciprocité forte version 1.1
     *
     * @osiApproved
     *
     * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/
     */
    static readonly LILIQ_RPLUS_1_1: SpdxLicense;
    /**
     * libpng License
     *
     * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
     */
    static readonly LIBPNG: SpdxLicense;
    /**
     * Linux Kernel Variant of OpenIB.org license
     *
     * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h
     */
    static readonly LINUX_OPENIB: SpdxLicense;
    /**
     * MIT License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/MIT
     */
    static readonly MIT: SpdxLicense;
    /**
     * MIT No Attribution
     *
     * @osiApproved
     *
     * @see https://github.com/aws/mit-0
     */
    static readonly MIT_0: SpdxLicense;
    /**
     * CMU License
     *
     * @see https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style
     */
    static readonly MIT_CMU: SpdxLicense;
    /**
     * Enlightenment License (e16)
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising
     */
    static readonly MIT_ADVERTISING: SpdxLicense;
    /**
     * enna License
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#enna
     */
    static readonly MIT_ENNA: SpdxLicense;
    /**
     * feh License
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#feh
     */
    static readonly MIT_FEH: SpdxLicense;
    /**
     * MIT Open Group variant
     *
     * @see https://gitlab.freedesktop.org/xorg/app/iceauth/-/blob/master/COPYING
     */
    static readonly MIT_OPEN_GROUP: SpdxLicense;
    /**
     * MIT +no-false-attribs license
     *
     * @see https://fedoraproject.org/wiki/Licensing/MITNFA
     */
    static readonly MITNFA: SpdxLicense;
    /**
     * Mozilla Public License 1.0
     *
     * @osiApproved
     *
     * @see http://www.mozilla.org/MPL/MPL-1.0.html
     */
    static readonly MPL_1_0: SpdxLicense;
    /**
     * Mozilla Public License 1.1
     *
     * @osiApproved
     *
     * @see http://www.mozilla.org/MPL/MPL-1.1.html
     */
    static readonly MPL_1_1: SpdxLicense;
    /**
     * Mozilla Public License 2.0
     *
     * @osiApproved
     *
     * @see http://www.mozilla.org/MPL/2.0/
     */
    static readonly MPL_2_0: SpdxLicense;
    /**
     * Mozilla Public License 2.0 (no copyleft exception)
     *
     * @osiApproved
     *
     * @see http://www.mozilla.org/MPL/2.0/
     */
    static readonly MPL_2_0_NO_COPYLEFT_EXCEPTION: SpdxLicense;
    /**
     * Microsoft Public License
     *
     * @osiApproved
     *
     * @see http://www.microsoft.com/opensource/licenses.mspx
     */
    static readonly MS_PL: SpdxLicense;
    /**
     * Microsoft Reciprocal License
     *
     * @osiApproved
     *
     * @see http://www.microsoft.com/opensource/licenses.mspx
     */
    static readonly MS_RL: SpdxLicense;
    /**
     * Matrix Template Library License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License
     */
    static readonly MTLL: SpdxLicense;
    /**
     * MakeIndex License
     *
     * @see https://fedoraproject.org/wiki/Licensing/MakeIndex
     */
    static readonly MAKE_INDEX: SpdxLicense;
    /**
     * The MirOS Licence
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/MirOS
     */
    static readonly MIR_O_S: SpdxLicense;
    /**
     * Motosoto License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Motosoto
     */
    static readonly MOTOSOTO: SpdxLicense;
    /**
     * Mulan Permissive Software License, Version 1
     *
     * @see https://license.coscl.org.cn/MulanPSL/
     */
    static readonly MULANPSL_1_0: SpdxLicense;
    /**
     * Mulan Permissive Software License, Version 2
     *
     * @osiApproved
     *
     * @see https://license.coscl.org.cn/MulanPSL2/
     */
    static readonly MULANPSL_2_0: SpdxLicense;
    /**
     * Multics License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Multics
     */
    static readonly MULTICS: SpdxLicense;
    /**
     * Mup License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Mup
     */
    static readonly MUP: SpdxLicense;
    /**
     * NASA Open Source Agreement 1.3
     *
     * @osiApproved
     *
     * @see http://ti.arc.nasa.gov/opensource/nosa/
     */
    static readonly NASA_1_3: SpdxLicense;
    /**
     * Net Boolean Public License v1
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894
     */
    static readonly NBPL_1_0: SpdxLicense;
    /**
     * Non-Commercial Government Licence
     *
     * @see https://github.com/spdx/license-list-XML/blob/master/src/Apache-2.0.xml
     */
    static readonly NCGL_UK_2_0: SpdxLicense;
    /**
     * University of Illinois/NCSA Open Source License
     *
     * @osiApproved
     *
     * @see http://otm.illinois.edu/uiuc_openSource
     */
    static readonly NCSA: SpdxLicense;
    /**
     * Nethack General Public License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/NGPL
     */
    static readonly NGPL: SpdxLicense;
    /**
     * NIST Public Domain Notice
     *
     * @see https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt
     */
    static readonly NIST_PD: SpdxLicense;
    /**
     * NIST Public Domain Notice with license fallback
     *
     * @see https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE
     */
    static readonly NIST_PD_FALLBACK: SpdxLicense;
    /**
     * Norwegian Licence for Open Government Data
     *
     * @see http://data.norge.no/nlod/en/1.0
     */
    static readonly NLOD_1_0: SpdxLicense;
    /**
     * No Limit Public License
     *
     * @see https://fedoraproject.org/wiki/Licensing/NLPL
     */
    static readonly NLPL: SpdxLicense;
    /**
     * Netizen Open Source License
     *
     * @see http://bits.netizen.com.au/licenses/NOSL/nosl.txt
     */
    static readonly NOSL: SpdxLicense;
    /**
     * Netscape Public License v1.0
     *
     * @see http://www.mozilla.org/MPL/NPL/1.0/
     */
    static readonly NPL_1_0: SpdxLicense;
    /**
     * Netscape Public License v1.1
     *
     * @see http://www.mozilla.org/MPL/NPL/1.1/
     */
    static readonly NPL_1_1: SpdxLicense;
    /**
     * Non-Profit Open Software License 3.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/NOSL3.0
     */
    static readonly NPOSL_3_0: SpdxLicense;
    /**
     * NRL License
     *
     * @see http://web.mit.edu/network/isakmp/nrllicense.html
     */
    static readonly NRL: SpdxLicense;
    /**
     * NTP License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/NTP
     */
    static readonly NTP: SpdxLicense;
    /**
     * NTP No Attribution
     *
     * @see https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c
     */
    static readonly NTP_0: SpdxLicense;
    /**
     * Naumen Public License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Naumen
     */
    static readonly NAUMEN: SpdxLicense;
    /**
     * Net-SNMP License
     *
     * @see http://net-snmp.sourceforge.net/about/license.html
     */
    static readonly NET_SNMP: SpdxLicense;
    /**
     * NetCDF license
     *
     * @see http://www.unidata.ucar.edu/software/netcdf/copyright.html
     */
    static readonly NET_CD_F: SpdxLicense;
    /**
     * Newsletr License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Newsletr
     */
    static readonly NEWSLETR: SpdxLicense;
    /**
     * Nokia Open Source License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/nokia
     */
    static readonly NOKIA: SpdxLicense;
    /**
     * Noweb License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Noweb
     */
    static readonly NOWEB: SpdxLicense;
    /**
     * Nunit License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Nunit
     */
    static readonly NUNIT: SpdxLicense;
    /**
     * Open Use of Data Agreement v1.0
     *
     * @see https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md
     */
    static readonly O_UDA_1_0: SpdxLicense;
    /**
     * Open CASCADE Technology Public License
     *
     * @see http://www.opencascade.com/content/occt-public-license
     */
    static readonly OCCT_PL: SpdxLicense;
    /**
     * OCLC Research Public License 2.0
     *
     * @osiApproved
     *
     * @see http://www.oclc.org/research/activities/software/license/v2final.htm
     */
    static readonly OCLC_2_0: SpdxLicense;
    /**
     * Open Data Commons Attribution License v1.0
     *
     * @see https://opendatacommons.org/licenses/by/1.0/
     */
    static readonly ODC_BY_1_0: SpdxLicense;
    /**
     * ODC Open Database License v1.0
     *
     * @see http://www.opendatacommons.org/licenses/odbl/1.0/
     */
    static readonly ODBL_1_0: SpdxLicense;
    /**
     * SIL Open Font License 1.0
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     */
    static readonly OFL_1_0: SpdxLicense;
    /**
     * SIL Open Font License 1.0 with Reserved Font Name
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     */
    static readonly OFL_1_0_RFN: SpdxLicense;
    /**
     * SIL Open Font License 1.0 with no Reserved Font Name
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     */
    static readonly OFL_1_0_NO_RFN: SpdxLicense;
    /**
     * SIL Open Font License 1.1
     *
     * @osiApproved
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     */
    static readonly OFL_1_1: SpdxLicense;
    /**
     * SIL Open Font License 1.1 with Reserved Font Name
     *
     * @osiApproved
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     */
    static readonly OFL_1_1_RFN: SpdxLicense;
    /**
     * SIL Open Font License 1.1 with no Reserved Font Name
     *
     * @osiApproved
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     */
    static readonly OFL_1_1_NO_RFN: SpdxLicense;
    /**
     * OGC Software License, Version 1.0
     *
     * @see https://www.ogc.org/ogc/software/1.0
     */
    static readonly OGC_1_0: SpdxLicense;
    /**
     * Open Government Licence - Canada
     *
     * @see https://open.canada.ca/en/open-government-licence-canada
     */
    static readonly OGL_CANADA_2_0: SpdxLicense;
    /**
     * Open Government Licence v1.0
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/
     */
    static readonly OGL_UK_1_0: SpdxLicense;
    /**
     * Open Government Licence v2.0
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/
     */
    static readonly OGL_UK_2_0: SpdxLicense;
    /**
     * Open Government Licence v3.0
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/
     */
    static readonly OGL_UK_3_0: SpdxLicense;
    /**
     * Open Group Test Suite License
     *
     * @osiApproved
     *
     * @see http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt
     */
    static readonly OGTSL: SpdxLicense;
    /**
     * Open LDAP Public License v1.1
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f
     */
    static readonly OLDAP_1_1: SpdxLicense;
    /**
     * Open LDAP Public License v1.2
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7
     */
    static readonly OLDAP_1_2: SpdxLicense;
    /**
     * Open LDAP Public License v1.3
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1
     */
    static readonly OLDAP_1_3: SpdxLicense;
    /**
     * Open LDAP Public License v1.4
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941
     */
    static readonly OLDAP_1_4: SpdxLicense;
    /**
     * Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea
     */
    static readonly OLDAP_2_0: SpdxLicense;
    /**
     * Open LDAP Public License v2.0.1
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e
     */
    static readonly OLDAP_2_0_1: SpdxLicense;
    /**
     * Open LDAP Public License v2.1
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715
     */
    static readonly OLDAP_2_1: SpdxLicense;
    /**
     * Open LDAP Public License v2.2
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3
     */
    static readonly OLDAP_2_2: SpdxLicense;
    /**
     * Open LDAP Public License v2.2.1
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e
     */
    static readonly OLDAP_2_2_1: SpdxLicense;
    /**
     * Open LDAP Public License 2.2.2
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188
     */
    static readonly OLDAP_2_2_2: SpdxLicense;
    /**
     * Open LDAP Public License v2.3
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3
     */
    static readonly OLDAP_2_3: SpdxLicense;
    /**
     * Open LDAP Public License v2.4
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386
     */
    static readonly OLDAP_2_4: SpdxLicense;
    /**
     * Open LDAP Public License v2.5
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf
     */
    static readonly OLDAP_2_5: SpdxLicense;
    /**
     * Open LDAP Public License v2.6
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205
     */
    static readonly OLDAP_2_6: SpdxLicense;
    /**
     * Open LDAP Public License v2.7
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2
     */
    static readonly OLDAP_2_7: SpdxLicense;
    /**
     * Open LDAP Public License v2.8
     *
     * @osiApproved
     *
     * @see http://www.openldap.org/software/release/license.html
     */
    static readonly OLDAP_2_8: SpdxLicense;
    /**
     * Open Market License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Open_Market_License
     */
    static readonly OML: SpdxLicense;
    /**
     * Open Public License v1.0
     *
     * @see http://old.koalateam.com/jackaroo/OPL_1_0.TXT
     */
    static readonly OPL_1_0: SpdxLicense;
    /**
     * OSET Public License version 2.1
     *
     * @osiApproved
     *
     * @see http://www.osetfoundation.org/public-license
     */
    static readonly OSET_PL_2_1: SpdxLicense;
    /**
     * Open Software License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/OSL-1.0
     */
    static readonly OSL_1_0: SpdxLicense;
    /**
     * Open Software License 1.1
     *
     * @see https://fedoraproject.org/wiki/Licensing/OSL1.1
     */
    static readonly OSL_1_1: SpdxLicense;
    /**
     * Open Software License 2.0
     *
     * @osiApproved
     *
     * @see http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html
     */
    static readonly OSL_2_0: SpdxLicense;
    /**
     * Open Software License 2.1
     *
     * @osiApproved
     *
     * @see http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm
     */
    static readonly OSL_2_1: SpdxLicense;
    /**
     * Open Software License 3.0
     *
     * @osiApproved
     *
     * @see https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm
     */
    static readonly OSL_3_0: SpdxLicense;
    /**
     * OpenSSL License
     *
     * @see http://www.openssl.org/source/license.html
     */
    static readonly OPEN_SS_L: SpdxLicense;
    /**
     * ODC Public Domain Dedication & License 1.0
     *
     * @see http://opendatacommons.org/licenses/pddl/1.0/
     */
    static readonly PDDL_1_0: SpdxLicense;
    /**
     * PHP License v3.0
     *
     * @osiApproved
     *
     * @see http://www.php.net/license/3_0.txt
     */
    static readonly PHP_3_0: SpdxLicense;
    /**
     * PHP License v3.01
     *
     * @osiApproved
     *
     * @see http://www.php.net/license/3_01.txt
     */
    static readonly PHP_3_01: SpdxLicense;
    /**
     * Python Software Foundation License 2.0
     *
     * @see https://opensource.org/licenses/Python-2.0
     */
    static readonly PSF_2_0: SpdxLicense;
    /**
     * The Parity Public License 6.0.0
     *
     * @see https://paritylicense.com/versions/6.0.0.html
     */
    static readonly PARITY_6_0_0: SpdxLicense;
    /**
     * The Parity Public License 7.0.0
     *
     * @see https://paritylicense.com/versions/7.0.0.html
     */
    static readonly PARITY_7_0_0: SpdxLicense;
    /**
     * Plexus Classworlds License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License
     */
    static readonly PLEXUS: SpdxLicense;
    /**
     * PolyForm Noncommercial License 1.0.0
     *
     * @see https://polyformproject.org/licenses/noncommercial/1.0.0
     */
    static readonly POLYFORM_NONCOMMERCIAL_1_0_0: SpdxLicense;
    /**
     * PolyForm Small Business License 1.0.0
     *
     * @see https://polyformproject.org/licenses/small-business/1.0.0
     */
    static readonly POLYFORM_SMALL_BUSINESS_1_0_0: SpdxLicense;
    /**
     * PostgreSQL License
     *
     * @osiApproved
     *
     * @see http://www.postgresql.org/about/licence
     */
    static readonly POSTGRE_SQ_L: SpdxLicense;
    /**
     * Python License 2.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Python-2.0
     */
    static readonly PYTHON_2_0: SpdxLicense;
    /**
     * Q Public License 1.0
     *
     * @osiApproved
     *
     * @see http://doc.qt.nokia.com/3.3/license.html
     */
    static readonly QPL_1_0: SpdxLicense;
    /**
     * Qhull License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Qhull
     */
    static readonly QHULL: SpdxLicense;
    /**
     * Red Hat eCos Public License v1.1
     *
     * @see http://ecos.sourceware.org/old-license.html
     */
    static readonly RHECOS_1_1: SpdxLicense;
    /**
     * Reciprocal Public License 1.1
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/RPL-1.1
     */
    static readonly RPL_1_1: SpdxLicense;
    /**
     * Reciprocal Public License 1.5
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/RPL-1.5
     */
    static readonly RPL_1_5: SpdxLicense;
    /**
     * RealNetworks Public Source License v1.0
     *
     * @osiApproved
     *
     * @see https://helixcommunity.org/content/rpsl
     */
    static readonly RPSL_1_0: SpdxLicense;
    /**
     * RSA Message-Digest License
     *
     * @see http://www.faqs.org/rfcs/rfc1321.html
     */
    static readonly RSA_MD: SpdxLicense;
    /**
     * Ricoh Source Code Public License
     *
     * @osiApproved
     *
     * @see http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml
     */
    static readonly RSCPL: SpdxLicense;
    /**
     * Rdisc License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Rdisc_License
     */
    static readonly RDISC: SpdxLicense;
    /**
     * Ruby License
     *
     * @see http://www.ruby-lang.org/en/LICENSE.txt
     */
    static readonly RUBY: SpdxLicense;
    /**
     * Sax Public Domain Notice
     *
     * @see http://www.saxproject.org/copying.html
     */
    static readonly SAX_PD: SpdxLicense;
    /**
     * SCEA Shared Source License
     *
     * @see http://research.scea.com/scea_shared_source_license.html
     */
    static readonly SCEA: SpdxLicense;
    /**
     * SGI Free Software License B v1.0
     *
     * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html
     */
    static readonly SGI_B_1_0: SpdxLicense;
    /**
     * SGI Free Software License B v1.1
     *
     * @see http://oss.sgi.com/projects/FreeB/
     */
    static readonly SGI_B_1_1: SpdxLicense;
    /**
     * SGI Free Software License B v2.0
     *
     * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf
     */
    static readonly SGI_B_2_0: SpdxLicense;
    /**
     * Solderpad Hardware License v0.5
     *
     * @see https://solderpad.org/licenses/SHL-0.5/
     */
    static readonly SHL_0_5: SpdxLicense;
    /**
     * Solderpad Hardware License, Version 0.51
     *
     * @see https://solderpad.org/licenses/SHL-0.51/
     */
    static readonly SHL_0_51: SpdxLicense;
    /**
     * Sun Industry Standards Source License v1.1
     *
     * @osiApproved
     *
     * @see http://www.openoffice.org/licenses/sissl_license.html
     */
    static readonly SISSL: SpdxLicense;
    /**
     * Sun Industry Standards Source License v1.2
     *
     * @see http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html
     */
    static readonly SISSL_1_2: SpdxLicense;
    /**
     * Standard ML of New Jersey License
     *
     * @see https://www.smlnj.org/license.html
     */
    static readonly SMLNJ: SpdxLicense;
    /**
     * Secure Messaging Protocol Public License
     *
     * @see https://github.com/dcblake/SMP/blob/master/Documentation/License.txt
     */
    static readonly SMPPL: SpdxLicense;
    /**
     * SNIA Public License 1.1
     *
     * @see https://fedoraproject.org/wiki/Licensing/SNIA_Public_License
     */
    static readonly SNIA: SpdxLicense;
    /**
     * Sun Public License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/SPL-1.0
     */
    static readonly SPL_1_0: SpdxLicense;
    /**
     * SSH OpenSSH license
     *
     * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10
     */
    static readonly SSH_OPENSSH: SpdxLicense;
    /**
     * SSH short notice
     *
     * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h
     */
    static readonly SSH_SHORT: SpdxLicense;
    /**
     * Server Side Public License, v 1
     *
     * @see https://www.mongodb.com/licensing/server-side-public-license
     */
    static readonly SSPL_1_0: SpdxLicense;
    /**
     * Scheme Widget Library (SWL) Software License Agreement
     *
     * @see https://fedoraproject.org/wiki/Licensing/SWL
     */
    static readonly SWL: SpdxLicense;
    /**
     * Saxpath License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Saxpath_License
     */
    static readonly SAXPATH: SpdxLicense;
    /**
     * Sendmail License
     *
     * @see http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf
     */
    static readonly SENDMAIL: SpdxLicense;
    /**
     * Sendmail License 8.23
     *
     * @see https://www.proofpoint.com/sites/default/files/sendmail-license.pdf
     */
    static readonly SENDMAIL_8_23: SpdxLicense;
    /**
     * Simple Public License 2.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/SimPL-2.0
     */
    static readonly SIMPL_2_0: SpdxLicense;
    /**
     * Sleepycat License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Sleepycat
     */
    static readonly SLEEPYCAT: SpdxLicense;
    /**
     * Spencer License 86
     *
     * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
     */
    static readonly SPENCER_86: SpdxLicense;
    /**
     * Spencer License 94
     *
     * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
     */
    static readonly SPENCER_94: SpdxLicense;
    /**
     * Spencer License 99
     *
     * @see http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c
     */
    static readonly SPENCER_99: SpdxLicense;
    /**
     * Standard ML of New Jersey License
     *
     * @see http://www.smlnj.org//license.html
     */
    static readonly STANDARDML_NJ: SpdxLicense;
    /**
     * SugarCRM Public License v1.1.3
     *
     * @see http://www.sugarcrm.com/crm/SPL
     */
    static readonly SUGARCRM_1_1_3: SpdxLicense;
    /**
     * TAPR Open Hardware License v1.0
     *
     * @see https://www.tapr.org/OHL
     */
    static readonly TAPR_OHL_1_0: SpdxLicense;
    /**
     * TCL/TK License
     *
     * @see http://www.tcl.tk/software/tcltk/license.html
     */
    static readonly TCL: SpdxLicense;
    /**
     * TCP Wrappers License
     *
     * @see http://rc.quest.com/topics/openssh/license.php#tcpwrappers
     */
    static readonly TCP_WRAPPERS: SpdxLicense;
    /**
     * TMate Open Source License
     *
     * @see http://svnkit.com/license.html
     */
    static readonly TMATE: SpdxLicense;
    /**
     * TORQUE v2.5+ Software License v1.1
     *
     * @see https://fedoraproject.org/wiki/Licensing/TORQUEv1.1
     */
    static readonly TORQUE_1_1: SpdxLicense;
    /**
     * Trusster Open Source License
     *
     * @see https://fedoraproject.org/wiki/Licensing/TOSL
     */
    static readonly TOSL: SpdxLicense;
    /**
     * Technische Universitaet Berlin License 1.0
     *
     * @see https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT
     */
    static readonly TU_BERLIN_1_0: SpdxLicense;
    /**
     * Technische Universitaet Berlin License 2.0
     *
     * @see https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt
     */
    static readonly TU_BERLIN_2_0: SpdxLicense;
    /**
     * Upstream Compatibility License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/UCL-1.0
     */
    static readonly UCL_1_0: SpdxLicense;
    /**
     * Universal Permissive License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/UPL
     */
    static readonly UPL_1_0: SpdxLicense;
    /**
     * Unicode License Agreement - Data Files and Software (2015)
     *
     * @see https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html
     */
    static readonly UNICODE_DFS_2015: SpdxLicense;
    /**
     * Unicode License Agreement - Data Files and Software (2016)
     *
     * @osiApproved
     *
     * @see http://www.unicode.org/copyright.html
     */
    static readonly UNICODE_DFS_2016: SpdxLicense;
    /**
     * Unicode Terms of Use
     *
     * @see http://www.unicode.org/copyright.html
     */
    static readonly UNICODE_TOU: SpdxLicense;
    /**
     * The Unlicense
     *
     * @osiApproved
     *
     * @see https://unlicense.org/
     */
    static readonly UNLICENSE: SpdxLicense;
    /**
     * VOSTROM Public License for Open Source
     *
     * @see https://fedoraproject.org/wiki/Licensing/VOSTROM
     */
    static readonly VOSTROM: SpdxLicense;
    /**
     * Vovida Software License v1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/VSL-1.0
     */
    static readonly VSL_1_0: SpdxLicense;
    /**
     * Vim License
     *
     * @see http://vimdoc.sourceforge.net/htmldoc/uganda.html
     */
    static readonly VIM: SpdxLicense;
    /**
     * W3C Software Notice and License (2002-12-31)
     *
     * @osiApproved
     *
     * @see http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html
     */
    static readonly W3_C: SpdxLicense;
    /**
     * W3C Software Notice and License (1998-07-20)
     *
     * @see http://www.w3.org/Consortium/Legal/copyright-software-19980720.html
     */
    static readonly W3C_19980720: SpdxLicense;
    /**
     * W3C Software Notice and Document License (2015-05-13)
     *
     * @see https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document
     */
    static readonly W3C_20150513: SpdxLicense;
    /**
     * Do What The F*ck You Want To Public License
     *
     * @see http://www.wtfpl.net/about/
     */
    static readonly WTFPL: SpdxLicense;
    /**
     * Sybase Open Watcom Public License 1.0
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Watcom-1.0
     */
    static readonly WATCOM_1_0: SpdxLicense;
    /**
     * Wsuipa License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Wsuipa
     */
    static readonly WSUIPA: SpdxLicense;
    /**
     * X11 License
     *
     * @see http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3
     */
    static readonly X11: SpdxLicense;
    /**
     * XFree86 License 1.1
     *
     * @see http://www.xfree86.org/current/LICENSE4.html
     */
    static readonly XFREE86_1_1: SpdxLicense;
    /**
     * XSkat License
     *
     * @see https://fedoraproject.org/wiki/Licensing/XSkat_License
     */
    static readonly XSKAT: SpdxLicense;
    /**
     * Xerox License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Xerox
     */
    static readonly XEROX: SpdxLicense;
    /**
     * X.Net License
     *
     * @osiApproved
     *
     * @see https://opensource.org/licenses/Xnet
     */
    static readonly XNET: SpdxLicense;
    /**
     * Yahoo! Public License v1.0
     *
     * @see http://www.zimbra.com/license/yahoo_public_license_1.0.html
     */
    static readonly YPL_1_0: SpdxLicense;
    /**
     * Yahoo! Public License v1.1
     *
     * @see http://www.zimbra.com/license/yahoo_public_license_1.1.html
     */
    static readonly YPL_1_1: SpdxLicense;
    /**
     * Zope Public License 1.1
     *
     * @see http://old.zope.org/Resources/License/ZPL-1.1
     */
    static readonly ZPL_1_1: SpdxLicense;
    /**
     * Zope Public License 2.0
     *
     * @osiApproved
     *
     * @see http://old.zope.org/Resources/License/ZPL-2.0
     */
    static readonly ZPL_2_0: SpdxLicense;
    /**
     * Zope Public License 2.1
     *
     * @see http://old.zope.org/Resources/ZPL/
     */
    static readonly ZPL_2_1: SpdxLicense;
    /**
     * Zed License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Zed
     */
    static readonly ZED: SpdxLicense;
    /**
     * Zend License v2.0
     *
     * @see https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt
     */
    static readonly ZEND_2_0: SpdxLicense;
    /**
     * Zimbra Public License v1.3
     *
     * @see http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html
     */
    static readonly ZIMBRA_1_3: SpdxLicense;
    /**
     * Zimbra Public License v1.4
     *
     * @see http://www.zimbra.com/legal/zimbra-public-license-1-4
     */
    static readonly ZIMBRA_1_4: SpdxLicense;
    /**
     * zlib License
     *
     * @osiApproved
     *
     * @see http://www.zlib.net/zlib_license.html
     */
    static readonly ZLIB: SpdxLicense;
    /**
     * SQLite Blessing
     *
     * @see https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9
     */
    static readonly BLESSING: SpdxLicense;
    /**
     * bzip2 and libbzip2 License v1.0.5
     *
     * @see https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html
     */
    static readonly BZIP2_1_0_5: SpdxLicense;
    /**
     * bzip2 and libbzip2 License v1.0.6
     *
     * @see https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6
     */
    static readonly BZIP2_1_0_6: SpdxLicense;
    /**
     * copyleft-next 0.3.0
     *
     * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0
     */
    static readonly COPYLEFT_NEXT_0_3_0: SpdxLicense;
    /**
     * copyleft-next 0.3.1
     *
     * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1
     */
    static readonly COPYLEFT_NEXT_0_3_1: SpdxLicense;
    /**
     * curl License
     *
     * @see https://github.com/bagder/curl/blob/master/COPYING
     */
    static readonly CURL: SpdxLicense;
    /**
     * diffmark license
     *
     * @see https://fedoraproject.org/wiki/Licensing/diffmark
     */
    static readonly DIFFMARK: SpdxLicense;
    /**
     * dvipdfm License
     *
     * @see https://fedoraproject.org/wiki/Licensing/dvipdfm
     */
    static readonly DVIPDFM: SpdxLicense;
    /**
     * eCos license version 2.0
     *
     * @see https://www.gnu.org/licenses/ecos-license.html
     */
    static readonly ECOS_2_0: SpdxLicense;
    /**
     * eGenix.com Public License 1.1.0
     *
     * @see http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf
     */
    static readonly E_GENIX: SpdxLicense;
    /**
     * Etalab Open License 2.0
     *
     * @see https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf
     */
    static readonly ETALAB_2_0: SpdxLicense;
    /**
     * gSOAP Public License v1.3b
     *
     * @see http://www.cs.fsu.edu/~engelen/license.html
     */
    static readonly GSOAP_1_3B: SpdxLicense;
    /**
     * gnuplot License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Gnuplot
     */
    static readonly GNUPLOT: SpdxLicense;
    /**
     * iMatix Standard Function Library Agreement
     *
     * @see http://legacy.imatix.com/html/sfl/sfl4.htm#license
     */
    static readonly I_MATIX: SpdxLicense;
    /**
     * PNG Reference Library version 2
     *
     * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
     */
    static readonly LIBPNG_2_0: SpdxLicense;
    /**
     * libselinux public domain notice
     *
     * @see https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE
     */
    static readonly LIBSELINUX_1_0: SpdxLicense;
    /**
     * libtiff License
     *
     * @see https://fedoraproject.org/wiki/Licensing/libtiff
     */
    static readonly LIBTIFF: SpdxLicense;
    /**
     * mpich2 License
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT
     */
    static readonly MPICH2: SpdxLicense;
    /**
     * psfrag License
     *
     * @see https://fedoraproject.org/wiki/Licensing/psfrag
     */
    static readonly PSFRAG: SpdxLicense;
    /**
     * psutils License
     *
     * @see https://fedoraproject.org/wiki/Licensing/psutils
     */
    static readonly PSUTILS: SpdxLicense;
    /**
     * wxWindows Library License
     *
     * @see https://opensource.org/licenses/WXwindows
     */
    static readonly WX_WINDOWS: SpdxLicense;
    /**
     * xinetd License
     *
     * @see https://fedoraproject.org/wiki/Licensing/Xinetd_License
     */
    static readonly XINETD: SpdxLicense;
    /**
     * XPP License
     *
     * @see https://fedoraproject.org/wiki/Licensing/xpp
     */
    static readonly XPP: SpdxLicense;
    /**
     * zlib/libpng License with Acknowledgement
     *
     * @see https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement
     */
    static readonly ZLIB_ACKNOWLEDGEMENT: SpdxLicense;
    /** Packages that have not been licensed */
    static readonly UNLICENSED: SpdxLicense;
    /** All valid SPDX Licenses */
    static all(): SpdxLicense[];
    /** All OSI-Approved SPDX Licenses */
    static osiApproved(): SpdxLicense[];
    /** The Apache family of licenses */
    static apache(): SpdxLicense[];
    /** The BSD family of licenses */
    static bsd(): SpdxLicense[];
    /** The CDDL family of licenses */
    static cddl(): SpdxLicense[];
    /** The EPL family of licenses */
    static epl(): SpdxLicense[];
    /** The MIT family of licenses */
    static mit(): SpdxLicense[];
    /** The MPL family of licenses */
    static mpl(): SpdxLicense[];
    private constructor();
}
