import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import type { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Duration } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
/**
 * Props for `PackageStats`.
 */
export interface PackageStatsProps {
    /**
     * The package store bucket, which should include both the
     * catalog and stats.
     */
    readonly bucket: IBucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * How frequently should the stats be updated?
     *
     * NPM updates their download stats once a day.
     *
     * @default - 1 day
     */
    readonly updatePeriod?: Duration;
    /**
     * The key of the object storing the package stats.
     */
    readonly objectKey: string;
}
/**
 * Builds or re-builds the `stats.json` object in the designated bucket.
 */
export declare class PackageStats extends Construct {
    /**
     * The package store bucket, which should include both the
     * catalog and stats.
     */
    readonly bucket: IBucket;
    /**
     * The Lambda function that periodically updates stats.json.
     */
    readonly handler: IFunction;
    /**
     * The key of the object storing the package stats.
     */
    readonly statsKey: string;
    constructor(scope: Construct, id: string, props: PackageStatsProps);
    metricPackagesCount(opts?: MetricOptions): Metric;
}
