"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegDefaultStack = void 0;
const gcp = require("@cdktf/provider-google");
const cdktf = require("cdktf");
const index_1 = require("./index");
class IntegDefaultStack extends cdktf.TerraformStack {
    constructor(scope, id) {
        super(scope, id);
        const local = 'asia-east1';
        const projectId = `${process.env.PROJECT_ID}`;
        const provider = new gcp.GoogleProvider(this, 'GoogleAuth', {
            region: local,
            zone: local + '-c',
            project: projectId,
        });
        new index_1.GitlabRunnerAutoscaling(this, 'GitlabRunnerAutoscaling', {
            gitlabToken: `${process.env.GITLAB_TOKEN}`,
            provider,
        });
    }
}
exports.IntegDefaultStack = IntegDefaultStack;
const app = new cdktf.App();
new IntegDefaultStack(app, 'cloudrun-cdktf');
app.synth();
//# sourceMappingURL=data:application/json;base64,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