"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolvableField = exports.Field = exports.GraphqlType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const schema_base_1 = require("./schema-base");
/**
 * The GraphQL Types in AppSync's GraphQL. GraphQL Types are the
 * building blocks for object types, queries, mutations, etc. They are
 * types like String, Int, Id or even Object Types you create.
 *
 * i.e. `String`, `String!`, `[String]`, `[String!]`, `[String]!`
 *
 * GraphQL Types are used to define the entirety of schema.
 */
class GraphqlType {
    constructor(type, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_Type(type);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_GraphqlTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GraphqlType);
            }
            throw error;
        }
        this.type = type;
        this.isList = options?.isList ?? false;
        this.isRequired = options?.isRequired ?? false;
        this.isRequiredList = options?.isRequiredList ?? false;
        this.intermediateType = options?.intermediateType;
    }
    /**
     * `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static id(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.id);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.ID, options);
    }
    /**
     * `String` scalar type is a free-form human-readable text.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static string(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.string);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.STRING, options);
    }
    /**
     * `Int` scalar type is a signed non-fractional numerical value.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static int(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.int);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.INT, options);
    }
    /**
     * `Float` scalar type is a signed double-precision fractional value.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static float(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.float);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.FLOAT, options);
    }
    /**
     * `Boolean` scalar type is a boolean value: true or false.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static boolean(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.boolean);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.BOOLEAN, options);
    }
    /**
     * `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsDate(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsDate);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_DATE, options);
    }
    /**
     * `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsTime(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsTime);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_TIME, options);
    }
    /**
     * `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsDateTime(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsDateTime);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_DATE_TIME, options);
    }
    /**
     * `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsTimestamp(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsTimestamp);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_TIMESTAMP, options);
    }
    /**
     * `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`)
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsEmail(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsEmail);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_EMAIL, options);
    }
    /**
     * `AWSJson` scalar type represents a JSON string.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsJson(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsJson);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_JSON, options);
    }
    /**
     * `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsUrl(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsUrl);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_URL, options);
    }
    /**
     * `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsPhone(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsPhone);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_PHONE, options);
    }
    /**
     * `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsIpAddress(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsIpAddress);
            }
            throw error;
        }
        return new GraphqlType(schema_base_1.Type.AWS_IP_ADDRESS, options);
    }
    /**
     * an intermediate type to be added as an attribute
     * (i.e. an interface or an object type)
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     * - intermediateType
     */
    static intermediate(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_GraphqlTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.intermediate);
            }
            throw error;
        }
        if (!options?.intermediateType) {
            throw new Error('GraphQL Type of interface must be configured with corresponding Intermediate Type');
        }
        return new GraphqlType(schema_base_1.Type.INTERMEDIATE, options);
    }
    /**
     * Generate the string for this attribute
     */
    toString() {
        // If an Object Type, we use the name of the Object Type
        let type = this.intermediateType ? this.intermediateType?.name : this.type;
        // If configured as required, the GraphQL Type becomes required
        type = this.isRequired ? `${type}!` : type;
        // If configured with isXxxList, the GraphQL Type becomes a list
        type = this.isList || this.isRequiredList ? `[${type}]` : type;
        // If configured with isRequiredList, the list becomes required
        type = this.isRequiredList ? `${type}!` : type;
        return type;
    }
    /**
     * Generate the arguments for this field
     */
    argsToString() {
        return '';
    }
    /**
     * Generate the directives for this field
     */
    directivesToString(_modes) {
        return '';
    }
}
exports.GraphqlType = GraphqlType;
_a = JSII_RTTI_SYMBOL_1;
GraphqlType[_a] = { fqn: "@aws-cdk/aws-appsync.GraphqlType", version: "1.165.0" };
/**
 * Fields build upon Graphql Types and provide typing
 * and arguments.
 */
class Field extends GraphqlType {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_FieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Field);
            }
            throw error;
        }
        const props = {
            isList: options.returnType.isList,
            isRequired: options.returnType.isRequired,
            isRequiredList: options.returnType.isRequiredList,
            intermediateType: options.returnType.intermediateType,
        };
        super(options.returnType.type, props);
        this.fieldOptions = options;
    }
    /**
     * Generate the args string of this resolvable field
     */
    argsToString() {
        if (!this.fieldOptions || !this.fieldOptions.args) {
            return '';
        }
        return Object.keys(this.fieldOptions.args).reduce((acc, key) => `${acc}${key}: ${this.fieldOptions?.args?.[key].toString()} `, '(').slice(0, -1) + ')';
    }
    /**
     * Generate the directives for this field
     */
    directivesToString(modes) {
        if (!this.fieldOptions || !this.fieldOptions.directives) {
            return '';
        }
        return this.fieldOptions.directives.reduce((acc, directive) => `${acc}${directive._bindToAuthModes(modes).toString()} `, '\n  ').slice(0, -1);
    }
}
exports.Field = Field;
_b = JSII_RTTI_SYMBOL_1;
Field[_b] = { fqn: "@aws-cdk/aws-appsync.Field", version: "1.165.0" };
/**
 * Resolvable Fields build upon Graphql Types and provide fields
 * that can resolve into operations on a data source.
 */
class ResolvableField extends Field {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ResolvableFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ResolvableField);
            }
            throw error;
        }
        const props = {
            returnType: options.returnType,
            args: options.args,
        };
        super(props);
        this.fieldOptions = options;
    }
}
exports.ResolvableField = ResolvableField;
_c = JSII_RTTI_SYMBOL_1;
ResolvableField[_c] = { fqn: "@aws-cdk/aws-appsync.ResolvableField", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,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